/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.codegen;

import jeus.util.codegen.ClassWriter;

public class MethodWriter {
    protected StringBuffer body = new StringBuffer(400);
    protected String newline;
    protected String indentUnit;
    protected int indentCount;
    protected String indent;
    protected boolean concatenation = false;

    public MethodWriter(ClassWriter cw) {
        this.newline = cw.newline;
        this.indentUnit = cw.indentUnit;
        this.indentCount = 0;
        this.adjustIndent();
    }

    private void adjustIndent() {
        this.indent = this.indentUnit + this.indentUnit;
        for (int i = 0; i < this.indentCount; ++i) {
            this.indent = this.indent + this.indentUnit;
        }
    }

    public void indentIn() {
        ++this.indentCount;
        this.adjustIndent();
    }

    public void indentOut() {
        --this.indentCount;
        this.adjustIndent();
    }

    public void write(String code) {
        this.w(code);
    }

    public void writeln(String code) {
        this.wln(code);
    }

    public void writeln() {
        this.wln();
    }

    public void wI() {
        this.indentIn();
    }

    public void wO() {
        this.indentOut();
    }

    public void w(String code) {
        if (!this.concatenation) {
            this.body.append(this.indent);
        }
        this.body.append(code);
        this.concatenation = true;
    }

    public void wln() {
        this.body.append(this.newline);
        this.concatenation = false;
    }

    public void wln(String code) {
        this.w(code);
        this.wln();
    }

    public void wlnI(String code) {
        this.wln(code);
        this.indentIn();
    }

    public void wlnO(String code) {
        this.wln(code);
        this.indentOut();
    }

    public void wIlnO(String code) {
        this.indentIn();
        this.wln(code);
        this.indentOut();
    }

    public void wOln(String code) {
        this.indentOut();
        this.wln(code);
    }

    public void wOlnI(String code) {
        this.indentOut();
        this.wln(code);
        this.indentIn();
    }

    public void wtry() {
        this.wln("try {");
        this.indentIn();
    }

    public void wcatch(String exDecl) {
        this.indentOut();
        this.wln("} catch(" + exDecl + ") {");
        this.indentIn();
    }

    public void wfinally() {
        this.indentOut();
        this.wln("} finally {");
        this.indentIn();
    }

    public void wtryend() {
        this.indentOut();
        this.wln("}");
    }

    public String getCode() {
        return this.body.toString();
    }
}

