/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.NoInitialContextException;
import jeus.management.JMXManagerException;
import jeus.util.JeusRuntimeException;
import jeus.util.console.AbstractConsole;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.Example;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;

public class AppcompilerConsole
extends AbstractConsole {
    private Option verboseOption = new Option("verbose", "set verbose mode (loglevel: FINEST)");
    private Option keepOption = new Option("keep", "keep generated stub sources to the client view path or module file(directory)");
    private Option jspmapOption = new Option("jspmap", "generate servlet-mapping table (jeus_jspmap.xml)");
    private ArgumentedOption clientviewArgumentedOption = new ArgumentedOption("client", "client_view_path", "specify client_view_path. <client_view_path>.jar file which contains interfaces and stub files will be generated. If this is empty, stub files will be added to the application file(directory). This option is only used for EJB application or EAR application which has EJB module(application).", null, true, false);
    private ArgumentedOption ejbJarXmlArgumentedOption = new ArgumentedOption("ejb-jar", "ejb-jar.xml_path", "specify ejb-jar.xml path which the EJB application will use", null, true, false);
    private ArgumentedOption jeusEjbDdXmlArgumentedOption = new ArgumentedOption("jeus-ejb-dd", "jeus-ejb-dd.xml_path", "specify jeus-ejb-dd.xml path which the EJB application will use", null, true, false);
    private ArgumentedOption systemPropertyAndValueArgumentedOption = new ArgumentedOption("D", "property=value", "set system property. This option can be used more than once.", null, true, true);
    private ArgumentedOption systemPropertyFileArgumentedOption = new ArgumentedOption("properties=", "filename", "set system properties from the specified system property file.", null, true, true);
    private OptionalArgument appFileOrDirNameOptionalArgument = new OptionalArgument("application_file_or_directory_name", "specify the application (EAR, EJB, WAR) file or directory name");
    private boolean verbose = false;
    private boolean keep = false;
    private boolean jspmap = false;
    private String clientview = null;
    private String ejbJarXml = null;
    private String jeusEjbDdXml = null;
    private String systemPropertyAndValue = null;
    private String systemPropertyFile = null;
    private String appFileOrDirName = null;

    public AppcompilerConsole(String consoleName, String simpleHelp) {
        super(consoleName, simpleHelp, false);
        this.registerArgument((Argument)this.verboseOption);
        this.registerArgument((Argument)this.keepOption);
        this.registerArgument((Argument)this.jspmapOption);
        this.registerArgument((Argument)this.clientviewArgumentedOption);
        this.registerArgument((Argument)this.ejbJarXmlArgumentedOption);
        this.registerArgument((Argument)this.jeusEjbDdXmlArgumentedOption);
        this.registerArgument((Argument)this.systemPropertyAndValueArgumentedOption);
        this.registerArgument((Argument)this.systemPropertyFileArgumentedOption);
        this.registerArgument((Argument)this.appFileOrDirNameOptionalArgument);
        this.registerExample(new Example("appcompiler app", "generate EJB interface impl and stub files, jsp servlets and webservice endpoints for the ear application in the app directory"));
        this.registerExample(new Example("appcompiler app.ear", "generate EJB interface impl and stub files, jsp servlets and webservice endpoints for the ear application"));
        this.registerExample(new Example("appcompiler app.jar", "generate EJB interface impl and stub files for the app.jar file"));
        this.registerExample(new Example("appcompiler app.war", "generate jsp servlets and webservice endpoints for the app.war file"));
    }

    public boolean checkArguments(String[] args) throws JeusImproperCommanderException {
        try {
            this.consume(args);
        }
        catch (JeusImproperCommanderException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new JeusRuntimeException(t);
        }
        if (this.getHelpOption().isSet()) {
            this.printConsoleHelp();
            return false;
        }
        if (this.verboseOption.isSet()) {
            this.verbose = true;
        }
        if (this.clientviewArgumentedOption.isSet()) {
            this.clientview = this.clientviewArgumentedOption.getValue();
        }
        if (this.keepOption.isSet()) {
            this.keep = true;
        }
        if (this.jspmapOption.isSet()) {
            this.jspmap = true;
        }
        if (this.ejbJarXmlArgumentedOption.isSet()) {
            this.ejbJarXml = this.ejbJarXmlArgumentedOption.getValue();
        }
        if (this.jeusEjbDdXmlArgumentedOption.isSet()) {
            this.jeusEjbDdXml = this.jeusEjbDdXmlArgumentedOption.getValue();
        }
        if (this.systemPropertyAndValueArgumentedOption.isSet()) {
            this.systemPropertyAndValue = this.systemPropertyAndValueArgumentedOption.getValue();
        }
        if (this.systemPropertyFileArgumentedOption.isSet()) {
            this.systemPropertyFile = this.systemPropertyFileArgumentedOption.getValue();
        }
        if (this.appFileOrDirNameOptionalArgument.isSet()) {
            this.appFileOrDirName = this.appFileOrDirNameOptionalArgument.getValue();
        }
        return true;
    }

    public void printAppcompilerHelp() {
        this.printConsoleHelp();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public boolean isKeep() {
        return this.keep;
    }

    public boolean isJspmap() {
        return this.jspmap;
    }

    public String getClientview() {
        return this.clientview;
    }

    public String getEjbJarXml() {
        return this.ejbJarXml;
    }

    public String getJeusEjbDdXml() {
        return this.jeusEjbDdXml;
    }

    public String getSystemPropertyAndValue() {
        return this.systemPropertyAndValue;
    }

    public String getSystemPropertyFile() {
        return this.systemPropertyFile;
    }

    public String getAppFileOrDirName() {
        return this.appFileOrDirName;
    }

    protected int runConsole() throws JeusImproperCommanderException {
        return 0;
    }

    protected void registerCommands() {
    }

    protected String getPrompt() {
        return null;
    }

    protected String getWelcomeMessage() {
        return null;
    }

    protected MBeanServerConnection initializeConnection() throws JMXManagerException, NoInitialContextException {
        return null;
    }

    protected ObjectName getTargetObjectName() throws Exception {
        return null;
    }

    public static void main(String[] args) {
        AppcompilerConsole commander = new AppcompilerConsole("appcompiler", "make EJB interface impl and stub classes, jsp servlets and webservice endpoint for application");
        int result = commander.mainMethod(args);
        if (result >= 0) {
            System.exit(result);
        }
    }
}

