/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console;

import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.naming.NoInitialContextException;
import jeus.management.JMXManagerException;
import jeus.util.console.AbstractConsole;
import jeus.util.console.Argument;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;

public class EncryptionConsoleTool
extends AbstractConsole {
    private Option protectKeyOption = new Option("protectkey", "use protected secret key");
    private OptionalArgument algorithmOption = new OptionalArgument("algorithm", "set encryption algorithm");
    private OptionalArgument plainTextOption = new OptionalArgument("plaintext", "encrypt the string");
    private boolean isProtectMode;
    private String algorithm;
    private String plaintext;

    public EncryptionConsoleTool(String consoleName, String simpleHelp) {
        super(consoleName, simpleHelp, false);
        this.registerArgument((Argument)this.protectKeyOption);
        this.registerArgument((Argument)this.algorithmOption);
        this.registerArgument((Argument)this.plainTextOption);
    }

    public boolean checkArguments(String[] args) {
        try {
            this.consume(args);
        }
        catch (JeusImproperCommanderException e) {
            StringBuffer buf = new StringBuffer();
            for (String arg : args) {
                buf.append(arg + " ");
            }
            out.println("Invalid argument : " + buf.toString());
            return false;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (this.getHelpOption().isSet()) {
            this.printConsoleHelp();
            return false;
        }
        if (!this.algorithmOption.isSet() || !this.plainTextOption.isSet()) {
            this.printConsoleHelp();
            return false;
        }
        if (this.protectKeyOption.isSet()) {
            this.isProtectMode = true;
        }
        this.algorithm = this.algorithmOption.getValue();
        this.plaintext = this.plainTextOption.getValue();
        if (this.isProtectMode && this.algorithm.equalsIgnoreCase("base64") | this.algorithm.equalsIgnoreCase("sha")) {
            System.out.println("base64 and sha are not required secret key.");
            System.out.println("retry encryption with non-protect mode");
            this.printConsoleHelp();
            return false;
        }
        return true;
    }

    public String getCipherAlgorithm() {
        return this.algorithm;
    }

    public String getPlainText() {
        return this.plaintext;
    }

    public boolean isProtectMode() {
        return this.isProtectMode;
    }

    protected int runConsole() throws JeusImproperCommanderException {
        return 0;
    }

    protected void registerCommands() {
    }

    protected String getPrompt() {
        return null;
    }

    protected String getWelcomeMessage() {
        return null;
    }

    protected MBeanServerConnection initializeConnection() throws JMXManagerException, NoInitialContextException {
        return null;
    }

    protected ObjectName getTargetObjectName() throws Exception {
        return null;
    }
}

