/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.List;
import java.util.Vector;
import jeus.server.BootFailureException;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.command.NodeControllerCommand;

public class BootCommand
extends NodeControllerCommand {
    private Option allOption = new Option("all", "boot all JEUS Manager clustered", true);

    public BootCommand(String nodeName, String realNodeName) {
        super("boot", "boot the JEUS Manager", nodeName, realNodeName);
        this.registerArgument((Argument)this.allOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PrintStream out) throws Exception {
        if (!this.openConnection(out)) {
            return;
        }
        try {
            if (!this.allOption.isSet()) {
                Vector v = this.stub.boot();
                this.writeBootLog(v, out);
            } else {
                Vector v = this.stub.bootall(false);
                for (int i = 0; i < v.size(); ++i) {
                    out.println(v.get(i) + " boot done");
                }
            }
        }
        catch (BootFailureException ex) {
            out.println(this.nodeName + " boot failed");
        }
        finally {
            this.closeConnection();
        }
    }

    private void writeBootLog(List v, PrintStream out) {
        out.println(this.nodeName + " boot done");
        for (int i = 0; i < v.size(); ++i) {
            out.println((String)v.get(i));
        }
    }
}

