/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Collections;
import java.util.Vector;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class ConListCommand
extends JeusMBeanCommand {
    private OptionalArgument nodeNameArg = new OptionalArgument("node_name", "the JEUS Manager node name", "the JEUS Manager admin connected");

    public ConListCommand() {
        super("conlist", "list engine containers in the JEUS Manager");
        this.registerArgument((Argument)this.nodeNameArg);
    }

    public void run(PrintStream out) throws Exception {
        boolean found = false;
        String nodeName = this.nodeNameArg.isSet() ? this.nodeNameArg.getValue() : this.nodeName;
        JEUSManagerMBean jeusManager = this.getJeusManagerMoMBean();
        String[] nodeNames = jeusManager.getNodesFromDescriptor();
        for (int i = 0; i < nodeNames.length; ++i) {
            if (!nodeNames[i].equals(nodeName)) continue;
            found = true;
            break;
        }
        if (found) {
            ContainerManagerServiceMBean manager = this.getContainerManagerService(nodeName);
            Vector conList = manager.getContainerList(nodeName);
            if (conList.isEmpty()) {
                out.println("There is no running container in the node " + nodeName);
            } else {
                Collections.sort(conList);
                out.println("Engine container list of the node " + nodeName);
                for (int i = 1; i <= conList.size(); ++i) {
                    String name = (String)conList.get(i - 1);
                    out.println("\t[" + i + "] " + name);
                }
            }
        } else {
            out.println("The node " + nodeName + "does not exist.");
        }
    }
}

