/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.util.CUtility;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.OptionalArgument;
import jeus.util.console.ToggleArguments;
import jeus.util.console.command.JeusMBeanCommand;

public class DumpCommand
extends JeusMBeanCommand {
    private Option all = new Option("a", "dump all containers in the node", true);
    private Argument container = new OptionalArgument("container_name", "the container name to dump", "the JEUS Manager process");

    public DumpCommand() {
        super("dump", "dump thread stacks on JEUS process");
        this.registerArgument((Argument)new ToggleArguments(new Argument[]{this.all, this.container}));
    }

    public void run(PrintStream out) throws Exception {
        if (this.all.isSet()) {
            J2EEServerMBean[] servers = this.getJ2EEServerMBeans(this.nodeName);
            for (int i = 0; i < servers.length; ++i) {
                J2EEServerMBean server = servers[i];
                server.dumpThread();
            }
            out.println("dump all containers in the node " + this.nodeName + " successfully");
        } else if (this.container.isSet()) {
            String containerName = this.container.getValue();
            try {
                int pid = Integer.parseInt(containerName);
                CUtility.dumpThreadStack((int)pid);
                out.println("dump the process " + pid + " successfully, see the terminal of the process");
            }
            catch (NumberFormatException ex) {
                J2EEServerMBean server = this.getJ2EEServerMBean(containerName);
                server.dumpThread();
                out.println("dump the container " + containerName + " successfully");
            }
        } else {
            JEUSManagerMBean manager = this.getJeusManagerMoMBean();
            manager.dumpThread();
            out.println("dump the node " + this.nodeName + " successfully");
        }
    }
}

