/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import jeus.server.JeusServerException;
import jeus.util.console.Argument;
import jeus.util.console.Example;
import jeus.util.console.command.NodeControllerCommand;
import jeus.util.message.JeusMessage_Manager;

public class FtpCommand
extends NodeControllerCommand {
    private Argument source = new Argument("source", "the file path to transfer");
    private Argument destination;

    public FtpCommand(String nodeName, String realNodeName) {
        super("ftp", "transfer file to the JEUS Manager", nodeName, realNodeName);
        this.registerArgument(this.source);
        this.destination = new Argument("ftpRoot:/destination", "the url to save the file in JEUS Manager node \n \tftpRoot: jeus (=$JEUS_HOME), web (=$webhome) ");
        this.registerArgument(this.destination);
        this.registerExample(new Example("ftp d:\\dir1\\a.dat jeus:/temp/b.dat", "transfer d:\\dir1\\a.dat of local node to $JEUS_HOME/temp/b.dat in JEUS Manager node"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(PrintStream out) throws Exception {
        String destinationValue = this.destination.getValue();
        FtpCommand.checkFtpRoot(destinationValue);
        if (!this.openConnection(out)) {
            return;
        }
        try {
            String sourceValue = this.source.getValue();
            boolean ret = false;
            try {
                ret = this.stub.ftp(sourceValue, destinationValue, false);
            }
            catch (JeusServerException jse) {
                out.println(jse.getMessage());
                this.closeConnection();
                return;
            }
            if (ret) {
                out.println(sourceValue + " -> " + destinationValue + " ftp successful");
            } else {
                out.println(sourceValue + " -> " + destinationValue + " ftp failed");
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public static void checkFtpRoot(String cmds) throws JeusServerException {
        if (!cmds.startsWith("jeus:/") && !cmds.startsWith("web:/")) {
            throw new JeusServerException(JeusMessage_Manager.MGR_40);
        }
    }
}

