/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.management.ObjectName;
import jeus.jdbc.connectionpool.ConnectionPoolException;
import jeus.management.JMXUtility;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.server.service.JDBCResourceServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.Option;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JDBCGroup;

public class JDBCControlClusterDataSourceCommand
extends JeusMBeanCommand {
    private Argument exportNameArg;
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container in which JDBC Datasource is located ", "use container.nameproperty");
    private Option allOption;
    private Option failbackOption;
    private Option listOption;
    private static final String errorMessage = "Failed to get the data source list";

    public JDBCControlClusterDataSourceCommand() {
        super("controlcds", "Control the states of the specified cluster data source of the node");
        this.registerArgument((Argument)this.conOption);
        this.failbackOption = new Option("failback", "failback to the primary data source", true);
        this.registerArgument((Argument)this.failbackOption);
        this.listOption = new Option("list", "list the data sources of cluster data source", true);
        this.registerArgument((Argument)this.listOption);
        this.allOption = new Option("all", "Control all cluster data sources of all nodes clustered", true);
        this.registerArgument((Argument)this.allOption);
        this.exportNameArg = new Argument("export_name", "the JNDI name of cluster data source");
        this.registerArgument(this.exportNameArg);
    }

    public void run(PrintStream out) throws Exception {
        String dataSourceName = this.exportNameArg.getValue();
        JDBCResourceMBean[] resourceMBeans = this.conOption.isSet() ? new JDBCResourceMBean[]{this.getJDBCResource(this.conOption.getValue())} : JDBCGroup.getCachedJDBCResourceMBeans();
        if (resourceMBeans == null || resourceMBeans.length == 0) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command");
        }
        if (!this.failbackOption.isSet()) {
            this.printClusteredDataSources(resourceMBeans[0], dataSourceName, out);
            return;
        }
        if (this.listOption.isSet()) {
            this.printClusteredDataSources(resourceMBeans[0], dataSourceName, out);
        }
        if (this.allOption.isSet()) {
            ObjectName[] names = JMXUtility.queryJDBCResourceServices(this.utility);
            JDBCResourceServiceMBean[] jdbcResourceServices = this.getJDBCResourceServices(names);
            if (this.failbackOption.isSet()) {
                for (int i = 0; i < jdbcResourceServices.length; ++i) {
                    JDBCResourceServiceMBean jdbcResourceService = jdbcResourceServices[i];
                    this.doFailback(jdbcResourceService, dataSourceName, out);
                }
            }
        } else {
            JDBCResourceServiceMBean jdbcResourceService = this.getJDBCResourceService();
            if (this.failbackOption.isSet()) {
                this.doFailback(jdbcResourceService, dataSourceName, out);
            }
        }
    }

    private void doFailback(JDBCResourceServiceMBean jdbcResourceService, String dataSourceName, PrintStream out) {
        try {
            jdbcResourceService.failbackClusterDataSource(dataSourceName);
            out.println("Done successfully");
        }
        catch (Exception e) {
            if (e instanceof ConnectionPoolException) {
                out.println("Failback " + e.getMessage() + "; please check the server-side log");
            }
            out.println("Failed to control [" + dataSourceName + "]");
            e.printStackTrace();
        }
    }

    private void printClusteredDataSources(JDBCResourceMBean mbean, String dataSourceName, PrintStream out) {
        try {
            String[] list = mbean.getDataSourceListOfClusterDataSource(dataSourceName);
            if (list != null) {
                out.println("--------------------");
                out.println("data source list");
                out.println("--------------------");
                for (int i = 0; i < list.length; ++i) {
                    out.println(list[i]);
                }
                out.println("--------------------");
            } else {
                out.println("Failed to get the data source list; please check the server-side log");
            }
        }
        catch (Exception e) {
            if (e instanceof ConnectionPoolException) {
                out.println("Failed to get the data source list; " + e.getMessage());
            }
            out.println(errorMessage);
            e.printStackTrace(out);
        }
    }
}

