/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.rmi.RemoteException;
import jeus.jdbc.console.ConnectionPoolControllerException;
import jeus.jdbc.info.CPInfo;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JDBCGroup;
import jeus.util.message.JeusMessage_JDBC;

public class JDBCInfoCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container in which JDBC Datasource is located ", "use container.name");
    private ArgumentedOption intervalOption;
    private ArgumentedOption repeatOption;

    public JDBCInfoCommand() {
        super("dsinfo", "show JDBC DataSource information");
        this.registerArgument((Argument)this.conOption);
        this.intervalOption = new ArgumentedOption("i", "interval");
        this.registerArgument((Argument)this.intervalOption);
        this.repeatOption = new ArgumentedOption("k", "repeat_number");
        this.registerArgument((Argument)this.repeatOption);
    }

    public void run(PrintStream out) throws Exception {
        JDBCResourceMBean[] resourceMBeans = null;
        resourceMBeans = this.conOption.isSet() ? new JDBCResourceMBean[]{this.getJDBCResource(this.conOption.getValue())} : JDBCGroup.getCachedJDBCResourceMBeans();
        if (resourceMBeans == null || resourceMBeans.length == 0) {
            throw new JeusImproperCommanderException("set container name by using -con option or setProperty command");
        }
        if (!this.intervalOption.isSet() && !this.repeatOption.isSet()) {
            for (JDBCResourceMBean resourceMBean : resourceMBeans) {
                this.printCPInfo(resourceMBean, out);
            }
        } else if (this.intervalOption.isSet() && this.repeatOption.isSet()) {
            int interval = Integer.parseInt(this.intervalOption.getValue());
            int count = Integer.parseInt(this.repeatOption.getValue());
            for (int i = 0; i < count; ++i) {
                for (JDBCResourceMBean resourceMBean : resourceMBeans) {
                    this.printCPInfo(resourceMBean, out);
                }
                if (i >= count - 1) continue;
                this.waitForSeconds(interval);
            }
        } else {
            throw new JeusImproperCommanderException(JeusMessage_JDBC._85);
        }
    }

    private void printCPInfo(JDBCResourceMBean resourceMBean, PrintStream out) throws ConnectionPoolControllerException {
        CPInfo[] cp;
        try {
            cp = resourceMBean.getCPInfo();
        }
        catch (RemoteException e) {
            throw new ConnectionPoolControllerException(JeusMessage_JDBC._78, (Throwable)e);
        }
        out.println("================================================================================");
        out.println("Datasource information for container '" + resourceMBean.getContainerName() + "'");
        out.println("================================================================================");
        out.println("id     name        min  max  active  idle  disp  total  waiting  working");
        out.println("================================================================================");
        for (int i = 0; i < cp.length; ++i) {
            String cpName = JDBCInfoCommand.printFixSize((String)cp[i].toString(), (int)16);
            int total = cp[i].getActive() + cp[i].getIdle() + cp[i].getDisposable();
            out.println(JDBCInfoCommand.printFixSize((String)(i + 1 + ""), (int)3) + cpName + JDBCInfoCommand.printFixSize((String)(cp[i].getMin() + ""), (int)5) + JDBCInfoCommand.printFixSize((String)(cp[i].getMax() + ""), (int)5) + JDBCInfoCommand.printFixSize((String)(cp[i].getActive() + ""), (int)8) + JDBCInfoCommand.printFixSize((String)(cp[i].getIdle() + ""), (int)6) + JDBCInfoCommand.printFixSize((String)(cp[i].getDisposable() + ""), (int)6) + JDBCInfoCommand.printFixSize((String)(total + ""), (int)7) + JDBCInfoCommand.printFixSize((String)(cp[i].isWaiting() + ""), (int)10) + cp[i].isWorking());
        }
        if (cp.length == 0) {
            out.println("No created connection pool");
        }
        out.println("================================================================================");
        out.println("= disp : disposable connections, total = active + idle + disp");
        out.println("================================================================================");
    }
}

