/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import javax.naming.NameNotFoundException;
import jeus.management.j2ee.J2EEServerMBean;
import jeus.util.JNDIUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.JeusGroup;

public class JndiCommand
extends JeusMBeanCommand {
    private ArgumentedOption containerName = new ArgumentedOption("con", "container_name", "container to perform lookup");
    private Argument name;

    public JndiCommand() {
        super("jndi", "get binded object information to jndi");
        this.registerArgument((Argument)this.containerName);
        this.name = new Argument("bound name", "the name bound to jndi");
        this.registerArgument(this.name);
    }

    public void run(PrintStream out) throws Exception {
        J2EEServerMBean[] j2EEServerMBeans;
        String jndiName = this.name.getValue();
        if (jndiName.contains("\\")) {
            out.println("This command does not support \\");
            return;
        }
        if (jndiName.equals("*")) {
            out.println("This command does not support wildcard.");
            return;
        }
        if (this.containerName.isSet()) {
            if (!this.isContainerRunning(this.containerName.getValue())) {
                out.println(this.containerName.getValue() + " is not running");
                return;
            }
            j2EEServerMBeans = new J2EEServerMBean[]{this.getJ2EEServerMBean(this.containerName.getValue())};
        } else {
            j2EEServerMBeans = JeusGroup.getCachedJ2EEServerMBeans();
        }
        try {
            if (j2EEServerMBeans == null || j2EEServerMBeans.length == 0) {
                String jndiInfo = JNDIUtil.getJndiInfo(jndiName, this.nodeName);
                if (jndiInfo == null) {
                    out.println("The jndiName " + jndiName + " does not exist");
                } else {
                    out.println(jndiInfo);
                }
            } else if (JndiCommand.isSetProperty()) {
                for (J2EEServerMBean server : j2EEServerMBeans) {
                    String jndiInfo = server.getJndiInfo(jndiName);
                    String conName = server.getObjectName().getKeyProperty("name");
                    out.println("================= [JNDI List for " + conName + "] =================");
                    out.println(jndiInfo);
                }
            } else {
                String jndiInfo = JNDIUtil.getJndiInfo(jndiName, this.nodeName);
                if (jndiInfo == null) {
                    out.println("The jndiName " + jndiName + " does not exist");
                } else {
                    out.println(jndiInfo);
                }
            }
        }
        catch (NameNotFoundException ex) {
            out.println("The jndiName " + jndiName + " does not exist");
        }
    }
}

