/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.util.console.Argument;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class MBeanListCommand2
extends JeusMBeanCommand {
    private OptionalArgument objectName = new OptionalArgument("objectname", "The ObjectName of mbean to list up", "all mbeans");

    public MBeanListCommand2() {
        super("mbeanlist", "list mbeans");
        this.registerArgument((Argument)this.objectName);
    }

    public void run(PrintStream out) throws Exception {
        Vector mbeanList = JMXUtility.queryMBeanList(this.utility, this.nodeName, this.objectName.isSet() ? this.objectName.getValue() : null);
        TreeSet<String> objectNameTree = new TreeSet<String>();
        for (ObjectName objectName : mbeanList) {
            objectNameTree.add(objectName.toString());
        }
        Iterator iter = objectNameTree.iterator();
        while (iter.hasNext()) {
            out.println((String)iter.next());
        }
    }
}

