/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.command.JeusMBeanCommand;

public class NodeListCommand
extends JeusMBeanCommand {
    private Option all = new Option("a", "perform nodelist commands to all node clustered", true);

    public NodeListCommand() {
        super("nodelist", "list node that is clustered with the node admin connected");
        this.registerArgument((Argument)this.all);
    }

    public void run(PrintStream out) throws Exception {
        if (this.all.isSet()) {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<String> nextNodeList = new ArrayList<String>();
            nextNodeList.add(this.nodeName);
            while (nextNodeList.size() > 0) {
                String nodeName = (String)nextNodeList.remove(0);
                if (list.contains(nodeName)) continue;
                try {
                    JEUSManagerMBean manager = this.getJeusManagerMoMBean();
                    String[] aliveNodeNames = manager.getAliveNodeNames();
                    NodeListCommand.writeString((String)nodeName, (String[])aliveNodeNames, (PrintStream)out);
                    list.add(nodeName);
                    for (int j = 0; j < aliveNodeNames.length; ++j) {
                        String aliveNodeName = aliveNodeNames[j];
                        if (list.contains(aliveNodeName)) continue;
                        nextNodeList.add(aliveNodeName);
                    }
                }
                catch (Exception ex) {
                }
            }
        } else {
            JEUSManagerMBean manager = this.getJeusManagerMoMBean();
            String[] aliveNodeNames = manager.getAliveNodeNames();
            NodeListCommand.writeString((String[])aliveNodeNames, (PrintStream)out);
        }
    }
}

