/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Hashtable;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.server.service.JDBCResourceServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.Option;
import jeus.util.console.command.JeusMBeanCommand;

public class ReconfigCommand
extends JeusMBeanCommand {
    private Argument datasource = new Argument("datasource_name", "the name of datasource to reconfig");
    private Option all;

    public ReconfigCommand() {
        super("reconfig", "reconfig datasource");
        this.registerArgument(this.datasource);
        this.all = new Option("all", "reconfig all datasources in all nodes clustered", true);
        this.registerArgument((Argument)this.all);
    }

    public void run(PrintStream out) throws Exception {
        String datasourceName = this.datasource.getValue();
        if (!this.all.isSet()) {
            JDBCResourceServiceMBean jdbcResourceService = this.getJDBCResourceService();
            if (jdbcResourceService.reconfigDataSources(datasourceName, new Hashtable())) {
                out.println("reconfig " + datasourceName + " successfully");
            } else {
                out.println("fail to reconfig " + datasourceName);
            }
        } else {
            ObjectName[] names = JMXUtility.queryJDBCResourceServices(this.utility);
            JDBCResourceServiceMBean[] jdbcResourceServices = this.getJDBCResourceServices(names);
            for (int i = 0; i < jdbcResourceServices.length; ++i) {
                JDBCResourceServiceMBean jdbcResourceService = jdbcResourceServices[i];
                if (!jdbcResourceService.reconfigDataSources(datasourceName, new Hashtable())) continue;
                out.println("reconfig " + datasourceName + " successfully on " + names[i].getKeyProperty("JeusManager"));
            }
        }
    }
}

