/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.Collections;
import java.util.StringTokenizer;
import java.util.Vector;
import jeus.management.j2ee.JEUSManagerMBean;
import jeus.server.service.ContainerManagerServiceMBean;
import jeus.util.console.Argument;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;

public class SelectContainerCommand
extends JeusMBeanCommand {
    private OptionalArgument indexNum;

    public SelectContainerCommand() {
        super("setcon", "Select the engine container with index number. You can see the index of engine container by 'conlist' command. If the option is not set, it acts the same as 'conlist'");
        this.addAliasName("sc");
        this.indexNum = new OptionalArgument("index of engine container", "index which indicates the engine container in the node");
        this.registerArgument((Argument)this.indexNum);
    }

    public void run(PrintStream out) throws Throwable {
        boolean found = false;
        JEUSManagerMBean jeusManager = this.getJeusManagerMoMBean();
        String[] nodeNames = jeusManager.getNodesFromDescriptor();
        for (int i = 0; i < nodeNames.length; ++i) {
            if (!nodeNames[i].equals(this.nodeName)) continue;
            found = true;
            break;
        }
        if (found) {
            ContainerManagerServiceMBean manager = this.getContainerManagerService(this.nodeName);
            Vector conList = manager.getContainerList(this.nodeName);
            if (conList.isEmpty()) {
                out.println("There is no running container in the node " + this.nodeName + ".");
                return;
            }
            Collections.sort(conList);
            if (this.indexNum.isSet()) {
                StringTokenizer tokenizer = new StringTokenizer(this.indexNum.getValue(), ",");
                Vector<String> listOfIndexes = new Vector<String>();
                while (tokenizer.hasMoreTokens()) {
                    listOfIndexes.add(tokenizer.nextToken());
                }
                int[] indexes = new int[listOfIndexes.size()];
                try {
                    for (int i = 0; i < listOfIndexes.size(); ++i) {
                        indexes[i] = Integer.parseInt((String)listOfIndexes.get(i));
                        if (conList.size() >= indexes[i] && indexes[i] >= 1) continue;
                        out.println("Wrong index : execute conlist and confirm the index of engine container you want to select");
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    out.println("Invalid argument : it shall be one integer or the list of integers.(ex. 1 or 3,5,7)");
                    return;
                }
                StringBuffer containerNames = new StringBuffer(32);
                for (int i = 0; i < indexes.length; ++i) {
                    String containerName = (String)conList.get(indexes[i] - 1);
                    containerNames.append(containerName).append(";");
                    out.println(containerName + " selected");
                }
                SelectContainerCommand.setProperty((String)"container.name", (String)containerNames.toString());
            } else {
                out.println("Engine container list of the node " + this.nodeName);
                for (int i = 1; i <= conList.size(); ++i) {
                    String name = (String)conList.get(i - 1);
                    out.println("\t[" + i + "] " + name);
                }
            }
        } else {
            out.println("The node " + this.nodeName + "does not exist.");
        }
    }
}

