/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.ServletMBean;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.ServletInfo;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebModuleDeployInfo;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OptionalArgument;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;

public class WCInfoCommand
extends JeusMBeanCommand {
    private ArgumentedOption conOption;
    private OptionalArgument contextGroup;
    private OptionalArgument context;
    private OptionalArgument servlet;

    public WCInfoCommand() {
        super("info", "report current deployment infomation");
        this.conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
        this.contextGroup = new OptionalArgument("ContextGroup", "context group name");
        this.context = new OptionalArgument("Context", "context name");
        this.servlet = new OptionalArgument("Servlet", "servlet name");
        this.servlet.setPreArg((Argument)this.context);
        this.context.setPreArg((Argument)this.contextGroup);
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)this.contextGroup);
        this.registerArgument((Argument)this.context);
        this.registerArgument((Argument)this.servlet);
    }

    public WCInfoCommand(String commandName, String simpleHelp, MBeanServerConnection utility) {
        super(commandName, simpleHelp);
    }

    public void run(PrintStream out) throws Exception {
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine = null;
            String containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running servlet engine.");
        }
        String ctxGroupName = null;
        String contextName = null;
        String servletName = null;
        if (this.contextGroup.isSet()) {
            ctxGroupName = this.contextGroup.getValue();
        }
        if (this.context.isSet()) {
            contextName = this.context.getValue();
        }
        if (this.servlet.isSet()) {
            servletName = this.servlet.getValue();
        }
        WebEngineMoMBean webMBean = null;
        String containerName = null;
        block2: for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
            int i;
            webMBean = (WebEngineMoMBean)conNamdAndwebMBean.getValue();
            containerName = (String)conNamdAndwebMBean.getKey();
            ArrayList<ContextGroupMoMBean> groupMBeans = new ArrayList<ContextGroupMoMBean>();
            out.println("");
            out.println("< ContainerName : " + containerName + " >");
            String[] groups = webMBean.getContextGroups();
            String[] destroyedGroups = webMBean.getDestroyedGroups();
            if (groups != null && groups.length > 0) {
                for (i = 0; i < groups.length; ++i) {
                    ObjectName group = new ObjectName(groups[i]);
                    ContextGroupMoMBean groupMBean = JMXUtility.getProxy(this.utility, group, ContextGroupMoMBean.class, false);
                    groupMBeans.add(groupMBean);
                }
            }
            for (i = 0; i < destroyedGroups.length; ++i) {
                out.println("< ContextGroup : " + destroyedGroups[i] + " (Destroyed) >");
            }
            for (ContextGroupMoMBean grpMBean : groupMBeans) {
                String grpName = JMXUtility.getNameValue(grpMBean.getObjectName());
                if (ctxGroupName != null && !grpName.equals(ctxGroupName)) continue;
                out.println("< ContextGroup : " + grpName + " >");
                WebModuleDeployInfo[] winfo = grpMBean.getDeployObjects();
                if (winfo.length == 0) continue;
                for (int i2 = 0; i2 < winfo.length; ++i2) {
                    ObjectName ctxObjName = winfo[i2].getObjectName();
                    String ctxName = winfo[i2].getName();
                    if (ctxName.equals("") || contextName != null && !ctxName.equals(contextName)) continue;
                    if (winfo[i2].isTerminated()) {
                        out.println("    Context : " + ctxName + " (Destroyed)");
                    } else {
                        out.println("    Context : " + ctxName);
                        WebModuleMBean ctxMBean = JMXUtility.getProxy(this.utility, ctxObjName, WebModuleMBean.class, false);
                        String[] servletNames = ctxMBean.getservlets();
                        if (servletNames == null || servletNames.length == 0) continue;
                        for (int j = 0; j < servletNames.length; ++j) {
                            ObjectName srvObjName = new ObjectName(servletNames[j]);
                            String srvName = JMXUtility.getNameValue(srvObjName);
                            if (servletName != null && !srvName.equals(servletName)) continue;
                            ServletMBean servlet = JMXUtility.getProxy(this.utility, srvObjName, ServletMBean.class, false);
                            ServletInfo servletInfo = servlet.getServletInfo();
                            String servletClass = servletInfo.getServletClass();
                            String jspFileName = servletInfo.getJspFileName();
                            int state = servletInfo.getState();
                            String msg = "    " + j + ":[" + srvName + "] ";
                            if (state == 1) {
                                msg = msg + "<Ready> ";
                            } else if (state == 2) {
                                msg = msg + "<Suspended> ";
                            } else if (state == 3) {
                                msg = msg + "<Destroyed> ";
                            } else if (state == 0) {
                                msg = msg + "<NotLoaded> ";
                            }
                            msg = jspFileName != null ? msg + "jspfile: " + jspFileName : msg + "class: " + servletClass;
                            out.println(msg + ", total_reqs: " + servletInfo.getTotalRequests());
                            if (servletName != null) break;
                        }
                    }
                    out.println("");
                    if (contextName != null) break;
                }
                out.println("");
                if (ctxGroupName == null) continue;
                continue block2;
            }
        }
    }
}

