/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.rmi.ServerException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebListenerMoMBean;
import jeus.server.service.JeusLogServiceMBean;
import jeus.util.ErrorMsgManager;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.StringUtil;
import jeus.util.console.AbstractConsoleUtil;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;
import jeus.util.logging.ConsoleHandler;
import jeus.util.logging.JeusLevel;
import jeus.util.message.JeusMessage_Manager;
import jeus.util.message.JeusMessage_WebContainer0;

public class WCSetConfigInfoCommand
extends JeusMBeanCommand {
    private PrintStream out;
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
    private ArgumentedOption contextGroup = new ArgumentedOption("cg", "context-group", "set context group configuration");
    private ArgumentedOption context;
    private ArgumentedOption listener;
    private ArgumentedOption tMin;
    private ArgumentedOption tMax;
    private ArgumentedOption tRate;
    private ArgumentedOption tIdle;
    private ArgumentedOption tMwq;
    private ArgumentedOption tMq;
    private ArgumentedOption tMtat;
    private ArgumentedOption tnt;
    private ArgumentedOption trt;
    private ArgumentedOption tmi;
    private ArgumentedOption smi;
    private ArgumentedOption rmi;
    private ArgumentedOption stm;
    private ArgumentedOption ar;
    private ArgumentedOption ell;
    private ArgumentedOption to;

    public WCSetConfigInfoCommand() {
        super("setcfg", "set configuration information");
        ArgumentedOption virtualHost = new ArgumentedOption("vh", "vitual-host", "set virtual host configuration");
        this.context = new ArgumentedOption("c", "context", "set context configuration");
        this.listener = new ArgumentedOption("cn", "listener-id", "set thread pool configuration");
        this.tMin = new ArgumentedOption("tmin", "number", "set minimun threads");
        this.tMax = new ArgumentedOption("tmax", "number", "set maximum threads");
        this.tRate = new ArgumentedOption("trate", "number", "set changin rate of threas");
        this.tIdle = new ArgumentedOption("tidle", "msec", "set idle time of threads");
        this.tMwq = new ArgumentedOption("tmwq", "number", "set maximum wait queue size");
        this.tMq = new ArgumentedOption("tmq", "number", "set maximun queue size");
        this.tMtat = new ArgumentedOption("tmtat", "number", "set max thread active time");
        this.tnt = new ArgumentedOption("tnt", "number|rate", "set notify threshold");
        this.trt = new ArgumentedOption("trt", "number|rate", "set restart threashold");
        this.tmi = new ArgumentedOption("tmi", "msec", "set ThreadPool Monitoring Interval");
        this.smi = new ArgumentedOption("smi", "msec", "set Session Monitoring Interval");
        this.rmi = new ArgumentedOption("rmi", "msec", "set ServletReload Monitoring Interval");
        this.stm = new ArgumentedOption("stm", "minutes", "set SessionTimeoutMinitue");
        this.ar = new ArgumentedOption("ar", "true|false", "set AutoReload");
        this.ell = new ArgumentedOption("ell", "level", "set error log level");
        this.to = new ArgumentedOption("to", "index", "takeover to server(index)(webtob only). index - main:0, backup1:1, backup2:2..");
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)this.contextGroup);
        this.registerArgument((Argument)virtualHost);
        this.registerArgument((Argument)this.context);
        this.registerArgument((Argument)this.listener);
        this.registerArgument((Argument)this.tMin);
        this.registerArgument((Argument)this.tMax);
        this.registerArgument((Argument)this.tRate);
        this.registerArgument((Argument)this.tIdle);
        this.registerArgument((Argument)this.tMwq);
        this.registerArgument((Argument)this.tMq);
        this.registerArgument((Argument)this.tMtat);
        this.registerArgument((Argument)this.tnt);
        this.registerArgument((Argument)this.trt);
        this.registerArgument((Argument)this.tmi);
        this.registerArgument((Argument)this.smi);
        this.registerArgument((Argument)this.rmi);
        this.registerArgument((Argument)this.stm);
        this.registerArgument((Argument)this.ar);
        this.registerArgument((Argument)this.ell);
        this.registerArgument((Argument)this.to);
    }

    public void run(PrintStream out) throws Exception {
        String containerName;
        this.out = out;
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine = null;
            containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running servlet engine.");
        }
        WebEngineMoMBean webMBean = null;
        containerName = null;
        for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
            webMBean = (WebEngineMoMBean)conNamdAndwebMBean.getValue();
            containerName = (String)conNamdAndwebMBean.getKey();
            this.setWebContainerConfig(containerName, webMBean);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setWebContainerConfig(String containerName, WebEngineMoMBean engineMBean) throws Exception {
        String errorLogLevel;
        ContextGroupMoMBean groupMBean;
        String[] groups;
        String listenerId = this.listener.getValue();
        this.out.println("");
        this.out.println("< ContainerName : " + containerName + " >");
        if (listenerId != null && (groups = engineMBean.getContextGroups()) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                ObjectName group = new ObjectName(groups[i]);
                ContextGroupMoMBean groupMBean2 = JMXUtility.getProxy(this.utility, group, ContextGroupMoMBean.class, false);
                ObjectName listener = groupMBean2.getListenerByName(listenerId);
                if (listener == null) {
                    return;
                }
                WebListenerMoMBean listenerMBean = JMXUtility.getProxy(this.utility, listener, WebListenerMoMBean.class, false);
                ObjectName tpoolNames = listenerMBean.getPoolByName(listenerId);
                if (tpoolNames == null) continue;
                ThreadPoolMoMBean tpoolMBean = JMXUtility.getProxy(this.utility, tpoolNames, ThreadPoolMoMBean.class, false);
                if (tpoolMBean != null) {
                    if (this.tMin.isSet()) {
                        tpoolMBean.setmin(Integer.parseInt(this.tMin.getValue()));
                    }
                    if (this.tMax.isSet()) {
                        tpoolMBean.setmax(Integer.parseInt(this.tMax.getValue()));
                    }
                    if (this.tRate.isSet()) {
                        tpoolMBean.setstep(Integer.parseInt(this.tRate.getValue()));
                    }
                    if (this.tIdle.isSet()) {
                        tpoolMBean.setmaxIdleTime(Long.parseLong(this.tIdle.getValue()));
                    }
                    if (this.tMwq.isSet()) {
                        tpoolMBean.setmaxWaitQueue(Integer.parseInt(this.tMwq.getValue()));
                    }
                    if (this.tMq.isSet()) {
                        tpoolMBean.setmaxQueue(Integer.parseInt(this.tMq.getValue()));
                    }
                    if (this.tMtat.isSet()) {
                        tpoolMBean.setMaxThreadActiveTime(this.tMtat.getValue());
                    }
                    if (this.tnt.isSet()) {
                        tpoolMBean.setNotifyThreshold(this.tnt.getValue());
                    }
                    if (this.trt.isSet()) {
                        tpoolMBean.setRestartThreshold(this.trt.getValue());
                    }
                }
                if (!this.to.isSet()) continue;
                groupMBean2.webtobFailback(listenerId, this.to.getValue());
            }
        }
        if (this.tmi.isSet()) {
            engineMBean.setcheckThreadPool(Long.parseLong(this.tmi.getValue()));
        }
        if (this.smi.isSet()) {
            engineMBean.setcheckSession(Long.parseLong(this.smi.getValue()));
        }
        if (this.rmi.isSet()) {
            engineMBean.setcheckClassReload(Long.parseLong(this.rmi.getValue()));
        }
        String ctxGroupName = this.contextGroup.getValue();
        ObjectName group = engineMBean.getContextGroup(ctxGroupName);
        if (ctxGroupName == null) {
            group = new ObjectName(engineMBean.getContextGroups()[0]);
        }
        if ((groupMBean = JMXUtility.getProxy(this.utility, group, ContextGroupMoMBean.class, false)) == null) {
            throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1002, (Object)ctxGroupName));
        }
        if (this.stm.isSet()) {
            groupMBean.setSessionTimeout(this.stm.getValue());
        }
        if ((errorLogLevel = this.ell.getValue()) != null) {
            errorLogLevel = errorLogLevel.toLowerCase();
            Level level = Level.ALL;
            if (errorLogLevel.startsWith("all")) {
                level = Level.ALL;
            } else if (errorLogLevel.startsWith("severe")) {
                level = Level.SEVERE;
            } else if (errorLogLevel.startsWith("warning")) {
                level = Level.WARNING;
            } else if (errorLogLevel.startsWith("info")) {
                level = Level.INFO;
            } else if (errorLogLevel.startsWith("config")) {
                level = Level.CONFIG;
            } else if (errorLogLevel.equals("fine")) {
                level = Level.FINE;
            } else if (errorLogLevel.equals("finer")) {
                level = Level.FINER;
            } else if (errorLogLevel.equals("finest")) {
                level = Level.FINEST;
            }
            String[] cmds = new String[]{"loglevel", "-con", containerName, "-set-handler", "jeus.servlet", level.toString()};
            this.setLoggingLevel(this.utility, cmds, this.nodeName);
        }
        String ctxName = this.context.getValue();
        String autoReload = this.ar.getValue();
        if (autoReload == null) return;
        if (ctxName != null) {
            ObjectName context = groupMBean.getContextByName(ctxName);
            if (context == null) throw new ServerException(ErrorMsgManager.getLocalizedString((int)JeusMessage_WebContainer0._1003, (Object)ctxName));
            WebModuleMBean ctxMBean = JMXUtility.getProxy(this.utility, context, WebModuleMBean.class, false);
            ctxMBean.setAutoReload(autoReload);
            return;
        } else {
            String[] ctxs = groupMBean.getWebModules();
            for (int i = 0; i < ctxs.length; ++i) {
                ObjectName ctx = new ObjectName(ctxs[i]);
                WebModuleMBean ctxMBean = JMXUtility.getProxy(this.utility, ctx, WebModuleMBean.class, false);
                ctxMBean.setAutoReload(autoReload);
            }
        }
    }

    protected void setLoggingLevel(MBeanServerConnection utility, String[] cmds, String node) throws IOException, IllegalJeusSystemNameException {
        cmds = AbstractConsoleUtil.removeElements((String[])cmds);
        String container = null;
        boolean forced = false;
        boolean setHandler = false;
        while (cmds.length > 0) {
            if (cmds[0].equals("-con")) {
                container = cmds[1];
                node = StringUtil.getNodeNameFromContainerName((String)container);
                cmds = AbstractConsoleUtil.removeElements((String[])cmds, (int[])new int[]{0, 1});
                continue;
            }
            if (cmds[0].equals("-node")) {
                node = cmds[1];
                cmds = AbstractConsoleUtil.removeElements((String[])cmds, (int[])new int[]{0, 1});
                continue;
            }
            if (cmds[0].equals("-set-handler")) {
                setHandler = true;
                cmds = AbstractConsoleUtil.removeElements((String[])cmds);
                continue;
            }
            if (!cmds[0].equals("-f")) break;
            forced = true;
            cmds = AbstractConsoleUtil.removeElements((String[])cmds);
        }
        if (cmds.length == 0) {
            throw new JeusImproperCommanderException(JeusMessage_Manager.MGR_20);
        }
        String loggerName = cmds[0];
        String handler = null;
        String level = null;
        if (cmds.length > 2) {
            handler = cmds[1];
            level = cmds[2];
        } else if (cmds.length > 1) {
            level = cmds[1];
        }
        ObjectName logServiceName = JMXUtility.queryLogService(utility, node, container);
        JeusLogServiceMBean logService = JMXUtility.getProxy(utility, logServiceName, JeusLogServiceMBean.class, false);
        boolean isNodeJeusLogger = logServiceName.getKeyProperty("J2EEServer").equals("null");
        if (level == null) {
            level = logService.getLogLevel(loggerName);
            this.out.println("logger name : " + loggerName + "\tlevel : " + level);
            while (loggerName != null) {
                String[] handlerNames = logService.getHandlerList(loggerName);
                boolean isConsoleHandlerIncluded = false;
                for (int i = 0; i < handlerNames.length; ++i) {
                    String handlerName = handlerNames[i];
                    String handlerType = logService.getHandlerClassName(loggerName, handlerName);
                    if (handlerType.equals(ConsoleHandler.class.getName())) {
                        isConsoleHandlerIncluded = true;
                    }
                    this.out.println("\thandler name : " + handlerName + "\tclass : " + handlerType);
                }
                boolean useParentHandler = logService.isUseParentHandler(loggerName);
                this.out.println("\tuseParentHandler : " + useParentHandler);
                if (!isNodeJeusLogger && loggerName.equals("jeus") && isConsoleHandlerIncluded) {
                    loggerName = "jeus";
                    logService = JMXUtility.getProxy(utility, JMXUtility.queryLogService(utility, node, null), JeusLogServiceMBean.class, false);
                    this.out.println("node jeus logger");
                    isNodeJeusLogger = true;
                    continue;
                }
                if (useParentHandler) {
                    if ((loggerName = logService.getParentLogger(loggerName)) == null) {
                        this.out.println("no parent logger");
                        continue;
                    }
                    this.out.println("parent logger name : " + loggerName);
                    continue;
                }
                break;
            }
        } else if (handler != null) {
            logService.setHandlerLevel(loggerName, handler, level);
        } else {
            logService.setLogLevel(loggerName, level, forced);
            level = logService.getLogLevel(loggerName);
            this.out.println("logger name : " + loggerName);
            Level levelObject = JeusLevel.parse((String)level);
            while (loggerName != null) {
                String[] handlerNames = logService.getHandlerList(loggerName);
                boolean isConsoleHandlerIncluded = false;
                for (int i = 0; i < handlerNames.length; ++i) {
                    String handlerName = handlerNames[i];
                    String handlerLevel = logService.getHandlerLevel(loggerName, handlerName);
                    String handlerType = logService.getHandlerClassName(loggerName, handlerName);
                    if (handlerType.equals(ConsoleHandler.class.getName())) {
                        isConsoleHandlerIncluded = true;
                    }
                    if (levelObject.intValue() < JeusLevel.parse((String)handlerLevel).intValue()) {
                        if (setHandler) {
                            logService.setHandlerLevel(loggerName, handlerName, levelObject.getName());
                            this.out.println("\tThe level of handler " + handlerName + " is set from " + handlerLevel + " to " + levelObject + " and it will publish all log messages of the logger");
                            continue;
                        }
                        this.out.println("\tThe level of handler " + handlerName + " is " + handlerLevel + " and it will NOT publish finer log messages");
                        continue;
                    }
                    this.out.println("\tThe level of handler " + handlerName + " is " + handlerLevel + "and it will publish all log messages of the logger");
                }
                boolean useParentHandler = logService.isUseParentHandler(loggerName);
                this.out.println("\tuseParentHandler : " + useParentHandler);
                if (!isNodeJeusLogger && loggerName.equals("jeus") && isConsoleHandlerIncluded) {
                    loggerName = "jeus";
                    logService = JMXUtility.getProxy(utility, JMXUtility.queryLogService(utility, node, null), JeusLogServiceMBean.class, false);
                    this.out.println("node jeus logger");
                    isNodeJeusLogger = true;
                    continue;
                }
                if (useParentHandler) {
                    if ((loggerName = logService.getParentLogger(loggerName)) == null) {
                        this.out.println("no parent logger");
                        continue;
                    }
                    this.out.println("parent logger name : " + loggerName);
                    continue;
                }
                break;
            }
        }
    }
}

