/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.WebModuleMBean;
import jeus.management.j2ee.servlet.ContextGroupMoMBean;
import jeus.management.j2ee.servlet.SessionContainerCentralStatsImpl;
import jeus.management.j2ee.servlet.SessionContainerMoMBean;
import jeus.management.j2ee.servlet.SessionContainerStatsImpl;
import jeus.management.j2ee.servlet.SessionRouterStatsImpl;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.ThreadPoolStatsImpl;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebEngineStatsImpl;
import jeus.management.j2ee.servlet.WebListenerMoMBean;
import jeus.management.j2ee.servlet.WebModuleStatsImpl;
import jeus.server.service.SessionManagerMoMBean;
import jeus.server.service.SessionManagerStatsImpl;
import jeus.sessionmanager.central.CentralSessionServerInfo;
import jeus.sessionmanager.central.RemoteCentralSessionServerInfo;
import jeus.sessionmanager.distributed.DistributedSessionServerInfo;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.CountRepeater;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.OnceRepeater;
import jeus.util.console.Option;
import jeus.util.console.Repeater;
import jeus.util.console.TimeRepeater;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;

public class WCStatCommand
extends JeusMBeanCommand {
    private PrintStream out;
    private ArgumentedOption conOption;
    private Option memory;
    private Option thread;
    private Option request;
    private Option session;
    private ArgumentedOption repeatInterval;
    private ArgumentedOption repeatCount;
    private ArgumentedOption repeatTime;
    private Repeater repeater;

    public WCStatCommand() {
        super("stat", "report current state");
        this.addAliasName("st");
        this.conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
        this.memory = new Option("m", "memory state");
        this.thread = new Option("t", "thread state");
        this.request = new Option("r", "request state");
        this.session = new Option("s", "session state");
        this.repeatInterval = new ArgumentedOption("i", "sec", "set the interval of monitoring");
        this.repeatCount = new ArgumentedOption("k", "number", "set the repeat count");
        this.repeatTime = new ArgumentedOption("l", "sec", "set the repeat time");
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)this.memory);
        this.registerArgument((Argument)this.thread);
        this.registerArgument((Argument)this.request);
        this.registerArgument((Argument)this.session);
        this.registerArgument((Argument)this.repeatInterval);
        this.registerArgument((Argument)this.repeatCount);
        this.registerArgument((Argument)this.repeatTime);
    }

    public void run(PrintStream out) throws Exception {
        String containerName;
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine;
            containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(this.conOption.getValue());
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created. \n");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running servlet engine.");
        }
        this.out = out;
        this.selectRepeater();
        while (this.repeater.isRepeatable()) {
            for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
                WebEngineMoMBean webMBean = (WebEngineMoMBean)conNamdAndwebMBean.getValue();
                containerName = (String)conNamdAndwebMBean.getKey();
                this.executeStatCommand(containerName, webMBean);
            }
        }
    }

    private void selectRepeater() {
        int interval = 0;
        int time = 0;
        int count = 0;
        if (this.repeatInterval.getValue() != null) {
            interval = Integer.parseInt(this.repeatInterval.getValue());
        }
        if (this.repeatTime.getValue() != null) {
            time = Integer.parseInt(this.repeatTime.getValue());
        }
        if (this.repeatCount.getValue() != null) {
            count = Integer.parseInt(this.repeatCount.getValue());
        }
        this.repeater = interval > 0 ? (count > 0 ? new CountRepeater(count, interval, this.out) : (time > 0 ? new TimeRepeater(time, interval, this.out) : new OnceRepeater())) : new OnceRepeater();
        this.repeater.reset();
    }

    private void executeStatCommand(String containerName, WebEngineMoMBean engineMBean) throws Exception {
        ContextGroupMoMBean groupMBean;
        String[] groups;
        boolean all = false;
        if (!(this.session.isSet() || this.memory.isSet() || this.thread.isSet() || this.request.isSet())) {
            all = true;
        }
        this.out.println("< ContainerName : " + containerName + " >");
        if (all || this.session.isSet()) {
            String[] groups2;
            ObjectName sessionContainerName2 = engineMBean.getSessionContainer();
            if (sessionContainerName2 != null) {
                this.statSession(engineMBean.getObjectName(), sessionContainerName2);
            }
            if ((groups2 = engineMBean.getContextGroups()) != null && groups2.length > 0) {
                for (int i = 0; i < groups2.length; ++i) {
                    ObjectName group = new ObjectName(groups2[i]);
                    ContextGroupMoMBean groupMBean2 = JMXUtility.getProxy(this.utility, group, ContextGroupMoMBean.class, false);
                    List managerList = groupMBean2.getSessionContainer();
                    for (ObjectName sessionContainerName2 : managerList) {
                        if (sessionContainerName2 == null) continue;
                        this.statSession(group, sessionContainerName2);
                    }
                }
            }
            this.getCentralSessionServerInfo();
        }
        if (all || this.memory.isSet()) {
            this.statMem(engineMBean);
        }
        if ((all || this.thread.isSet()) && (groups = engineMBean.getContextGroups()) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                ObjectName group = new ObjectName(groups[i]);
                groupMBean = JMXUtility.getProxy(this.utility, group, ContextGroupMoMBean.class, false);
                this.statWorkerThread(groupMBean);
            }
        }
        if ((all || this.request.isSet()) && (groups = engineMBean.getContextGroups()) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                ObjectName group = new ObjectName(groups[i]);
                groupMBean = JMXUtility.getProxy(this.utility, group, ContextGroupMoMBean.class, false);
                this.statContextRequest(groupMBean);
            }
        }
    }

    private void statSession(ObjectName parentName, ObjectName sessionContainerName) throws Exception {
        SessionContainerMoMBean mbean = JMXUtility.getProxy(this.utility, sessionContainerName, SessionContainerMoMBean.class, false);
        this.out.println("< (" + JMXUtility.getNameValue(parentName) + "," + sessionContainerName.getKeyProperty("name") + ") session information >");
        int type = mbean.getContainerType();
        if (type == 1) {
            SessionContainerStatsImpl stats = (SessionContainerStatsImpl)mbean.getstats();
            this.out.println(" - number of local sessions             : " + stats.getLocalSessionCount().getCount());
        } else if (type == 2) {
            SessionContainerCentralStatsImpl stats = (SessionContainerCentralStatsImpl)mbean.getstats();
            this.out.println(" - number of local sessions             : " + stats.getLocalSessionCount().getCount());
            this.out.println(" - number of remote active sessions     : " + stats.getRemoteActiveSessionCount().getCount());
            this.out.println(" - number of remote passivated sessions : " + stats.getRemotePassivatedSessionCount().getCount());
            this.out.println(" - number of total connections          : " + stats.getTotalConnectionCount().getCount());
            this.out.println(" - number of in-use connections         : " + stats.getInuseConnectionCount().getCount());
            CentralSessionServerInfo info = mbean.getCentralServerInfo();
            this.out.println(" - primary session server name          : " + info.getPrimaryServerName());
            this.out.println(" - backup session server name           : " + info.getBackupServerName());
            Vector cinfo = info.getCurrentServerInfo();
            Enumeration enum1 = cinfo.elements();
            while (enum1.hasMoreElements()) {
                RemoteCentralSessionServerInfo cserver = (RemoteCentralSessionServerInfo)enum1.nextElement();
                this.out.println(" - current session server               : " + cserver.getCurrentServerName());
                this.out.println("     - alive               ? " + cserver.isServerStatus());
                this.out.println("     - active sessions     : " + cserver.getRemoteActiveSessionSize());
                this.out.println("     - passivated sessions : " + cserver.getRemotePassivatedSessionSize());
            }
        } else if (type == 3) {
            SessionRouterStatsImpl stats = (SessionRouterStatsImpl)mbean.getstats();
            this.out.println(" - number of active local sessions      : " + stats.getLocalSessionCount().getCount());
            this.out.println(" - number of passivated local sessions  : " + stats.getPassivatedSessionCount().getCount());
            this.out.println(" - local file-db size                   : " + stats.getLocalFileDbSize().getCount());
            this.out.println(" - number of active backup sessions     : " + stats.getBackupSessionCount().getCount());
            this.out.println(" - number of passivated backup sessions : " + stats.getPassivatedBackupSessionCount().getCount());
            this.out.println(" - backup file-db size                  : " + stats.getBackupFileDbSize().getCount());
            this.out.println(" - number of connections                : " + stats.getConnectionCount().getCount());
            DistributedSessionServerInfo info = mbean.getDistributedServerInfo();
            this.out.println(" - server name                          : " + info.getServerName());
            this.out.println(" - backup name                          : " + info.getBackupName());
            Hashtable conns = mbean.getP2PConnectionStatus();
            Enumeration enum1 = conns.keys();
            while (enum1.hasMoreElements()) {
                String connName = (String)enum1.nextElement();
                Boolean alive = (Boolean)conns.get(connName);
                this.out.println("     - " + connName + (alive != false ? "alive" : "dead"));
            }
        } else {
            this.out.println("fail to get session information");
        }
        this.out.println("");
    }

    private void getCentralSessionServerInfo() throws IOException {
        SessionManagerMoMBean[] sessionManagers = JMXUtility.getProxy(this.utility, JMXUtility.querySessionManagerMo(this.utility, this.nodeName), SessionManagerMoMBean.class, false);
        for (int i = 0; i < sessionManagers.length; ++i) {
            this.out.println("< (" + sessionManagers[i].getManagerName() + ") session memory information >");
            SessionManagerStatsImpl sessionManagerStat = (SessionManagerStatsImpl)sessionManagers[i].getstats();
            this.out.println(" - number of active sessions             : " + sessionManagerStat.getActiveSessionCount().getCount());
            this.out.println(" - number of passivated sessions         : " + sessionManagerStat.getPassivatedSessionCount().getCount());
            this.out.println(" - total session memory                  : " + sessionManagerStat.getTotalSessionMemory().getCount() + " byte(s)");
            this.out.println(" - peak session memory                   : " + sessionManagerStat.getSessionPeakMemory().getCount() + " byte(s)");
            this.out.println(" - session memory size difference(1min)  : " + sessionManagerStat.getMemory1MinuteDifference().getCount() + " byte(s)");
            this.out.println(" - session memory size difference(5min)  : " + sessionManagerStat.getMemory5MinuteDifference().getCount() + " byte(s)");
            this.out.println(" - session memory size difference(15min) : " + sessionManagerStat.getMemory15MinuteDifference().getCount() + " byte(s)");
            this.out.println("");
        }
    }

    private void statMem(WebEngineMoMBean engineMBean) {
        WebEngineStatsImpl stats = (WebEngineStatsImpl)engineMBean.getstats();
        long totalMem = stats.getTotalMemory().getCount();
        long freeMem = stats.getFreeMemory().getCount();
        this.out.println("< memory information >");
        this.out.println("VM Total Memory    = " + totalMem + " Bytes");
        this.out.println("VM Free Memory     = " + freeMem + " Bytes");
        this.out.println("");
    }

    private void statWorkerThread(ContextGroupMoMBean group) throws Exception {
        String contextGroupName = group.getObjectName().getKeyProperty("name");
        String[] listeners = group.getWebListeners();
        if (listeners == null || listeners.length == 0) {
            return;
        }
        for (int i = 0; i < listeners.length; ++i) {
            ObjectName listener = new ObjectName(listeners[i]);
            WebListenerMoMBean listenerMBean = JMXUtility.getProxy(this.utility, listener, WebListenerMoMBean.class, false);
            String[] tpoolNames = listenerMBean.getThreadPools();
            if (tpoolNames == null) continue;
            for (int j = 0; j < tpoolNames.length; ++j) {
                ObjectName tpool = new ObjectName(tpoolNames[j]);
                ThreadPoolMoMBean tpoolMBean = JMXUtility.getProxy(this.utility, tpool, ThreadPoolMoMBean.class, false);
                ThreadPoolStatsImpl stats = (ThreadPoolStatsImpl)tpoolMBean.getstats();
                this.out.println("< thread information(" + contextGroupName + "/" + JMXUtility.getNameValue(tpool) + ") >");
                this.out.println("    - current thread count      : " + stats.getAllThreadCount().getCount());
                this.out.println("    - max thread count          : " + stats.getMaxThreadCount().getCount());
                if (stats.getStatisticVersion() == 2) {
                    this.out.println("    - total connection count    : " + stats.getTotalConnectionCount().getCount());
                    this.out.println("    - max queue count           : " + stats.getMaxQueueCount().getCount());
                    this.out.println("    - current queue count       : " + stats.getCurrentQueueCount().getCount());
                    this.out.println("    - remain queue count        : " + stats.getRemainQueueCount().getCount());
                    this.out.println("    - peak queue count          : " + stats.getPeakQueueCount().getCount());
                    this.out.println("    - total queue count         : " + stats.getTotalQueueCount().getCount());
                    this.out.println("    - difference queue 1m count  : " + stats.getDifferenceQueue1MCount().getCount());
                    this.out.println("    - difference queue 5m count  : " + stats.getDifferenceQueue5MCount().getCount());
                    this.out.println("    - difference queue 15m count : " + stats.getDifferenceQueue15MCount().getCount());
                    this.out.println("    - overflow queue count      : " + stats.getOverflowCount().getCount());
                    this.out.println("    - average queue time        : " + stats.getQueueWaitTimeAverage().getCount() + "(ms)");
                } else {
                    this.out.println("    - wait queue count          : " + stats.getWaitQueueCount().getCount());
                }
                this.out.println("");
            }
        }
        this.out.println("");
    }

    private void statContextRequest(ContextGroupMoMBean group) throws Exception {
        String contextGroupName = group.getObjectName().getKeyProperty("name");
        String[] ctxNames = group.getWebModules();
        if (ctxNames == null || ctxNames.length == 0) {
            return;
        }
        for (int i = 0; i < ctxNames.length; ++i) {
            ObjectName ctx = new ObjectName(ctxNames[i]);
            WebModuleMBean ctxMBean = JMXUtility.getProxy(this.utility, ctx, WebModuleMBean.class, false);
            WebModuleStatsImpl stats = (WebModuleStatsImpl)ctxMBean.getstats();
            this.out.println("< request information(" + contextGroupName + "/" + JMXUtility.getNameValue(ctx) + ") >");
            long requestCount = stats.getRequestCount().getCount();
            long totalTime = stats.getProcessingTime().getCount();
            long avgTime = -1L;
            if (requestCount > 0L) {
                avgTime = totalTime / requestCount;
            }
            this.out.println("   - total requests          : " + requestCount);
            this.out.println("   - total processing time   : " + totalTime + " ms");
            this.out.println("   - average processing time : " + avgTime + " ms");
            this.out.println("");
        }
        this.out.println("");
    }
}

