/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.command;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.servlet.ThreadPoolMoMBean;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.management.j2ee.servlet.WebListenerMoMBean;
import jeus.servlet.common.ThreadStateInfo;
import jeus.util.console.Argument;
import jeus.util.console.ArgumentedOption;
import jeus.util.console.CountRepeater;
import jeus.util.console.JeusImproperCommanderException;
import jeus.util.console.MultipleArgumentedOption;
import jeus.util.console.OnceRepeater;
import jeus.util.console.Option;
import jeus.util.console.Repeater;
import jeus.util.console.TimeRepeater;
import jeus.util.console.command.JeusMBeanCommand;
import jeus.util.console.group.ServletEngineGroup;

public class WCThreadInfoCommand
extends JeusMBeanCommand {
    private PrintStream out;
    private ArgumentedOption conOption = new ArgumentedOption("con", "container_name", "container where servlet engine is located", "use container.name property or apply to all containers");
    private MultipleArgumentedOption listener = new MultipleArgumentedOption("li", "listener-id", "listener is");
    private Option request = new Option("r", "request information of threads");
    private Option all = new Option("a", "all information of threads");
    private Option filter = new ArgumentedOption("f", "thread-state", "set the thread state you want to see. thread-state:=[(a)ctive|(i)dle|(b)locked|(r)econnecting]");
    private ArgumentedOption repeatInterval = new ArgumentedOption("i", "sec", "set the interval of gathering data");
    private ArgumentedOption repeatCount = new ArgumentedOption("k", "number", "set the repeat count");
    private ArgumentedOption repeatTime = new ArgumentedOption("l", "sec", "set the repeat duration");
    private Repeater repeater;

    public WCThreadInfoCommand() {
        super("ti", "report detailed thread state");
        this.registerArgument((Argument)this.conOption);
        this.registerArgument((Argument)this.listener);
        this.registerArgument((Argument)this.request);
        this.registerArgument((Argument)this.all);
        this.registerArgument((Argument)this.filter);
        this.registerArgument((Argument)this.repeatInterval);
        this.registerArgument((Argument)this.repeatCount);
        this.registerArgument((Argument)this.repeatTime);
    }

    public void run(PrintStream out) throws Exception {
        String containerName;
        HashMap<Object, Object> webEngineMbeanMap = new HashMap();
        if (this.conOption.isSet()) {
            WebEngineMoMBean webEngine = null;
            containerName = null;
            try {
                containerName = this.conOption.getValue();
                webEngine = this.getWebEngine(containerName);
            }
            catch (Exception e) {
                out.println("[" + containerName + "] container is downed or not created.");
                out.println("");
                return;
            }
            webEngineMbeanMap.put(containerName, webEngine);
        } else {
            webEngineMbeanMap = ServletEngineGroup.getCachedWebEngineMoMBeanMap();
        }
        if (webEngineMbeanMap == null || webEngineMbeanMap.size() == 0) {
            throw new JeusImproperCommanderException("There is no running servlet engine.");
        }
        this.out = out;
        this.selectRepeater();
        while (this.repeater.isRepeatable()) {
            WebEngineMoMBean webMBean = null;
            containerName = null;
            for (Map.Entry<Object, Object> conNamdAndwebMBean : webEngineMbeanMap.entrySet()) {
                webMBean = (WebEngineMoMBean)conNamdAndwebMBean.getValue();
                containerName = (String)conNamdAndwebMBean.getKey();
                this.statThreadPoolDetail(containerName, webMBean);
            }
        }
    }

    private void selectRepeater() {
        int interval = 0;
        int time = 0;
        int count = 0;
        if (this.repeatInterval.getValue() != null) {
            interval = Integer.parseInt(this.repeatInterval.getValue());
        }
        if (this.repeatTime.getValue() != null) {
            time = Integer.parseInt(this.repeatTime.getValue());
        }
        if (this.repeatCount.getValue() != null) {
            count = Integer.parseInt(this.repeatCount.getValue());
        }
        this.repeater = interval > 0 ? (count > 0 ? new CountRepeater(count, interval, this.out) : (time > 0 ? new TimeRepeater(time, interval, this.out) : new OnceRepeater())) : new OnceRepeater();
        this.repeater.reset();
    }

    public void statThreadPoolDetail(String containerName, WebEngineMoMBean webMBean) throws Exception {
        int mode = this.request.isSet() ? ThreadStateInfo.GET_PROCESSING_INFO : (this.all.isSet() ? ThreadStateInfo.GET_ALL_INFO : ThreadStateInfo.GET_RUNNING_STATE);
        Vector listeners = this.listener.getValues();
        ArrayList<ThreadPoolMoMBean> mbeans = new ArrayList<ThreadPoolMoMBean>();
        this.out.println("");
        this.out.println("< ContainerName : " + containerName + " >");
        if (listeners == null || listeners.size() == 0) {
            ObjectName[] names = JMXUtility.queryMBean(this.utility, containerName, null, "ThreadPool_WEBC", null, null, null);
            if (names == null || names.length == 0) {
                return;
            }
            for (int i = 0; i < names.length; ++i) {
                ThreadPoolMoMBean mbean = JMXUtility.getProxy(this.utility, names[i], ThreadPoolMoMBean.class, false);
                mbeans.add(mbean);
            }
        } else {
            Enumeration enum1 = listeners.elements();
            while (enum1.hasMoreElements()) {
                String listenerId = (String)enum1.nextElement();
                ObjectName[] names = JMXUtility.queryMBean(this.utility, containerName, null, "WebListener", listenerId, null, null);
                if (names == null || names.length == 0) {
                    this.out.println(" - no such listener id : " + listenerId);
                    continue;
                }
                WebListenerMoMBean lmbean = JMXUtility.getProxy(this.utility, names[0], WebListenerMoMBean.class, false);
                String[] tpNames = lmbean.getThreadPools();
                for (int i = 0; i < tpNames.length; ++i) {
                    ThreadPoolMoMBean mbean = JMXUtility.getProxy(this.utility, new ObjectName(tpNames[i]), ThreadPoolMoMBean.class, false);
                    mbeans.add(mbean);
                }
            }
        }
        if (mbeans.size() == 0) {
            return;
        }
        for (ThreadPoolMoMBean mbean : mbeans) {
            Vector infos = mbean.getThreadState(mode);
            int activeCount = 0;
            int idleCount = 0;
            int blockedCount = 0;
            int reconnectingCount = 0;
            this.out.println("-- Thread State [" + JMXUtility.getNameValue(mbean.getObjectName()) + "] --");
            int size = infos.size();
            for (int i = 0; i < size; ++i) {
                ThreadStateInfo tinfo = (ThreadStateInfo)infos.elementAt(i);
                if (tinfo.blocked) {
                    ++blockedCount;
                } else if (tinfo.reconnecting) {
                    ++reconnectingCount;
                } else if (tinfo.active) {
                    ++activeCount;
                } else {
                    ++idleCount;
                }
                this.printThreadInfo(tinfo);
            }
            this.out.println("[total : " + (activeCount + idleCount) + "    active : " + activeCount + "    idle : " + idleCount + "    blocked : " + blockedCount + "    reconnecting : " + reconnectingCount + "]");
            this.out.println("");
        }
    }

    private void printThreadInfo(ThreadStateInfo info) {
        if (!this.filter.isSet() || this.filter.getValue() == null) {
            this.out.println(info.toString());
            return;
        }
        if ("a".equalsIgnoreCase(this.filter.getValue()) && info.active) {
            this.out.println(info.toString());
        } else if ("b".equalsIgnoreCase(this.filter.getValue()) && info.blocked) {
            this.out.println(info.toString());
        } else if ("r".equalsIgnoreCase(this.filter.getValue()) && info.reconnecting) {
            this.out.println(info.toString());
        } else if ("i".equalsIgnoreCase(this.filter.getValue()) && !info.active && !info.blocked && !info.reconnecting) {
            this.out.println(info.toString());
        }
    }
}

