/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.group;

import java.io.IOException;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.JDBCResourceMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.console.Command;
import jeus.util.console.Group;

public class JDBCGroup
extends Group {
    private static JDBCResourceMBean[] resourceMBeans = null;

    public JDBCGroup() {
        super("DB Pool", "jdbc");
    }

    public void notifyToChangeProperty(String propertyKey) {
        if (propertyKey.equals("container.name")) {
            try {
                JDBCGroup.getJDBCResourceMBeans();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static JDBCResourceMBean[] getCachedJDBCResourceMBeans() throws IOException, IllegalJeusSystemNameException {
        String[] containerNames = Command.getListProperty((String)"container.name");
        if (containerNames == null) {
            JDBCGroup.getALLJDBCResourceMBeans();
        } else {
            JDBCGroup.getJDBCResourceMBeans();
        }
        return resourceMBeans;
    }

    private static void getALLJDBCResourceMBeans() throws IOException {
        ObjectName[] jdbcResourceObjectNames = JMXUtility.queryJDBCResources(utility, nodeName);
        resourceMBeans = new JDBCResourceMBean[jdbcResourceObjectNames.length];
        for (int i = 0; i < jdbcResourceObjectNames.length; ++i) {
            JDBCGroup.resourceMBeans[i] = JMXUtility.getProxy(utility, jdbcResourceObjectNames[i], JDBCResourceMBean.class, false);
        }
    }

    private static void getJDBCResourceMBeans() throws IllegalJeusSystemNameException, IOException {
        String[] containerNames = Command.getListProperty((String)"container.name");
        resourceMBeans = new JDBCResourceMBean[containerNames.length];
        for (int i = 0; i < containerNames.length; ++i) {
            JDBCGroup.resourceMBeans[i] = JMXUtility.getProxy(utility, JMXUtility.queryJDBCResource(utility, containerNames[i]), JDBCResourceMBean.class, false);
        }
    }
}

