/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.group;

import java.io.IOException;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.security.PolicyMoMBean;
import jeus.management.j2ee.security.SecurityDomainMoMBean;
import jeus.management.j2ee.security.SecurityMoMBean;
import jeus.management.j2ee.security.SubjectMoMBean;
import jeus.util.console.Group;

public class SecurityGroup
extends Group {
    private static String defaultDomain = "SYSTEM_DOMAIN";

    public SecurityGroup() {
        super("Security", "sec");
    }

    public static SecurityMoMBean getSecurityMoMBean() throws Exception {
        ObjectName objectName = JMXUtility.querySecurityService(utility, "SecurityService", nodeName);
        return JMXUtility.getProxy(utility, objectName, SecurityMoMBean.class, false);
    }

    public static SubjectMoMBean getSubjectMoMBean(String domainName) throws IOException {
        if (domainName == null) {
            domainName = defaultDomain;
        }
        ObjectName objectName = JMXUtility.querySecurityDomainService(utility, "Subject", domainName, "SecuritySubject", nodeName);
        return JMXUtility.getProxy(utility, objectName, SubjectMoMBean.class, false);
    }

    public static PolicyMoMBean getPolicyMoMBean(String domainName) throws IOException {
        if (domainName == null) {
            domainName = defaultDomain;
        }
        ObjectName objectName = JMXUtility.querySecurityDomainService(utility, "Policy", domainName, "SecurityPolicy", nodeName);
        return JMXUtility.getProxy(utility, objectName, PolicyMoMBean.class, false);
    }

    public static SecurityDomainMoMBean getSecurityDomainMoMBean(String domainName) throws IOException {
        if (domainName == null) {
            domainName = defaultDomain;
        }
        ObjectName objectName = JMXUtility.querySecurityDomain(utility, domainName, "SecurityDomain", nodeName);
        return JMXUtility.getProxy(utility, objectName, SecurityDomainMoMBean.class, false);
    }
}

