/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.console.group;

import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.management.ObjectName;
import jeus.management.JMXUtility;
import jeus.management.j2ee.servlet.WebEngineMoMBean;
import jeus.util.IllegalJeusSystemNameException;
import jeus.util.JeusRuntimeException;
import jeus.util.console.Command;
import jeus.util.console.Group;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletEngineGroup
extends Group {
    private static HashMap<String, WebEngineMoMBean> webEngineMbeanMap = new HashMap();

    public ServletEngineGroup() {
        super("Servlet", "web");
    }

    public void notifyToChangeProperty(String propertyKey) {
        if (propertyKey.equals("container.name")) {
            try {
                ServletEngineGroup.setWebEngineMoMBeanMap();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static HashMap<String, WebEngineMoMBean> getCachedWebEngineMoMBeanMap() throws IOException, IllegalJeusSystemNameException {
        String[] containerNames = Command.getListProperty((String)"container.name");
        if (containerNames == null) {
            ServletEngineGroup.setALLWebEngineMoMBeanMap();
        } else {
            webEngineMbeanMap.clear();
            Vector runningConList = JMXUtility.getContainerNames(utility, nodeName);
            int containerSize = containerNames.length;
            for (int i = 0; i < containerSize; ++i) {
                String containerName = containerNames[i];
                if (!runningConList.contains(containerName)) continue;
                try {
                    ObjectName webEngineObjectName = JMXUtility.queryWebEngine(utility, containerNames[i]);
                    webEngineMbeanMap.put(containerNames[i], JMXUtility.getProxy(utility, webEngineObjectName, WebEngineMoMBean.class, false));
                    continue;
                }
                catch (JeusRuntimeException e) {
                    // empty catch block
                }
            }
        }
        return webEngineMbeanMap;
    }

    private static void setALLWebEngineMoMBeanMap() throws IOException, IllegalJeusSystemNameException {
        webEngineMbeanMap.clear();
        Vector containers = JMXUtility.getContainerNames(utility, nodeName);
        String[] containerNames = containers.toArray(new String[containers.size()]);
        for (int i = 0; i < containerNames.length; ++i) {
            try {
                ObjectName webEngineObjectName = JMXUtility.queryWebEngine(utility, containerNames[i]);
                webEngineMbeanMap.put(containerNames[i], JMXUtility.getProxy(utility, webEngineObjectName, WebEngineMoMBean.class, false));
                continue;
            }
            catch (JeusRuntimeException e) {
                // empty catch block
            }
        }
    }

    private static void setWebEngineMoMBeanMap() throws IllegalJeusSystemNameException, IOException {
        webEngineMbeanMap.clear();
        String[] containerNames = Command.getListProperty((String)"container.name");
        for (int i = 0; i < containerNames.length; ++i) {
            try {
                webEngineMbeanMap.put(containerNames[i], JMXUtility.getProxy(utility, JMXUtility.queryWebEngine(utility, containerNames[i]), WebEngineMoMBean.class, false));
                continue;
            }
            catch (JeusRuntimeException jeusRuntimeException) {
                // empty catch block
            }
        }
    }
}

