/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.file;

import java.io.File;

public class Repository {
    File fileSystem;
    File appDir;
    String appName;

    public Repository(File root, String theAppName) {
        this.appName = theAppName;
        String mesg = null;
        root.mkdirs();
        if (root == null) {
            mesg = "File System argument is null.";
        } else if (!root.exists()) {
            mesg = "File System doesn't exist: " + root.getPath();
        } else if (!root.isDirectory()) {
            mesg = "File System argument is not a directory: " + root.getPath();
        } else if (!root.canWrite()) {
            mesg = "File System is read-only: " + root.getPath();
        } else if (this.appName == null || this.appName.length() <= 0) {
            mesg = "appName argument is null or empty.";
        } else if (this.appName == null) {
            mesg = "appName argument is null or empty.";
        }
        if (mesg != null) {
            throw new IllegalArgumentException(mesg);
        }
        this.fileSystem = root;
        this.appDir = new File(this.fileSystem, this.appName);
    }

    public boolean createAppDir() {
        return this.appDir.mkdirs();
    }

    public File getAppDir() {
        return this.appDir;
    }

    public String getAppDirName() {
        return this.appDir.toString();
    }

    public String getAppName() {
        return this.appName;
    }

    public static void main(String[] args) {
        Repository rep = new Repository(new File(args[0]), args[1]);
        System.out.println("app name: " + rep.getAppName());
        System.out.println("app dir name: " + rep.getAppDirName());
    }
}

