/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.io;

import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EmptyStackException;
import jeus.util.io.ObjectInputStream;
import jeus.util.io.ObjectStreamClass;
import jeus.util.io.ObjectStreamField;

public class ObjectOutputStream
extends java.io.ObjectOutputStream {
    public static boolean outlog = false;
    private boolean blockDataMode;
    private byte[] buf;
    private int count;
    private OutputStream out;
    private DataOutputStream dos;
    private IOException abortIOException = null;
    private HandleTable handleTable;
    private Object currentObject;
    private ObjectStreamClass currentClassDesc;
    private Stack classDescStack;
    private PutField currentPutFields;
    private Object[] writeObjectArglist = new Object[]{this};
    private static final int INITIAL_BUFFER_SIZE = 64;
    private byte[] data;
    private static final int CDATA_MAX_LEN = 1024;
    private char[] cdata;
    boolean enableReplace;
    private ReplaceTable replaceTable;
    private static final boolean REPLACEABLE = true;
    private static final boolean NOT_REPLACEABLE = false;
    private int recursionDepth = 0;
    boolean useDeprecatedExternalizableFormat = false;
    private boolean enableSubclassImplementation;

    public ObjectOutputStream(OutputStream out) throws IOException {
        this.out = out;
        this.dos = new DataOutputStream(this);
        this.buf = new byte[1024];
        this.writeStreamHeader();
        this.resetStream();
    }

    protected ObjectOutputStream() throws IOException, SecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
        this.enableSubclassImplementation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeObjectOverride(Object obj) throws IOException {
        Object prevObject = this.currentObject;
        ObjectStreamClass prevClassDesc = this.currentClassDesc;
        boolean oldBlockDataMode = this.setBlockData(false);
        ++this.recursionDepth;
        try {
            if (this.serializeNullAndRepeat(obj, true)) {
                return;
            }
            if (this.checkSpecialClasses(obj)) {
                return;
            }
            Class<?> curclass = obj.getClass();
            Class<?> oldclass = null;
            Object altobj = obj;
            this.currentClassDesc = ObjectStreamClass.lookupInternal(curclass);
            if (outlog) {
                ObjectInputStream.log("[OOS/writeObjectOverride] currentClassDesc : " + this.currentClassDesc.getName(), false);
            }
            while (this.currentClassDesc != null && this.currentClassDesc.isReplaceable() && curclass != oldclass) {
                altobj = ObjectStreamClass.invokeMethod(this.currentClassDesc.writeReplaceMethod, altobj, null);
                if (outlog) {
                    ObjectInputStream.log("[OOS/writeObjectOverride] altobj : " + altobj, false);
                }
                oldclass = curclass;
                if (altobj != null) {
                    curclass = altobj.getClass();
                    this.currentClassDesc = ObjectStreamClass.lookupInternal(curclass);
                    continue;
                }
                curclass = null;
                this.currentClassDesc = null;
            }
            if (this.enableReplace) {
                ObjectStreamClass objectStreamClass = this.currentClassDesc = (altobj = this.replaceObject(altobj)) != null ? ObjectStreamClass.lookupInternal(altobj.getClass()) : null;
            }
            if (obj != altobj) {
                if (outlog) {
                    ObjectInputStream.log("[OOS/writeObjectOverride] obj : " + obj + " altobj : " + altobj, false);
                }
                boolean flag = ObjectStreamClass.checkSerializable(altobj.getClass());
                if (altobj != null && !flag) {
                    String clname = altobj.getClass().getName();
                    throw new NotSerializableException(clname);
                }
                if (this.serializeNullAndRepeat(altobj, true)) {
                    this.addReplacement(obj, altobj);
                    return;
                }
                this.addReplacement(obj, altobj);
                if (this.checkSpecialClasses(altobj)) {
                    return;
                }
                obj = altobj;
            }
            if (this.checkSubstitutableSpecialClasses(obj, this.currentClassDesc.forClass())) {
                return;
            }
            this.outputObject(obj);
        }
        catch (IOException ee) {
            ee.printStackTrace();
            if (this.abortIOException == null) {
                try {
                    this.setBlockData(false);
                    this.writeCode(123);
                    this.resetStream();
                    this.setBlockData(false);
                    this.currentClassDesc = ObjectStreamClass.lookupInternal(ee.getClass());
                    this.outputObject(ee);
                    this.resetStream();
                    this.abortIOException = ee;
                }
                catch (IOException fatal) {
                    this.abortIOException = new StreamCorruptedException(fatal.getMessage());
                }
            }
        }
        finally {
            --this.recursionDepth;
            this.currentObject = prevObject;
            this.currentClassDesc = prevClassDesc;
            this.setBlockData(oldBlockDataMode);
        }
        IOException pending = this.abortIOException;
        if (this.recursionDepth == 0) {
            this.abortIOException = null;
        }
        if (pending != null) {
            throw pending;
        }
        if (outlog) {
            ObjectInputStream.log("[OOS/writeObjectOverride] Object : " + obj + " write completed ", false);
        }
    }

    public void useProtocolVersion(int version) throws IOException {
        if (this.handleTable.size() != 0) {
            throw new IllegalStateException("Must call useProtocolVersion before writing any objects to the stream");
        }
        switch (version) {
            case 1: {
                this.useDeprecatedExternalizableFormat = true;
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown version:" + version);
            }
        }
    }

    private boolean checkSpecialClasses(Object obj) throws IOException {
        if (obj instanceof Class) {
            this.outputClass((Class)obj);
            return true;
        }
        if (obj instanceof ObjectStreamClass) {
            this.outputClassDescriptor((ObjectStreamClass)obj);
            return true;
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(Object obj, Class cl) throws IOException {
        if (cl == String.class) {
            this.outputString((String)obj);
            return true;
        }
        if (cl.isArray()) {
            this.outputArray(obj);
            return true;
        }
        return false;
    }

    public void defaultWriteObject() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null) {
            throw new NotActiveException("defaultWriteObject");
        }
        ObjectStreamField[] fields = this.currentClassDesc.getFieldsNoCopy();
        if (fields.length > 0) {
            boolean prevmode = this.setBlockData(false);
            this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), fields);
            this.setBlockData(prevmode);
        }
    }

    public void writeFields() throws IOException {
        if (this.currentObject == null || this.currentClassDesc == null || this.currentPutFields == null) {
            throw new NotActiveException("writeFields");
        }
        boolean prevmode = this.setBlockData(false);
        this.currentPutFields.write(this);
        this.setBlockData(prevmode);
    }

    public void reset() throws IOException {
        if (this.currentObject != null || this.currentClassDesc != null) {
            throw new IOException("Illegal call to reset");
        }
        this.setBlockData(false);
        this.writeCode(121);
        this.resetStream();
        this.abortIOException = null;
    }

    private void resetStream() throws IOException {
        if (this.handleTable == null) {
            this.handleTable = new HandleTable(11, 7.0f);
        } else {
            this.handleTable.clear();
        }
        if (this.classDescStack == null) {
            this.classDescStack = new Stack();
        } else {
            this.classDescStack.setSize(0);
        }
        if (this.replaceTable != null) {
            this.replaceTable.clear();
        }
        this.setBlockData(true);
    }

    protected void annotateClass(Class cl) throws IOException {
    }

    protected void annotateProxyClass(Class cl) throws IOException {
    }

    protected Object replaceObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableReplaceObject(boolean enable) throws SecurityException {
        boolean previous = this.enableReplace;
        if (enable) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission(SUBSTITUTION_PERMISSION);
            }
            this.enableReplace = true;
        } else {
            this.enableReplace = false;
        }
        return previous;
    }

    protected void writeStreamHeader() throws IOException {
        this.writeShort(-21267);
        this.writeShort(5);
    }

    private void outputString(String s) throws IOException {
        int slen = s.length();
        this.handleTable.assignWireOffset(s);
        if (this.cdata == null || this.cdata.length < slen) {
            this.cdata = s.toCharArray();
        } else {
            s.getChars(0, slen, this.cdata, 0);
        }
        long utflen = ObjectOutputStream.getUTFLength(this.cdata, slen);
        if (utflen <= 65535L) {
            this.writeCode(116);
            this.writeShort((int)utflen);
        } else {
            this.writeCode(124);
            this.writeLong(utflen);
        }
        this.writeUTFBody(this.cdata, slen);
        if (slen > 1024) {
            this.cdata = null;
        }
    }

    private static long getUTFLength(char[] chars, int len) {
        long utflen = 0L;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3L;
                continue;
            }
            utflen += 2L;
        }
        return utflen;
    }

    private void writeUTFBody(char[] chars, int len) throws IOException {
        int PADLEN = 2;
        int blimit = this.buf.length - 2;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (this.count >= blimit) {
                if (this.blockDataMode) {
                    if (c >= '\u0001' && c <= '\u007f') {
                        this.write(c);
                        continue;
                    }
                    if (c > '\u07ff') {
                        this.write(0xE0 | c >> 12 & 0xF);
                        this.write(0x80 | c >> 6 & 0x3F);
                        this.write(0x80 | c >> 0 & 0x3F);
                        continue;
                    }
                    this.write(0xC0 | c >> 6 & 0x1F);
                    this.write(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                this.drain();
            }
            if (c >= '\u0001' && c <= '\u007f') {
                this.buf[this.count++] = (byte)c;
                continue;
            }
            if (c > '\u07ff') {
                this.buf[this.count++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buf[this.count++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buf[this.count++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buf[this.count++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
    }

    private void outputClass(Class aclass) throws IOException {
        this.writeCode(118);
        ObjectStreamClass v = ObjectStreamClass.lookupInternal(aclass);
        if (v == null) {
            if (outlog) {
                ObjectInputStream.log("[OOS/outputClass] ObjectStreamClass is NULL!!!", false);
            }
            throw new NotSerializableException(aclass.getName());
        }
        this.outputClassDescriptor(v);
        this.handleTable.assignWireOffset(aclass);
    }

    private void writeClassDescriptor0(ObjectStreamClass classdesc) throws IOException {
        this.writeUTF(classdesc.getName());
        this.writeLong(classdesc.getSerialVersionUID());
        if (outlog) {
            ObjectInputStream.log("[OSC/writeClassDescriptor0] classdesc : " + classdesc + " start", false);
        }
        classdesc.write(this);
        if (outlog) {
            ObjectInputStream.log("[OSC/writeClassDescriptor0] classdesc : " + classdesc + " completed", false);
        }
    }

    protected void writeClassDescriptor(ObjectStreamClass classdesc) throws IOException {
        this.writeClassDescriptor0(classdesc);
    }

    private void outputClassDescriptor(ObjectStreamClass classdesc) throws IOException {
        if (this.serializeNullAndRepeat(classdesc, false)) {
            return;
        }
        Class cl = classdesc.forClass();
        if (!classdesc.forProxyClass) {
            this.writeCode(114);
            this.handleTable.assignWireOffset(classdesc);
            if (this.useDeprecatedExternalizableFormat) {
                this.writeClassDescriptor0(classdesc);
            } else {
                this.writeClassDescriptor(classdesc);
            }
            boolean prevMode = this.setBlockData(true);
            this.annotateClass(cl);
            this.setBlockData(prevMode);
            this.writeCode(120);
            ObjectStreamClass superdesc = classdesc.getSuperclass();
            this.outputClassDescriptor(superdesc);
        } else {
            this.writeCode(125);
            this.handleTable.assignWireOffset(classdesc);
            Class<?>[] interfaces = cl.getInterfaces();
            this.writeInt(interfaces.length);
            for (int i = 0; i < interfaces.length; ++i) {
                this.writeUTF(interfaces[i].getName());
            }
            boolean prevMode = this.setBlockData(true);
            this.annotateProxyClass(cl);
            this.setBlockData(prevMode);
            this.writeCode(120);
            this.outputClassDescriptor(classdesc.getSuperclass());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void outputArray(Object obj) throws IOException {
        Class currclass = this.currentClassDesc.forClass();
        this.writeCode(117);
        this.outputClassDescriptor(this.currentClassDesc);
        this.handleTable.assignWireOffset(obj);
        Class<?> type = currclass.getComponentType();
        if (type.isPrimitive()) {
            if (type == Integer.TYPE) {
                int[] array = (int[])obj;
                int length = array.length;
                int limit = this.buf.length - 4;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    if (this.count > limit) {
                        this.drain();
                    }
                    int v = array[i];
                    this.buf[this.count++] = (byte)(v >>> 24);
                    this.buf[this.count++] = (byte)(v >>> 16);
                    this.buf[this.count++] = (byte)(v >>> 8);
                    this.buf[this.count++] = (byte)(v >>> 0);
                }
                return;
            } else if (type == Byte.TYPE) {
                byte[] array = (byte[])obj;
                int length = array.length;
                this.writeInt(length);
                this.writeInternal(array, 0, length, true);
                return;
            } else if (type == Long.TYPE) {
                long[] array = (long[])obj;
                int length = array.length;
                int limit = this.buf.length - 8;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    if (this.count > limit) {
                        this.drain();
                    }
                    long v = array[i];
                    this.buf[this.count++] = (byte)(v >>> 56);
                    this.buf[this.count++] = (byte)(v >>> 48);
                    this.buf[this.count++] = (byte)(v >>> 40);
                    this.buf[this.count++] = (byte)(v >>> 32);
                    this.buf[this.count++] = (byte)(v >>> 24);
                    this.buf[this.count++] = (byte)(v >>> 16);
                    this.buf[this.count++] = (byte)(v >>> 8);
                    this.buf[this.count++] = (byte)(v >>> 0);
                }
                return;
            } else if (type == Float.TYPE) {
                float[] array = (float[])obj;
                int length = array.length;
                this.writeInt(length);
                int off = 0;
                while (length > 0) {
                    int avail = this.buf.length - this.count >> 2;
                    if (avail > 0) {
                        int n = length < avail ? length : avail;
                        ObjectOutputStream.floatsToBytes(array, off, this.buf, this.count, n);
                        off += n;
                        length -= n;
                        this.count += n << 2;
                        continue;
                    }
                    this.drain();
                }
                return;
            } else if (type == Double.TYPE) {
                double[] array = (double[])obj;
                int length = array.length;
                this.writeInt(length);
                int off = 0;
                while (length > 0) {
                    int avail = this.buf.length - this.count >> 3;
                    if (avail > 0) {
                        int n = length < avail ? length : avail;
                        ObjectOutputStream.doublesToBytes(array, off, this.buf, this.count, n);
                        off += n;
                        length -= n;
                        this.count += n << 3;
                        continue;
                    }
                    this.drain();
                }
                return;
            } else if (type == Short.TYPE) {
                short[] array = (short[])obj;
                int length = array.length;
                int limit = this.buf.length - 2;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    if (this.count > limit) {
                        this.drain();
                    }
                    short v = array[i];
                    this.buf[this.count++] = (byte)(v >>> 8);
                    this.buf[this.count++] = (byte)(v >>> 0);
                }
                return;
            } else if (type == Character.TYPE) {
                char[] array = (char[])obj;
                int length = array.length;
                int limit = this.buf.length - 2;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    if (this.count > limit) {
                        this.drain();
                    }
                    char v = array[i];
                    this.buf[this.count++] = (byte)(v >>> 8);
                    this.buf[this.count++] = (byte)(v >>> 0);
                }
                return;
            } else {
                if (type != Boolean.TYPE) throw new InvalidClassException(currclass.getName());
                boolean[] array = (boolean[])obj;
                int length = array.length;
                int limit = this.buf.length - 1;
                this.writeInt(length);
                for (int i = 0; i < length; ++i) {
                    if (this.count > limit) {
                        this.drain();
                    }
                    this.buf[this.count++] = (byte)(array[i] ? 1 : 0);
                }
            }
            return;
        } else {
            Object[] array = (Object[])obj;
            int length = array.length;
            this.writeInt(length);
            for (int i = 0; i < length; ++i) {
                this.writeObject(array[i]);
            }
        }
    }

    private static native void floatsToBytes(float[] var0, int var1, byte[] var2, int var3, int var4);

    private static native void doublesToBytes(double[] var0, int var1, byte[] var2, int var3, int var4);

    void writeTypeString(String typeString) throws IOException {
        int handle = this.handleTable.findWireOffset(typeString);
        if (handle >= 0) {
            this.writeCode(113);
            this.writeInt(handle + 0x7E0000);
        } else {
            this.handleTable.assignWireOffset(typeString);
            this.writeCode(116);
            this.writeUTF(typeString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputObject(Object obj) throws IOException {
        if (outlog) {
            ObjectInputStream.log("<<<<<<<< NAVIS start write : " + obj.getClass().getName() + " >>>>>>>>>", false);
        }
        this.currentObject = obj;
        if (this.currentClassDesc.isNonSerializable()) {
            throw new NotSerializableException(this.currentClassDesc.getName());
        }
        this.writeCode(115);
        this.outputClassDescriptor(this.currentClassDesc);
        this.handleTable.assignWireOffset(obj);
        if (this.currentClassDesc.isExternalizable()) {
            Externalizable ext = (Externalizable)obj;
            if (outlog) {
                ObjectInputStream.log("[OOS/outputObject] writeExternal : " + this.currentClassDesc, false);
            }
            if (this.useDeprecatedExternalizableFormat) {
                ext.writeExternal(this);
            } else {
                this.setBlockData(true);
                try {
                    ext.writeExternal(this);
                }
                finally {
                    this.setBlockData(false);
                    this.writeCode(120);
                }
            }
        } else {
            int stackMark = this.classDescStack.size();
            try {
                ObjectStreamClass next;
                while ((next = this.currentClassDesc.getSuperclass()) != null) {
                    this.classDescStack.push(this.currentClassDesc);
                    this.currentClassDesc = next;
                }
                do {
                    if (outlog) {
                        ObjectInputStream.log("[OOS/outputObject] obj : " + obj.getClass().getName() + " currentClassDesc : " + this.currentClassDesc.getName(), false);
                    }
                    if (this.currentClassDesc.hasWriteObject()) {
                        if (outlog) {
                            ObjectInputStream.log("[OOS/outputObject] has WriteObject Method", false);
                        }
                        this.setBlockData(true);
                        this.invokeObjectWriter(obj);
                        this.setBlockData(false);
                        this.writeCode(120);
                        continue;
                    }
                    if (outlog) {
                        ObjectInputStream.log("[OOS/outputObject] use default Method", false);
                    }
                    this.defaultWriteObject();
                } while (this.classDescStack.size() > stackMark && (this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
            }
            finally {
                this.classDescStack.setSize(stackMark);
            }
        }
    }

    private Object lookupReplace(Object obj) {
        return this.replaceTable != null ? this.replaceTable.lookup(obj) : obj;
    }

    private boolean serializeNullAndRepeat(Object obj, boolean checkForReplace) throws IOException {
        int handle;
        if (obj == null) {
            this.writeCode(112);
            return true;
        }
        if (checkForReplace) {
            obj = this.lookupReplace(obj);
        }
        if ((handle = this.handleTable.findWireOffset(obj)) >= 0) {
            this.writeCode(113);
            this.writeInt(handle + 0x7E0000);
            return true;
        }
        return false;
    }

    private void addReplacement(Object orig, Object replacement) {
        if (this.replaceTable == null) {
            this.replaceTable = new ReplaceTable(11, 7.0f);
        }
        this.replaceTable.assign(orig, replacement);
    }

    private void writeCode(int tag) throws IOException {
        this.writeByte(tag);
    }

    public void write(int data) throws IOException {
        if (this.count >= this.buf.length) {
            this.drain();
        }
        this.buf[this.count++] = (byte)data;
    }

    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private void writeInternal(byte[] b, int off, int len, boolean copyOnWrite) throws IOException {
        if (len < 0 || off < 0 || off + len > b.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        if (this.blockDataMode) {
            this.writeCanonical(b, off, len);
        } else {
            int avail = this.buf.length - this.count;
            if (len <= avail) {
                System.arraycopy(b, off, this.buf, this.count, len);
                this.count += len;
            } else if (copyOnWrite) {
                this.bufferedWrite(b, off, len);
            } else {
                this.drain();
                this.out.write(b, off, len);
            }
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.writeInternal(b, off, len, false);
    }

    private void bufferedWrite(byte[] b, int off, int len) throws IOException {
        int bytesToWrite = len;
        int bufAvail = this.buf.length - this.count;
        if (bytesToWrite > bufAvail) {
            System.arraycopy(b, off, this.buf, this.count, bufAvail);
            off += bufAvail;
            bytesToWrite -= bufAvail;
            this.out.write(this.buf, 0, this.buf.length);
            this.count = 0;
            while (bytesToWrite >= this.buf.length) {
                System.arraycopy(b, off, this.buf, 0, this.buf.length);
                this.out.write(this.buf, 0, this.buf.length);
                off += this.buf.length;
                bytesToWrite -= this.buf.length;
            }
        }
        if (bytesToWrite != 0) {
            System.arraycopy(b, off, this.buf, this.count, bytesToWrite);
            this.count += bytesToWrite;
        }
    }

    public void flush() throws IOException {
        this.drain();
        this.out.flush();
    }

    protected void drain() throws IOException {
        if (this.count == 0) {
            return;
        }
        if (this.blockDataMode) {
            this.writeBlockDataHeader(this.count);
        }
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private boolean setBlockData(boolean mode) throws IOException {
        if (this.blockDataMode == mode) {
            return mode;
        }
        this.drain();
        this.blockDataMode = mode;
        return !mode;
    }

    private void writeBlockDataHeader(int len) throws IOException {
        if (len <= 255) {
            this.out.write(119);
            this.out.write((byte)len);
        } else {
            this.out.write(122);
            this.out.write((byte)(len >> 24 & 0xFF));
            this.out.write((byte)(len >> 16 & 0xFF));
            this.out.write((byte)(len >> 8 & 0xFF));
            this.out.write((byte)(len & 0xFF));
        }
    }

    private void writeCanonical(byte[] b, int off, int len) throws IOException {
        int bytesToWrite = len;
        int bufAvail = this.buf.length - this.count;
        if (bytesToWrite > bufAvail) {
            this.writeBlockDataHeader(this.buf.length);
            this.out.write(this.buf, 0, this.count);
            this.out.write(b, off, bufAvail);
            this.count = 0;
            off += bufAvail;
            bytesToWrite -= bufAvail;
            while (bytesToWrite >= this.buf.length) {
                if (this.blockDataMode) {
                    this.writeBlockDataHeader(this.buf.length);
                }
                this.out.write(b, off, this.buf.length);
                off += this.buf.length;
                bytesToWrite -= this.buf.length;
            }
        }
        if (bytesToWrite != 0) {
            System.arraycopy(b, off, this.buf, this.count, bytesToWrite);
            this.count += bytesToWrite;
        }
    }

    public void writeBoolean(boolean data) throws IOException {
        if (this.count >= this.buf.length) {
            this.dos.writeBoolean(data);
            return;
        }
        this.buf[this.count++] = (byte)(data ? 1 : 0);
    }

    public void writeByte(int data) throws IOException {
        if (this.count >= this.buf.length) {
            this.dos.writeByte(data);
            return;
        }
        this.buf[this.count++] = (byte)data;
    }

    public void writeShort(int data) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.dos.writeShort(data);
            return;
        }
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    public void writeChar(int data) throws IOException {
        if (this.count + 2 > this.buf.length) {
            this.dos.writeChar(data);
            return;
        }
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    public void writeInt(int data) throws IOException {
        if (this.count + 4 > this.buf.length) {
            this.dos.writeInt(data);
            return;
        }
        this.buf[this.count++] = (byte)(data >>> 24);
        this.buf[this.count++] = (byte)(data >>> 16);
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    public void writeLong(long data) throws IOException {
        if (this.count + 8 > this.buf.length) {
            this.dos.writeLong(data);
            return;
        }
        this.buf[this.count++] = (byte)(data >>> 56);
        this.buf[this.count++] = (byte)(data >>> 48);
        this.buf[this.count++] = (byte)(data >>> 40);
        this.buf[this.count++] = (byte)(data >>> 32);
        this.buf[this.count++] = (byte)(data >>> 24);
        this.buf[this.count++] = (byte)(data >>> 16);
        this.buf[this.count++] = (byte)(data >>> 8);
        this.buf[this.count++] = (byte)(data >>> 0);
    }

    public void writeFloat(float data) throws IOException {
        int value = Float.floatToIntBits(data);
        if (this.count + 4 > this.buf.length) {
            this.dos.writeFloat(data);
            return;
        }
        this.buf[this.count++] = (byte)(value >>> 24);
        this.buf[this.count++] = (byte)(value >>> 16);
        this.buf[this.count++] = (byte)(value >>> 8);
        this.buf[this.count++] = (byte)(value >>> 0);
    }

    public void writeDouble(double data) throws IOException {
        long value = Double.doubleToLongBits(data);
        if (this.count + 8 > this.buf.length) {
            this.dos.writeDouble(data);
            return;
        }
        this.buf[this.count++] = (byte)(value >>> 56);
        this.buf[this.count++] = (byte)(value >>> 48);
        this.buf[this.count++] = (byte)(value >>> 40);
        this.buf[this.count++] = (byte)(value >>> 32);
        this.buf[this.count++] = (byte)(value >>> 24);
        this.buf[this.count++] = (byte)(value >>> 16);
        this.buf[this.count++] = (byte)(value >>> 8);
        this.buf[this.count++] = (byte)(value >>> 0);
    }

    public void writeBytes(String data) throws IOException {
        char[] chars = data.toCharArray();
        int len = chars.length;
        int buflen = this.buf.length;
        for (int i = 0; i < len; ++i) {
            if (this.count >= buflen) {
                this.drain();
            }
            this.buf[this.count++] = (byte)chars[i];
        }
    }

    public void writeChars(String data) throws IOException {
        char[] chars = data.toCharArray();
        int len = chars.length;
        int limit = this.buf.length - 2;
        for (int i = 0; i < len; ++i) {
            char c = chars[i];
            if (this.count > limit) {
                this.dos.writeChar(c);
                continue;
            }
            this.buf[this.count++] = (byte)(c >>> 8);
            this.buf[this.count++] = (byte)(c >>> 0);
        }
    }

    public void writeUTF(String s) throws IOException {
        int slen = s.length();
        if (this.cdata == null || this.cdata.length < slen) {
            this.cdata = s.toCharArray();
        } else {
            s.getChars(0, slen, this.cdata, 0);
        }
        long utflen = ObjectOutputStream.getUTFLength(this.cdata, slen);
        if (utflen > 65535L) {
            throw new UTFDataFormatException();
        }
        this.writeShort((int)utflen);
        this.writeUTFBody(this.cdata, slen);
        if (slen > 1024) {
            this.cdata = null;
        }
    }

    private void outputClassFields(Object o, Class cl, ObjectStreamField[] fields) throws IOException, InvalidClassException {
        int numPrimBytes = this.currentClassDesc.numPrimBytes;
        if (numPrimBytes > 0) {
            if (this.data == null) {
                this.data = new byte[Math.max(numPrimBytes, 64)];
            } else if (this.data.length < numPrimBytes) {
                this.data = new byte[numPrimBytes];
            }
            ObjectOutputStream.getPrimitiveFieldValues(o, this.currentClassDesc.primFieldIDs, this.currentClassDesc.primFieldTypecodes, this.data);
            this.writeInternal(this.data, 0, numPrimBytes, false);
        }
        int numPrimFields = fields.length - this.currentClassDesc.numObjFields;
        long[] objFieldIDs = this.currentClassDesc.objFieldIDs;
        for (int i = 0; i < this.currentClassDesc.numObjFields; ++i) {
            Object val;
            try {
                val = ObjectOutputStream.getObjectFieldValue(o, objFieldIDs[i]);
            }
            catch (Exception e) {
                throw new InvalidClassException(cl.getName(), "Invalid field " + fields[numPrimFields + i].getName());
            }
            this.writeObject(val);
        }
    }

    private static native void getPrimitiveFieldValues(Object var0, long[] var1, char[] var2, byte[] var3);

    private static native Object getObjectFieldValue(Object var0, long var1);

    private void invokeObjectWriter(Object obj) throws IOException {
        try {
            this.currentClassDesc.writeObjectMethod.invoke(obj, this.writeObjectArglist);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof IOException) {
                throw (IOException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Error("internal error");
        }
        catch (IllegalAccessException e) {
            throw new InternalError("Unable to access writeObject method");
        }
    }

    static {
        try {
            Class<ObjectInputStream> cl = ObjectInputStream.class;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static final class Stack
    extends ArrayList {
        private static final long serialVersionUID = -428799992207134975L;

        private Stack() {
        }

        public void setSize(int newSize) {
            if (newSize == 0) {
                this.clear();
            } else {
                int len = this.size();
                for (int i = len - 1; i >= newSize; --i) {
                    this.remove(i);
                }
            }
        }

        public Object push(Object item) {
            this.add(item);
            return item;
        }

        public Object pop() {
            int len = this.size();
            Object obj = this.peek();
            this.remove(len - 1);
            return obj;
        }

        public Object peek() {
            int len = this.size();
            if (len == 0) {
                throw new EmptyStackException();
            }
            return this.get(len - 1);
        }
    }

    private static final class ReplaceTable {
        private HandleTable htab;
        private Object[] reps;

        public ReplaceTable(int initialCapacity, float loadFactor) {
            this.htab = new HandleTable(initialCapacity, loadFactor);
            this.reps = new Object[initialCapacity];
        }

        public void assign(Object obj, Object rep) {
            int index = this.htab.assignWireOffset(obj);
            while (index >= this.reps.length) {
                this.grow();
            }
            this.reps[index] = rep;
        }

        public Object lookup(Object obj) {
            int index = this.htab.findWireOffset(obj);
            return index >= 0 ? this.reps[index] : obj;
        }

        public void clear() {
            Arrays.fill(this.reps, 0, this.htab.size(), null);
            this.htab.clear();
        }

        public int size() {
            return this.htab.size();
        }

        private void grow() {
            Object[] newReps = new Object[(this.reps.length << 1) + 1];
            System.arraycopy(this.reps, 0, newReps, 0, this.reps.length);
            this.reps = newReps;
        }
    }

    private static final class HandleTable {
        private int nextWireOffset;
        private int wireHashCapacity;
        private float loadFactor;
        private int[] wireHash2Handle;
        private int[] wireNextHandle;
        private Object[] wireHandle2Object;

        public HandleTable(int initialCapacity, float loadFactor) {
            this.loadFactor = loadFactor;
            this.wireHash2Handle = new int[initialCapacity];
            this.wireNextHandle = new int[initialCapacity];
            this.wireHandle2Object = new Object[initialCapacity];
            this.wireHashCapacity = (int)((float)initialCapacity * loadFactor);
            this.clear();
        }

        public int assignWireOffset(Object obj) {
            if (this.nextWireOffset >= this.wireNextHandle.length) {
                this.growEntries();
            }
            if (this.nextWireOffset >= this.wireHashCapacity) {
                this.growSpine();
            }
            this.insert(obj, this.nextWireOffset);
            return this.nextWireOffset++;
        }

        private void insert(Object obj, int offset) {
            int index = (System.identityHashCode(obj) & Integer.MAX_VALUE) % this.wireHash2Handle.length;
            this.wireHandle2Object[offset] = obj;
            this.wireNextHandle[offset] = this.wireHash2Handle[index];
            this.wireHash2Handle[index] = offset;
        }

        private void growSpine() {
            this.wireHash2Handle = new int[(this.wireHash2Handle.length << 1) + 1];
            this.wireHashCapacity = (int)((float)this.wireHash2Handle.length * this.loadFactor);
            Arrays.fill(this.wireHash2Handle, -1);
            for (int i = 0; i < this.nextWireOffset; ++i) {
                this.insert(this.wireHandle2Object[i], i);
            }
        }

        private void growEntries() {
            int[] newWireNextHandle = new int[this.wireNextHandle.length * 2];
            System.arraycopy(this.wireNextHandle, 0, newWireNextHandle, 0, this.nextWireOffset);
            this.wireNextHandle = newWireNextHandle;
            Object[] newWireHandle2Object = new Object[this.wireHandle2Object.length * 2];
            System.arraycopy(this.wireHandle2Object, 0, newWireHandle2Object, 0, this.nextWireOffset);
            this.wireHandle2Object = newWireHandle2Object;
        }

        public int findWireOffset(Object obj) {
            int index = (System.identityHashCode(obj) & Integer.MAX_VALUE) % this.wireHash2Handle.length;
            int handle = this.wireHash2Handle[index];
            while (handle >= 0) {
                if (this.wireHandle2Object[handle] == obj) {
                    return handle;
                }
                handle = this.wireNextHandle[handle];
            }
            return -1;
        }

        public void clear() {
            Arrays.fill(this.wireHash2Handle, -1);
            Arrays.fill(this.wireHandle2Object, 0, this.nextWireOffset, null);
            this.nextWireOffset = 0;
        }

        public int size() {
            return this.nextWireOffset;
        }
    }

    static final class PutFieldImpl
    extends PutField {
        private byte[] data;
        private Object[] objects;
        private ObjectStreamClass desc;

        public void put(String name, boolean value) throws IllegalArgumentException {
            ObjectStreamField field = this.desc.getField(name, Boolean.TYPE);
            if (field == null || field.getType() != Boolean.TYPE) {
                throw new IllegalArgumentException("No such boolean field");
            }
            this.data[field.getOffset()] = (byte)(value ? 1 : 0);
        }

        public void put(String name, char value) {
            ObjectStreamField field = this.desc.getField(name, Character.TYPE);
            if (field == null || field.getType() != Character.TYPE) {
                throw new IllegalArgumentException("No such char field");
            }
            this.data[field.getOffset()] = (byte)(value >> 8);
            this.data[field.getOffset() + 1] = (byte)value;
        }

        public void put(String name, byte value) {
            ObjectStreamField field = this.desc.getField(name, Byte.TYPE);
            if (field == null || field.getType() != Byte.TYPE) {
                throw new IllegalArgumentException("No such byte field");
            }
            this.data[field.getOffset()] = value;
        }

        public void put(String name, short value) {
            ObjectStreamField field = this.desc.getField(name, Short.TYPE);
            if (field == null || field.getType() != Short.TYPE) {
                throw new IllegalArgumentException("No such short field");
            }
            int loffset = field.getOffset();
            this.data[loffset] = (byte)(value >> 8);
            this.data[loffset + 1] = (byte)value;
        }

        public void put(String name, int value) {
            ObjectStreamField field = this.desc.getField(name, Integer.TYPE);
            if (field == null || field.getType() != Integer.TYPE) {
                throw new IllegalArgumentException("No such int field");
            }
            int loffset = field.getOffset();
            this.data[loffset] = (byte)(value >> 24);
            this.data[loffset + 1] = (byte)(value >> 16);
            this.data[loffset + 2] = (byte)(value >> 8);
            this.data[loffset + 3] = (byte)value;
        }

        public void put(String name, long value) {
            ObjectStreamField field = this.desc.getField(name, Long.TYPE);
            if (field == null || field.getType() != Long.TYPE) {
                throw new IllegalArgumentException("No such long field");
            }
            int loffset = field.getOffset();
            this.data[loffset] = (byte)(value >> 56);
            this.data[loffset + 1] = (byte)(value >> 48);
            this.data[loffset + 2] = (byte)(value >> 40);
            this.data[loffset + 3] = (byte)(value >> 32);
            this.data[loffset + 4] = (byte)(value >> 24);
            this.data[loffset + 5] = (byte)(value >> 16);
            this.data[loffset + 6] = (byte)(value >> 8);
            this.data[loffset + 7] = (byte)value;
        }

        public void put(String name, float value) {
            int val = Float.floatToIntBits(value);
            ObjectStreamField field = this.desc.getField(name, Float.TYPE);
            if (field == null || field.getType() != Float.TYPE) {
                throw new IllegalArgumentException("No such float field");
            }
            int loffset = field.getOffset();
            this.data[loffset] = (byte)(val >> 24);
            this.data[loffset + 1] = (byte)(val >> 16);
            this.data[loffset + 2] = (byte)(val >> 8);
            this.data[loffset + 3] = (byte)val;
        }

        public void put(String name, double value) {
            long val = Double.doubleToLongBits(value);
            ObjectStreamField field = this.desc.getField(name, Double.TYPE);
            if (field == null || field.getType() != Double.TYPE) {
                throw new IllegalArgumentException("No such double field");
            }
            int loffset = field.getOffset();
            this.data[loffset] = (byte)(val >> 56);
            this.data[loffset + 1] = (byte)(val >> 48);
            this.data[loffset + 2] = (byte)(val >> 40);
            this.data[loffset + 3] = (byte)(val >> 32);
            this.data[loffset + 4] = (byte)(val >> 24);
            this.data[loffset + 5] = (byte)(val >> 16);
            this.data[loffset + 6] = (byte)(val >> 8);
            this.data[loffset + 7] = (byte)val;
        }

        public void put(String name, Object value) {
            ObjectStreamField field = this.desc.getField(name, Object.class);
            if (field == null || field.isPrimitive()) {
                throw new IllegalArgumentException("No such object field");
            }
            this.objects[field.getOffset()] = value;
        }

        public void write(ObjectOutput out) throws IOException {
            if (this.data != null) {
                out.write(this.data, 0, this.data.length);
            }
            if (this.objects != null) {
                for (int i = 0; i < this.objects.length; ++i) {
                    out.writeObject(this.objects[i]);
                }
            }
        }

        PutFieldImpl(ObjectStreamClass descriptor) {
            this.desc = descriptor;
            if (this.desc.numPrimBytes > 0) {
                this.data = new byte[this.desc.numPrimBytes];
            }
            if (this.desc.numObjFields > 0) {
                this.objects = new Object[this.desc.numObjFields];
            }
        }
    }

    public static abstract class PutField {
        public abstract void put(String var1, boolean var2);

        public abstract void put(String var1, char var2);

        public abstract void put(String var1, byte var2);

        public abstract void put(String var1, short var2);

        public abstract void put(String var1, int var2);

        public abstract void put(String var1, long var2);

        public abstract void put(String var1, float var2);

        public abstract void put(String var1, double var2);

        public abstract void put(String var1, Object var2);

        public abstract void write(ObjectOutput var1) throws IOException;
    }
}

