/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.io.Serializable;
import java.util.logging.Level;
import jeus.util.logging.FileHandler;

public class FileHandlerView
implements Serializable {
    private String name;
    private Level level;
    private String pattern;
    private String owner;
    private String formatterClassName;
    private String logRecordClassName;
    private String loggerType;

    public FileHandlerView(FileHandler handler, String owner) {
        this.name = handler.getName();
        this.level = handler.getLevel();
        this.pattern = handler.getFilePattern();
        this.formatterClassName = handler.getFormatter().getClass().getName();
        if (owner.startsWith("jeus.webaccess")) {
            this.logRecordClassName = "jeus.util.logging.JeusAccessRecord";
            this.loggerType = "ACCESS_LOGGER";
        } else {
            this.logRecordClassName = "jeus.util.logging.ErrorLogRecord";
            this.loggerType = "ERROR_LOGGER";
        }
        this.owner = owner;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getFormatterClassName() {
        return this.formatterClassName;
    }

    public void setFormatterClassName(String formatterClassName) {
        this.formatterClassName = formatterClassName;
    }

    public String getLoggerType() {
        return this.loggerType;
    }

    public void setLoggerType(String loggerType) {
        this.loggerType = loggerType;
    }

    public String getLogRecordClassName() {
        return this.logRecordClassName;
    }

    public void setLogRecordClassName(String logRecordClassName) {
        this.logRecordClassName = logRecordClassName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FileHandlerView)) {
            return false;
        }
        FileHandlerView view = (FileHandlerView)o;
        return view.name.equals(this.name) && view.pattern.equals(this.pattern);
    }
}

