/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.logging;

import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpSession;
import jeus.servlet.engine.HttpServletRequestImpl;
import jeus.servlet.engine.HttpServletResponseImpl;
import jeus.util.SimpleLogDateFormat;
import jeus.util.logging.AccessFormatter;
import jeus.util.logging.JeusAccessRecord;
import jeus.util.logging.SimpleFormatter;
import jeus.util.properties.JeusNetPropertyValues;

public final class UserAccessFormatter
extends AccessFormatter {
    protected String logFormat;
    protected PatternUnit[] pattern;
    private static String LOCAL_IP = JeusNetPropertyValues.LOCAL_HOSTADDRESS;
    DecimalFormat timeTakenFormatter = new DecimalFormat("0.000");
    private boolean delimiting = true;

    public UserAccessFormatter() {
    }

    public UserAccessFormatter(String logFormat) {
        super(null);
        this.logFormat = logFormat;
        this.parseLogFormat();
    }

    private void parseLogFormat() {
        ArrayList<PatternUnit> p = new ArrayList<PatternUnit>();
        HashMap f = new HashMap();
        HashMap pp = new HashMap();
        StringBuffer ppbuf = new StringBuffer();
        StringBuffer fbuf = new StringBuffer();
        int len = this.logFormat.length();
        boolean replace = false;
        for (int i = 0; i < len; ++i) {
            char ch = this.logFormat.charAt(i);
            if (replace) {
                String fstr = fbuf.toString();
                if (fstr == null || fstr.length() == 0) {
                    fstr = "";
                }
                fbuf = new StringBuffer();
                PatternUnit unit = new PatternUnit();
                if ('{' == ch) {
                    int j;
                    StringBuffer name = new StringBuffer();
                    for (j = i + 1; j < len && '}' != this.logFormat.charAt(j); ++j) {
                        name.append(this.logFormat.charAt(j));
                    }
                    if (j + 1 < len) {
                        unit.fixedMessage = fstr;
                        unit.pattern = this.logFormat.charAt(++j);
                        unit.param = name.toString();
                        if (unit.param == null || unit.param.length() == 0) {
                            unit.param = null;
                        }
                        i = j;
                    } else {
                        unit.fixedMessage = fstr;
                        unit.pattern = ch;
                        unit.param = null;
                    }
                } else {
                    unit.fixedMessage = fstr;
                    unit.pattern = ch;
                    unit.param = null;
                }
                if (unit.pattern == 't' && this.dateFormat != null) {
                    String param = unit.param;
                    if (param == null || param.length() == 0) {
                        param = "yyyy.MM.dd HH:mm:ss";
                    }
                    this.dateFormat = new SimpleLogDateFormat(param);
                    this.dateFormatString = param;
                }
                replace = false;
                if ((unit.pattern == 'i' || unit.pattern == 'c') && unit.param == null) continue;
                p.add(unit);
                continue;
            }
            if (ch == '%') {
                replace = true;
                continue;
            }
            fbuf.append(ch);
        }
        String fstr = fbuf.toString();
        if (fstr != null && fstr.length() > 0) {
            PatternUnit unit = new PatternUnit();
            unit.fixedMessage = fstr;
            unit.pattern = (char)32;
            unit.param = null;
            p.add(unit);
        }
        this.checkDelimit(p);
        if (p.size() == 0) {
            this.pattern = null;
        } else {
            Object[] temp = p.toArray();
            this.pattern = new PatternUnit[p.size()];
            for (int ii = 0; ii < p.size(); ++ii) {
                this.pattern[ii] = (PatternUnit)temp[ii];
            }
        }
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleLogDateFormat("yyyy.MM.dd HH:mm:ss");
        }
    }

    private void checkDelimit(ArrayList p) {
        int size = p.size();
        if (size == 0) {
            return;
        }
        String newFormat = "";
        for (int i = 0; i < size; ++i) {
            PatternUnit unit = this.checkDelimit0(p, i);
            newFormat = unit.pattern == ' ' ? newFormat + unit.fixedMessage : (unit.param != null ? newFormat + unit.fixedMessage + "%{" + unit.param + "}" + unit.pattern : newFormat + unit.fixedMessage + "%" + unit.pattern);
        }
        this.logFormat = newFormat;
        HashMap<String, String> props = this.getProperty();
        if (props == null) {
            props = new HashMap<String, String>();
        }
        props.put("web.accesslog.format", newFormat);
        this.setProperty(props);
    }

    private PatternUnit checkDelimit0(ArrayList p, int i) {
        String delimitString;
        PatternUnit cur = (PatternUnit)p.get(i);
        PatternUnit prev = null;
        PatternUnit next = null;
        if (i > 0) {
            prev = (PatternUnit)p.get(i - 1);
        }
        if (i < p.size() - 1) {
            next = (PatternUnit)p.get(i + 1);
        }
        if (!(this.isDelimiter(cur.pattern, delimitString = next == null ? null : next.fixedMessage, cur.param != null) || next == null || cur.pattern == 'U' && next != null && next.pattern == 'q')) {
            next.fixedMessage = cur.param == null ? " " + next.fixedMessage : "\"" + next.fixedMessage;
        }
        if (cur.pattern != 't' && cur.param != null && !cur.fixedMessage.trim().endsWith("\"")) {
            cur.fixedMessage = cur.fixedMessage + "\"";
        }
        return cur;
    }

    private boolean isDelimiter(char pattern, String delimitString, boolean param_exist) {
        if (delimitString == null) {
            return true;
        }
        if (pattern == ' ' || pattern == 't' || pattern == 'l') {
            return true;
        }
        if (delimitString.length() == 0) {
            return false;
        }
        char delimit = delimitString.charAt(0);
        switch (pattern) {
            case ' ': {
                return true;
            }
            case 't': {
                return true;
            }
            case 'l': {
                return true;
            }
            case 'B': 
            case 'D': 
            case 'b': 
            case 'p': {
                return !this.isDigit(delimit);
            }
            case 's': {
                if (!param_exist) {
                    return !this.isDigit(delimit);
                }
                if ((delimitString = delimitString.trim()).length() == 0) {
                    return false;
                }
                return this.isDoubleQuote(delimitString.charAt(0));
            }
            case 'T': {
                return !this.isFloatNumber(delimit);
            }
            case 'h': {
                return !this.isHostname(delimit);
            }
            case 'A': 
            case 'a': {
                return !this.isIPAddress(delimit);
            }
            case 'H': {
                return !this.isProtocol(delimit);
            }
            case 'm': {
                return !this.isLetter(delimit);
            }
            case 'S': {
                return this.isWhitespace(delimit);
            }
            case 'r': {
                if (!param_exist) {
                    return this.isRequestLineDelimiter(delimit);
                }
                if ((delimitString = delimitString.trim()).length() == 0) {
                    return false;
                }
                return this.isDoubleQuote(delimitString.charAt(0));
            }
            case 'u': {
                return this.isWhitespace(delimit);
            }
            case 'v': {
                return this.isWhitespace(delimit);
            }
            case 'i': {
                delimitString = delimitString.trim();
                if (delimitString.length() == 0) {
                    return false;
                }
                return this.isDoubleQuote(delimitString.charAt(0));
            }
            case 'c': {
                delimitString = delimitString.trim();
                if (delimitString.length() == 0) {
                    return false;
                }
                return this.isDoubleQuote(delimitString.charAt(0));
            }
            case 'q': {
                return this.isRequestLineDelimiter(delimit);
            }
            case 'U': {
                return this.isRequestURIDelimiter(delimit);
            }
        }
        return false;
    }

    private boolean isDigit(char delimit) {
        return Character.isDigit(delimit);
    }

    private boolean isDoubleQuote(char delimit) {
        return delimit == '\"';
    }

    private boolean isFloatNumber(char delimit) {
        return Character.isDigit(delimit) || delimit == '.';
    }

    private boolean isHostname(char delimit) {
        return Character.isLetterOrDigit(delimit) || delimit == '.' || delimit == '_' || delimit == '-';
    }

    private boolean isIPAddress(char delimit) {
        return Character.isDigit(delimit) || delimit == '.';
    }

    private boolean isProtocol(char delimit) {
        return Character.isLetterOrDigit(delimit) || delimit == '/' || delimit == '.';
    }

    private boolean isLetter(char delimit) {
        return Character.isLetter(delimit);
    }

    private boolean isWhitespace(char delimit) {
        return Character.isWhitespace(delimit);
    }

    private boolean isRequestLineDelimiter(char delimit) {
        return Character.isWhitespace(delimit) || delimit == '\'' || delimit == '\"';
    }

    private boolean isRequestURIDelimiter(char delimit) {
        return this.isRequestLineDelimiter(delimit) || delimit == '?';
    }

    private String findIPAddress(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && this.isIPAddress(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findDigit(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && this.isDigit(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findDouble(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && this.isFloatNumber(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findAttribute(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && !this.isDoubleQuote(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findHostname(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && this.isHostname(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findProtocol(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && this.isProtocol(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findMethod(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && this.isLetter(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findRequestURI(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && !this.isRequestURIDelimiter(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findQueryString(String msg, int start) {
        return this.findRequestURI(msg, start);
    }

    private String findRequestLine(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && !this.isRequestLineDelimiter(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    private String findToken(String msg, int start) {
        int i;
        int len = msg.length();
        for (i = start; i < len && !this.isWhitespace(msg.charAt(i)); ++i) {
        }
        return msg.substring(start, i);
    }

    public synchronized String format(LogRecord r) {
        if (r instanceof JeusAccessRecord) {
            JeusAccessRecord record = (JeusAccessRecord)((Object)r);
            HttpServletRequestImpl request = record.getRequest();
            HttpServletResponseImpl response = record.getResponse();
            String formattedMessage = record.getFormattedMessage(this.FORMATTER_ID);
            if (formattedMessage != null) {
                return formattedMessage;
            }
            if (this.pattern == null) {
                return "";
            }
            StringBuffer text = new StringBuffer();
            String value = null;
            Object obj = null;
            for (int i = 0; i < this.pattern.length; ++i) {
                String query;
                value = null;
                PatternUnit unit = this.pattern[i];
                char ch = unit.pattern;
                text.append(unit.fixedMessage);
                if (ch == 't') {
                    Date dat = new Date();
                    dat.setTime(record.getMillis());
                    text.append(this.dateFormat.format(dat));
                    continue;
                }
                if (ch == 'a') {
                    text.append(request.getRemoteAddr());
                    continue;
                }
                if (ch == 'A') {
                    text.append(LOCAL_IP);
                    continue;
                }
                if (ch == 'b') {
                    int length = response.getContentLength();
                    value = length <= 0 ? "-" : "" + length;
                    text.append(value);
                    continue;
                }
                if (ch == 'B') {
                    int length = response.getContentLength();
                    if (length < 0) {
                        length = 0;
                    }
                    text.append(length);
                    continue;
                }
                if (ch == 'h') {
                    text.append(request.getRemoteHost());
                    continue;
                }
                if (ch == 'H') {
                    text.append(request.getProtocol());
                    continue;
                }
                if (ch == 'l') {
                    text.append("-");
                    continue;
                }
                if (ch == 'm') {
                    text.append(request.getMethod());
                    continue;
                }
                if (ch == 'p') {
                    text.append(request.getServerPort());
                    continue;
                }
                if (ch == 'D') {
                    text.append(record.getProcessingTime());
                    continue;
                }
                if (ch == 'q') {
                    query = request.getQueryString();
                    value = query != null ? "?" + query : (unit.fixedMessage.length() > 0 ? "-" : "");
                    text.append(value);
                    continue;
                }
                if (ch == 'r') {
                    if (unit.param == null) {
                        text.append(request.getMethod());
                        text.append(' ');
                        value = request.getRequestURI();
                        if (value == null) {
                            value = "-";
                        }
                        text.append(value);
                        query = request.getQueryString();
                        if (query != null) {
                            text.append('?');
                            text.append(query);
                        }
                        text.append(' ');
                        text.append(request.getProtocol());
                        continue;
                    }
                    obj = request.getAttribute(unit.param);
                    text.append(obj == null ? "" : obj);
                    continue;
                }
                if (ch == 'S') {
                    if (request.getSession(false) != null) {
                        String sid = request.getSession(false).getId();
                        if (sid == null) {
                            sid = "-";
                        }
                        text.append(sid);
                        continue;
                    }
                    text.append("-");
                    continue;
                }
                if (ch == 's') {
                    if (unit.param == null) {
                        text.append(response.getStatus());
                        continue;
                    }
                    HttpSession sess = request.getSession(false);
                    if (null == sess) continue;
                    obj = sess.getAttribute(unit.param);
                    text.append(obj == null ? "" : obj);
                    continue;
                }
                if (ch == 'T') {
                    text.append(this.timeTakenFormatter.format((double)record.getProcessingTime() / 1000.0));
                    continue;
                }
                if (ch == 'u') {
                    value = request.getRemoteUser();
                    if (value == null) {
                        value = "-";
                    }
                    text.append(value);
                    continue;
                }
                if (ch == 'U') {
                    value = request.getRequestURI();
                    if (value == null) {
                        value = "-";
                    }
                    text.append(value);
                    continue;
                }
                if (ch == 'v') {
                    value = request.getServerName();
                    if (value == null) {
                        value = "-";
                    }
                    text.append(value);
                    continue;
                }
                if (ch == 'i') {
                    obj = request.getHeader(unit.param);
                    text.append(obj == null ? "" : obj);
                    continue;
                }
                if (ch == 'c') {
                    Cookie[] c = request.getCookies();
                    for (int k = 0; c != null && k < c.length; ++k) {
                        if (!unit.param.equals(c[k].getName())) continue;
                        value = c[k].getValue();
                        break;
                    }
                    if (value == null) {
                        value = "-";
                    }
                    text.append(value);
                    continue;
                }
                if (ch == ' ') continue;
                value = "???" + this.pattern + "???";
                text.append(value);
            }
            text.append(lineSeparator);
            formattedMessage = text.toString();
            record.setFormattedMessage(this.FORMATTER_ID, formattedMessage);
            return formattedMessage;
        }
        return SimpleFormatter.formatLogRecord((Formatter)((Object)this), (LogRecord)r, null, (boolean)true);
    }

    public Map getLogRecord(String message) throws ParseException {
        if (this.pattern == null) {
            return new JeusAccessRecord(Level.INFO, "").getLogInfo();
        }
        if (this.dateFormat2 == null) {
            this.dateFormat2 = new SimpleDateFormat(this.dateFormatString);
        }
        Date date = null;
        String localIP = null;
        String remoteIP = null;
        int contentLength = -1;
        String remoteHostname = null;
        String protocol = null;
        String method = null;
        int serverPort = -1;
        String status = null;
        long processingTime = -1L;
        String query = null;
        String uri = null;
        String sessionId = null;
        String remoteUser = null;
        String serverName = null;
        HashMap<String, String> sessionAttributes = new HashMap<String, String>();
        HashMap<String, String> requestAttributes = new HashMap<String, String>();
        HashMap<String, String> cookieValues = new HashMap<String, String>();
        HashMap<String, String> headerValues = new HashMap<String, String>();
        String dateFormat = null;
        int pos = 0;
        for (int i = 0; i < this.pattern.length; ++i) {
            try {
                int k = this.pattern[i].fixedMessage.length();
                pos += k;
                char ch = this.pattern[i].pattern;
                if (ch == ' ') continue;
                if (ch == 'a') {
                    remoteIP = this.findIPAddress(message, pos);
                    pos += remoteIP.length();
                    continue;
                }
                if (ch == 'A') {
                    localIP = this.findIPAddress(message, pos);
                    pos += localIP.length();
                    continue;
                }
                if (ch == 't') {
                    String d;
                    k = this.dateFormatString.length();
                    dateFormat = d = message.substring(pos, pos + k);
                    date = this.dateFormat2.parse(d);
                    pos += k;
                    continue;
                }
                if (ch == 'b') {
                    if (message.charAt(pos) == '-') {
                        contentLength = 0;
                        ++pos;
                        continue;
                    }
                    String num = this.findDigit(message, pos);
                    pos += num.length();
                    try {
                        contentLength = Integer.parseInt(num);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (ch == 'B') {
                    String num = this.findDigit(message, pos);
                    pos += num.length();
                    try {
                        contentLength = Integer.parseInt(num);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (ch == 'c') {
                    String name = this.pattern[i].param;
                    String value = this.findAttribute(message, pos);
                    pos += value.length();
                    cookieValues.put(name, value);
                    continue;
                }
                if (ch == 'D') {
                    String time = this.findDigit(message, pos);
                    try {
                        processingTime = Long.parseLong(time);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    pos += time.length();
                    continue;
                }
                if (ch == 'h') {
                    remoteHostname = this.findHostname(message, pos);
                    pos += remoteHostname.length();
                    continue;
                }
                if (ch == 'H') {
                    protocol = this.findProtocol(message, pos);
                    pos += protocol.length();
                    continue;
                }
                if (ch == 'i') {
                    String name = this.pattern[i].param;
                    String value = this.findAttribute(message, pos);
                    pos += value.length();
                    headerValues.put(name, value);
                    continue;
                }
                if (ch == 'l') {
                    ++pos;
                    continue;
                }
                if (ch == 'm') {
                    method = this.findMethod(message, pos);
                    pos += method.length();
                    continue;
                }
                if (ch == 'p') {
                    String port = this.findDigit(message, pos);
                    pos += port.length();
                    try {
                        serverPort = Integer.parseInt(port);
                    }
                    catch (Exception e) {}
                    continue;
                }
                if (ch == 'q') {
                    if (this.pattern[i].fixedMessage.length() <= 0) continue;
                    query = this.findQueryString(message, pos);
                    pos += query.length();
                    if (!query.startsWith("?")) continue;
                    query = query.substring(1);
                    continue;
                }
                if (ch == 'r') {
                    if (this.pattern[i].param == null) {
                        method = this.findMethod(message, pos);
                        pos += method.length();
                        uri = this.findRequestLine(message, ++pos);
                        int j = uri.indexOf(63);
                        pos += uri.length();
                        ++pos;
                        if (j > 0) {
                            query = uri.substring(j + 1);
                            uri = uri.substring(0, j);
                        }
                        protocol = this.findProtocol(message, pos);
                        continue;
                    }
                    String name = this.pattern[i].param;
                    String value = this.findAttribute(message, pos);
                    pos += value.length();
                    requestAttributes.put(name, value);
                    continue;
                }
                if (ch == 's') {
                    if (this.pattern[i].param == null) {
                        status = this.findDigit(message, pos);
                        pos += status.length();
                        continue;
                    }
                    String name = this.pattern[i].param;
                    String value = this.findAttribute(message, pos);
                    pos += value.length();
                    sessionAttributes.put(name, value);
                    continue;
                }
                if (ch == 'S') {
                    if (message.charAt(pos) == '-') {
                        contentLength = 0;
                        ++pos;
                        continue;
                    }
                    sessionId = this.findToken(message, pos);
                    pos += sessionId.length();
                    continue;
                }
                if (ch == 'T') {
                    String time2 = this.findDouble(message, pos);
                    double dd = 0.0;
                    try {
                        dd = Double.parseDouble(time2);
                        processingTime = (long)(dd *= 1000.0);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    pos += time2.length();
                    continue;
                }
                if (ch == 'u') {
                    remoteUser = this.findToken(message, pos);
                    pos += remoteUser.length();
                    continue;
                }
                if (ch == 'U') {
                    uri = this.findRequestLine(message, pos);
                    int j = uri.indexOf(63);
                    pos += uri.length();
                    if (j <= 0) continue;
                    query = uri.substring(j + 1);
                    uri = uri.substring(0, j);
                    continue;
                }
                if (ch != 'v') continue;
                serverName = this.findToken(message, pos);
                pos += serverName.length();
                continue;
            }
            catch (ParseException e) {
                e.printStackTrace();
                throw e;
            }
            catch (Exception e) {
                e.printStackTrace();
                String p = null;
                p = this.pattern[i].param != null ? "%{" + this.pattern[i].param + "}" + this.pattern[i].pattern : "%" + this.pattern[i].pattern;
                throw new ParseException("parse failed. pattern = " + p + ", message = " + message, pos);
            }
        }
        return new JeusAccessRecord(Level.INFO, message, "", date, localIP, remoteIP, contentLength, remoteHostname, protocol, method, serverPort, status, processingTime, query, uri, sessionId, remoteUser, serverName, sessionAttributes, requestAttributes, cookieValues, headerValues, dateFormat).getLogInfo();
    }

    private class PatternUnit {
        char pattern;
        String param;
        String fixedMessage;

        private PatternUnit() {
        }

        public String toString() {
            return "PatternUnit : fixed[" + this.fixedMessage + "] pattern=[" + this.pattern + "] param =[" + this.param + "]";
        }
    }
}

