/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.objio;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectStreamConstants;
import java.io.StreamCorruptedException;
import java.io.UTFDataFormatException;
import java.io.WriteAbortedException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import jeus.util.JeusProperties;
import jeus.util.ResetStringBuffer;
import jeus.util.SecondChanceCacheMap;
import jeus.util.objio.Bits;
import jeus.util.objio.ObjectInOutConstants;
import jeus.util.objio.ObjectStreamClass;
import jeus.util.objio.ObjectStreamField;
import jeus.util.objio.OptionalDataException;
import sun.misc.SoftCache;

public class ObjectInputStream
extends java.io.ObjectInputStream
implements ObjectInput,
ObjectStreamConstants {
    private static final int NULL_HANDLE = -1;
    private static final Object unsharedMarker = new Object();
    private static final HashMap primClasses = new HashMap(8, 1.0f);
    private static final SoftCache subclassAudits;
    private BlockDataInputStream bin;
    private int depth;
    private boolean closed;
    private HandleTable handles;
    private HandleTable constantHandles;
    private int passHandle = -1;
    private boolean defaultDataEnd = false;
    private byte[] primVals;
    private boolean enableResolve;
    private Object curObj;
    private ObjectStreamClass curDesc;
    private Map descriptorCache = null;
    private int maxClassDescCount = ObjectInOutConstants.defaultMaxClassCacheSize;
    public static final boolean USE_LATEST_STACK_CLASSLOADER;
    private static ClassLoader defaultClassLoader;
    private static final Class[] NO_ARGS;
    private static Method lastestUserLoaderMethod;
    private ClassLoader resolveClassLoader = defaultClassLoader;

    private static Method getLatestClassLoaderMethod() {
        return (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method result = null;
                try {
                    Class<java.io.ObjectInputStream> io = java.io.ObjectInputStream.class;
                    result = io.getDeclaredMethod("latestUserDefinedLoader", NO_ARGS);
                    result.setAccessible(true);
                }
                catch (NoSuchMethodException nsme) {
                    throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + nsme);
                }
                return result;
            }
        });
    }

    public final void setResolveClass(ClassLoader defaultClassLoader) {
        this.resolveClassLoader = defaultClassLoader;
    }

    public static void setDefaultResolveClass(ClassLoader _defaultClassLoader) {
        if (_defaultClassLoader == null) {
            return;
        }
        defaultClassLoader = _defaultClassLoader;
    }

    public ObjectInputStream(InputStream in) throws IOException {
        this(in, true);
    }

    public ObjectInputStream(InputStream in, boolean readHeader) throws IOException {
        this.verifySubclass();
        this.bin = new BlockDataInputStream(in, this);
        this.handles = new HandleTable(10);
        this.constantHandles = new HandleTable(10);
        if (readHeader) {
            this.readStreamHeader();
        }
        this.bin.setBlockDataModeJeus(true);
        if (ObjectInOutConstants.CLASS_CACHE) {
            this.descriptorCache = new SecondChanceCacheMap(this.maxClassDescCount);
        }
    }

    public final void replace(InputStream in) throws IOException {
        this.bin = new BlockDataInputStream(in, this);
        this.bin.setBlockDataModeJeus(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object readObjectOverride() throws IOException, ClassNotFoundException {
        int outerHandle = this.passHandle;
        try {
            Object obj = this.readObject0(false);
            this.handles.markDependency(outerHandle, this.passHandle);
            ClassNotFoundException ex = this.handles.lookupException(this.passHandle);
            if (ex != null) {
                throw ex;
            }
            Object object = obj;
            return object;
        }
        finally {
            this.passHandle = outerHandle;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object readUnshared() throws IOException, ClassNotFoundException {
        int outerHandle = this.passHandle;
        try {
            Object obj = this.readObject0(true);
            this.handles.markDependency(outerHandle, this.passHandle);
            ClassNotFoundException ex = this.handles.lookupException(this.passHandle);
            if (ex != null) {
                throw ex;
            }
            Object object = obj;
            return object;
        }
        finally {
            this.passHandle = outerHandle;
            if (this.closed && this.depth == 0) {
                this.clear();
            }
        }
    }

    public final void defaultReadObject() throws IOException, ClassNotFoundException {
        ClassNotFoundException ex;
        if (this.curObj == null || this.curDesc == null) {
            throw new NotActiveException("not in call to readObject");
        }
        this.defaultReadFields(this.curObj, this.curDesc);
        if (!this.curDesc.hasWriteObjectData()) {
            this.defaultDataEnd = true;
        }
        if ((ex = this.handles.lookupException(this.passHandle)) != null) {
            throw ex;
        }
    }

    protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        String name = desc.getName();
        if (USE_LATEST_STACK_CLASSLOADER) {
            try {
                return Class.forName(name, false, ObjectStreamClass.UseReflect ? ObjectInputStream.getLatestUserDefinedLoader() : ObjectInputStream.latestUserDefinedLoader0(java.io.ObjectInputStream.class));
            }
            catch (ClassNotFoundException ex) {
                Class cl = (Class)primClasses.get(name);
                if (cl != null) {
                    return cl;
                }
                throw ex;
            }
        }
        ClassLoader _cl = Thread.currentThread().getContextClassLoader();
        if (_cl == null) {
            _cl = this.resolveClassLoader;
        }
        boolean secondTry = false;
        try {
            Class<?> cl = Class.forName(name, false, _cl);
            if (cl != null) {
                return cl;
            }
            secondTry = true;
            return Class.forName(name, false, ObjectStreamClass.UseReflect ? ObjectInputStream.getLatestUserDefinedLoader() : ObjectInputStream.latestUserDefinedLoader0(java.io.ObjectInputStream.class));
        }
        catch (ClassNotFoundException ex) {
            if (secondTry) {
                Class cl = (Class)primClasses.get(name);
                if (cl != null) {
                    return cl;
                }
                throw ex;
            }
            try {
                return Class.forName(name, false, ObjectStreamClass.UseReflect ? ObjectInputStream.getLatestUserDefinedLoader() : ObjectInputStream.latestUserDefinedLoader0(java.io.ObjectInputStream.class));
            }
            catch (ClassNotFoundException ex2) {
                Class cl = (Class)primClasses.get(name);
                if (cl != null) {
                    return cl;
                }
                throw ex2;
            }
        }
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        ClassLoader latestLoader = ObjectStreamClass.UseReflect ? ObjectInputStream.getLatestUserDefinedLoader() : ObjectInputStream.latestUserDefinedLoader0(java.io.ObjectInputStream.class);
        ClassLoader nonPublicLoader = null;
        boolean hasNonPublicInterface = false;
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, latestLoader);
            if ((cl.getModifiers() & 1) == 0) {
                if (hasNonPublicInterface) {
                    if (nonPublicLoader != cl.getClassLoader()) {
                        throw new IllegalAccessError("conflicting non-public interface class loaders");
                    }
                } else {
                    nonPublicLoader = cl.getClassLoader();
                    hasNonPublicInterface = true;
                }
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(hasNonPublicInterface ? nonPublicLoader : latestLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    protected Object resolveObject(Object obj) throws IOException {
        return obj;
    }

    protected boolean enableResolveObject(boolean enable) throws SecurityException {
        SecurityManager sm;
        if (enable == this.enableResolve) {
            return enable;
        }
        if (enable && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(SUBSTITUTION_PERMISSION);
        }
        this.enableResolve = enable;
        return !this.enableResolve;
    }

    protected void readStreamHeader() throws IOException, StreamCorruptedException {
        if (this.bin.readShort() != -24094 || this.bin.readShort() != 1020) {
            throw new StreamCorruptedException("invalid stream header");
        }
    }

    public final int read() throws IOException {
        return this.bin.read();
    }

    public final int read(byte[] buf, int off, int len) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.bin.read(buf, off, len, false);
    }

    public final int available() throws IOException {
        return this.bin.available();
    }

    public final void close() throws IOException {
        this.closed = true;
        if (this.depth == 0) {
            this.clear();
        }
        this.bin.close();
    }

    public final boolean readBoolean() throws IOException {
        return this.bin.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.bin.readByte();
    }

    public final int readUnsignedByte() throws IOException {
        return this.bin.readUnsignedByte();
    }

    public final char readChar() throws IOException {
        return this.bin.readChar();
    }

    public final short readShort() throws IOException {
        return this.bin.readShort();
    }

    public final int readUnsignedShort() throws IOException {
        return this.bin.readUnsignedShort();
    }

    public final int readInt() throws IOException {
        return this.bin.readInt();
    }

    public final long readLong() throws IOException {
        return this.bin.readLong();
    }

    public final float readFloat() throws IOException {
        return this.bin.readFloat();
    }

    public final double readDouble() throws IOException {
        return this.bin.readDouble();
    }

    public final void readFully(byte[] buf) throws IOException {
        this.bin.readFully(buf, 0, buf.length, false);
    }

    public final void readFully(byte[] buf, int off, int len) throws IOException {
        int endoff = off + len;
        if (off < 0 || len < 0 || endoff > buf.length || endoff < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.bin.readFully(buf, off, len, false);
    }

    public final int skipBytes(int len) throws IOException {
        return this.bin.skipBytes(len);
    }

    public final String readLine() throws IOException {
        return this.bin.readLine();
    }

    public final String readUTF() throws IOException {
        return this.bin.readUTF();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifySubclass() {
        Class<?> cl = this.getClass();
        SoftCache softCache = subclassAudits;
        synchronized (softCache) {
            Boolean result = (Boolean)subclassAudits.get(cl);
            if (result == null) {
                result = new Boolean(ObjectInputStream.auditSubclass(cl));
                subclassAudits.put(cl, (Object)result);
            }
            if (result.booleanValue()) {
                return;
            }
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(SUBCLASS_IMPLEMENTATION_PERMISSION);
        }
    }

    private static boolean auditSubclass(final Class subcl) {
        Boolean result = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (Class cl = subcl; cl != ObjectInputStream.class; cl = cl.getSuperclass()) {
                    try {
                        cl.getDeclaredMethod("readUnshared", new Class[0]);
                        return Boolean.FALSE;
                    }
                    catch (NoSuchMethodException ex) {
                        try {
                            cl.getDeclaredMethod("readFields", new Class[0]);
                            return Boolean.FALSE;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            continue;
                        }
                    }
                }
                return Boolean.TRUE;
            }
        });
        return result;
    }

    private void clearObjectData() {
        if (ObjectInOutConstants.CLASS_CACHE) {
            this.descriptorCache.clear();
        }
        this.handles.clear();
        if (this.bin != null) {
            this.bin.resetBuffer();
        }
    }

    private void clear() {
        this.clearObjectData();
        this.constantHandles.clear();
    }

    public final void resetForFirst() throws IOException {
        this.resetForFirst(true);
    }

    public final void resetForFirst(boolean readHeader) throws IOException {
        this.handles.clear();
        this.constantHandles.clear();
        this.passHandle = -1;
        this.bin.resetBuffer2();
        if (readHeader) {
            this.bin.setBlockDataModeJeus(false);
            this.readStreamHeader();
            this.bin.setBlockDataModeJeus(true);
        }
    }

    private Object readObject0(boolean unshared) throws IOException {
        byte tc = this.bin.peekByte();
        ++this.depth;
        try {
            switch (tc) {
                case 112: {
                    Object object = this.readNull();
                    return object;
                }
                case 63: {
                    Object object = this.readConstantHandle(unshared);
                    return object;
                }
                case 113: {
                    Object object = this.readHandle(unshared);
                    return object;
                }
                case 118: {
                    Class clazz = this.readClass(unshared);
                    return clazz;
                }
                case 114: 
                case 125: {
                    ObjectStreamClass objectStreamClass = this.readClassDesc(unshared);
                    return objectStreamClass;
                }
                case 53: 
                case 54: 
                case 116: 
                case 124: {
                    Object object = this.checkResolve(this.readString(unshared));
                    return object;
                }
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 59: 
                case 60: 
                case 61: 
                case 62: 
                case 117: {
                    Object object = this.checkResolve(this.readArray(unshared));
                    return object;
                }
                case 115: {
                    Object object = this.checkResolve(this.readOrdinaryObject(unshared));
                    return object;
                }
                case 123: {
                    IOException ex = this.readFatalException();
                    throw new WriteAbortedException("writing aborted", ex);
                }
                case 119: 
                case 122: {
                    this.bin.peek();
                    throw new OptionalDataException(this.bin.currentBlockRemaining());
                }
                case 120: {
                    throw new OptionalDataException(true);
                }
            }
            throw new StreamCorruptedException();
        }
        finally {
            --this.depth;
        }
    }

    private Object checkResolve(Object obj) throws IOException {
        if (!this.enableResolve || this.handles.lookupException(this.passHandle) != null) {
            return obj;
        }
        Object rep = this.resolveObject(obj);
        if (rep != obj) {
            this.handles.setObject(this.passHandle, rep);
        }
        return rep;
    }

    final String readTypeString() throws IOException {
        int oldHandle = this.passHandle;
        try {
            switch (this.bin.peekByte()) {
                case 112: {
                    String string = (String)this.readNull();
                    return string;
                }
                case 113: {
                    String string = (String)this.readHandle(false);
                    return string;
                }
                case 116: 
                case 124: {
                    String string = this.readString(false);
                    return string;
                }
            }
            throw new StreamCorruptedException();
        }
        finally {
            this.passHandle = oldHandle;
        }
    }

    private Object readNull() throws IOException {
        if (this.bin.readByte() != 112) {
            throw new StreamCorruptedException();
        }
        this.passHandle = -1;
        return null;
    }

    private Object readHandle(boolean unshared) throws IOException {
        if (this.bin.readByte() != 113) {
            throw new StreamCorruptedException();
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.handles.size()) {
            throw new StreamCorruptedException("illegal handle value");
        }
        if (unshared) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        Object obj = this.handles.lookupObject(this.passHandle);
        if (obj == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        return obj;
    }

    private Object readConstantHandle(boolean unshared) throws IOException {
        if (this.bin.readByte() != 63) {
            throw new StreamCorruptedException();
        }
        this.passHandle = this.bin.readInt() - 0x7E0000;
        if (this.passHandle < 0 || this.passHandle >= this.constantHandles.size()) {
            throw new StreamCorruptedException("illegal handle value");
        }
        if (unshared) {
            throw new InvalidObjectException("cannot read back reference as unshared");
        }
        Object obj = this.constantHandles.lookupObject(this.passHandle);
        if (obj == unsharedMarker) {
            throw new InvalidObjectException("cannot read back reference to unshared object");
        }
        return obj;
    }

    private Class readClass(boolean unshared) throws IOException {
        if (this.bin.readByte() != 118) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        Class cl = desc.forClass();
        this.passHandle = this.constantHandles.assign(unshared ? unsharedMarker : cl);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        this.constantHandles.finish(this.passHandle);
        return cl;
    }

    private ObjectStreamClass readClassDesc(boolean unshared) throws IOException {
        switch (this.bin.peekByte()) {
            case 112: {
                return (ObjectStreamClass)this.readNull();
            }
            case 63: {
                return (ObjectStreamClass)this.readConstantHandle(unshared);
            }
            case 113: {
                return (ObjectStreamClass)this.readHandle(unshared);
            }
            case 125: {
                return this.readProxyDesc(unshared);
            }
            case 114: {
                return this.readNonProxyDesc(unshared);
            }
        }
        throw new StreamCorruptedException();
    }

    private ObjectStreamClass readProxyDesc(boolean unshared) throws IOException {
        if (this.bin.readByte() != 125) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        int descHandle = this.constantHandles.assign(unshared ? unsharedMarker : desc);
        this.passHandle = -1;
        int numIfaces = this.bin.readInt();
        String[] ifaces = new String[numIfaces];
        for (int i = 0; i < numIfaces; ++i) {
            ifaces[i] = this.bin.readUTF();
        }
        Class cl = null;
        ClassNotFoundException resolveEx = null;
        try {
            cl = this.resolveProxyClass(ifaces);
            if (cl == null) {
                throw new ClassNotFoundException("null class");
            }
        }
        catch (ClassNotFoundException ex) {
            resolveEx = ex;
        }
        desc.initProxy(cl, resolveEx, this.readClassDesc(false));
        this.constantHandles.finish(descHandle);
        this.passHandle = descHandle;
        return desc;
    }

    private ObjectStreamClass readNonProxyDesc(boolean unshared) throws IOException {
        if (this.bin.readByte() != 114) {
            throw new StreamCorruptedException();
        }
        ObjectStreamClass desc = new ObjectStreamClass();
        int descHandle = this.constantHandles.assign(unshared ? unsharedMarker : desc);
        this.passHandle = -1;
        ObjectStreamClass readDesc = null;
        try {
            readDesc = new ObjectStreamClass();
            readDesc.readNonProxy(this);
        }
        catch (ClassNotFoundException ex) {
            throw (IOException)new InvalidClassException("failed to read class descriptor").initCause(ex);
        }
        catch (ClassCastException ex) {
            throw (IOException)new InvalidClassException("failed to get jeus.util.objio.ObjectStreamClass from readClassDescriptor").initCause(ex);
        }
        Class cl = null;
        ClassNotFoundException resolveEx = null;
        try {
            cl = this.resolveClass(readDesc);
            if (cl == null) {
                throw new ClassNotFoundException("null class");
            }
        }
        catch (ClassNotFoundException ex) {
            resolveEx = ex;
        }
        if (cl != null) {
            desc.initNonProxy(readDesc, cl, resolveEx, this.readClassDesc(false), ObjectStreamClass.getClassDescriptor(cl, this.descriptorCache));
        } else {
            desc.initNonProxy(readDesc, cl, resolveEx, this.readClassDesc(false), null);
        }
        this.constantHandles.finish(descHandle);
        this.passHandle = descHandle;
        return desc;
    }

    private String readString(boolean unshared) throws IOException {
        String str;
        switch (this.bin.readByte()) {
            case 53: {
                str = this.bin.readSimpleUTF();
                break;
            }
            case 116: {
                str = this.bin.readUTF();
                break;
            }
            case 54: {
                str = this.bin.readSimpleLongUTF();
                break;
            }
            case 124: {
                str = this.bin.readLongUTF();
                break;
            }
            default: {
                throw new StreamCorruptedException();
            }
        }
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : str);
        this.handles.finish(this.passHandle);
        return str;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object readArray(boolean unshared) throws IOException {
        byte _oneByteRead = this.bin.readByte();
        switch (_oneByteRead) {
            case 55: {
                int len = this.bin.readInt();
                int[] data = new int[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readInts(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 56: {
                int len = this.bin.readInt();
                byte[] data = new byte[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readFully(data, 0, len, true);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 57: {
                int len = this.bin.readInt();
                long[] data = new long[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readLongs(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 58: {
                int len = this.bin.readInt();
                float[] data = new float[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readFloats(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 59: {
                int len = this.bin.readInt();
                double[] data = new double[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readDoubles(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 60: {
                int len = this.bin.readInt();
                short[] data = new short[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readShorts(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 61: {
                int len = this.bin.readInt();
                char[] data = new char[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readChars(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
            case 62: {
                int len = this.bin.readInt();
                boolean[] data = new boolean[len];
                int arrayHandle = this.handles.assign(unshared ? unsharedMarker : (Object)data);
                this.bin.readBooleans(data, 0, len);
                this.handles.finish(arrayHandle);
                this.passHandle = arrayHandle;
                return data;
            }
        }
        ObjectStreamClass desc = this.readClassDesc(false);
        int len = this.bin.readInt();
        Object array = null;
        Class<?> ccl = null;
        Class cl = desc.forClass();
        if (cl != null) {
            ccl = cl.getComponentType();
            array = Array.newInstance(ccl, len);
        }
        int arrayHandle = this.handles.assign(unshared ? unsharedMarker : array);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(arrayHandle, resolveEx);
        }
        if (ccl == null) {
            for (int i = 0; i < len; ++i) {
                this.readObject0(false);
            }
        } else if (ccl.isPrimitive()) {
            if (ccl == Integer.TYPE) {
                this.bin.readInts((int[])array, 0, len);
            } else if (ccl == Byte.TYPE) {
                this.bin.readFully((byte[])array, 0, len, true);
            } else if (ccl == Long.TYPE) {
                this.bin.readLongs((long[])array, 0, len);
            } else if (ccl == Float.TYPE) {
                this.bin.readFloats((float[])array, 0, len);
            } else if (ccl == Double.TYPE) {
                this.bin.readDoubles((double[])array, 0, len);
            } else if (ccl == Short.TYPE) {
                this.bin.readShorts((short[])array, 0, len);
            } else if (ccl == Character.TYPE) {
                this.bin.readChars((char[])array, 0, len);
            } else {
                if (ccl != Boolean.TYPE) throw new InternalError();
                this.bin.readBooleans((boolean[])array, 0, len);
            }
        } else {
            Object[] oa = (Object[])array;
            for (int i = 0; i < len; ++i) {
                oa[i] = this.readObject0(false);
                this.handles.markDependency(arrayHandle, this.passHandle);
            }
        }
        this.handles.finish(arrayHandle);
        this.passHandle = arrayHandle;
        return array;
    }

    private Object readOrdinaryObject(boolean unshared) throws IOException {
        Object rep;
        Object obj;
        this.bin.readByte();
        ObjectStreamClass desc = this.readClassDesc(false);
        desc.checkDeserialize();
        try {
            obj = desc.isInstantiable() ? desc.newInstance() : null;
        }
        catch (Exception ex) {
            throw new InvalidClassException(desc.forClass().getName(), "unable to create instance");
        }
        this.passHandle = this.handles.assign(unshared ? unsharedMarker : obj);
        ClassNotFoundException resolveEx = desc.getResolveException();
        if (resolveEx != null) {
            this.handles.markException(this.passHandle, resolveEx);
        }
        if (desc.isExternalizable()) {
            this.readExternalData((Externalizable)obj, desc);
        } else {
            this.readSerialData(obj, desc);
        }
        this.handles.finish(this.passHandle);
        if (obj != null && this.handles.lookupException(this.passHandle) == null && desc.hasReadResolveMethod() && (rep = desc.invokeReadResolve(obj)) != obj) {
            obj = rep;
            this.handles.setObject(this.passHandle, obj);
        }
        return obj;
    }

    private void readExternalData(Externalizable obj, ObjectStreamClass desc) throws IOException {
        Object oldObj = this.curObj;
        ObjectStreamClass oldDesc = this.curDesc;
        this.curObj = obj;
        this.curDesc = null;
        if (obj != null) {
            try {
                obj.readExternal(this);
            }
            catch (ClassNotFoundException ex) {
                this.handles.markException(this.passHandle, ex);
            }
        }
        this.curObj = oldObj;
        this.curDesc = oldDesc;
    }

    private void readSerialData(Object obj, ObjectStreamClass desc) throws IOException {
        ObjectStreamClass.ClassDataSlot[] slots = null;
        if (ObjectInOutConstants.AllowNonserial && !desc.isSerializable()) {
            if (desc.isShouldNotBeSerializable) {
                return;
            }
            slots = desc.getClassDataLayoutNonSerial();
        } else {
            slots = desc.getClassDataLayout();
        }
        for (int i = 0; i < slots.length; ++i) {
            ObjectStreamClass slotDesc = slots[i].desc;
            if (slots[i].hasData) {
                if (obj != null && slotDesc.hasReadObjectMethod() && this.handles.lookupException(this.passHandle) == null) {
                    Object oldObj = this.curObj;
                    ObjectStreamClass oldDesc = this.curDesc;
                    this.curObj = obj;
                    this.curDesc = slotDesc;
                    try {
                        slotDesc.invokeReadObject(obj, this);
                    }
                    catch (ClassNotFoundException ex) {
                        this.handles.markException(this.passHandle, ex);
                    }
                    this.curObj = oldObj;
                    this.curDesc = oldDesc;
                    this.defaultDataEnd = false;
                    continue;
                }
                this.defaultReadFields(obj, slotDesc);
                continue;
            }
            if (obj == null || !slotDesc.hasReadObjectNoDataMethod() || this.handles.lookupException(this.passHandle) != null) continue;
            slotDesc.invokeReadObjectNoData(obj);
        }
    }

    private void defaultReadFields(Object obj, ObjectStreamClass desc) throws IOException {
        Class cl = desc.forClass();
        ObjectStreamField[] fields = desc.getFields(false);
        if (cl != null && obj != null && !cl.isInstance(obj)) {
            throw new ClassCastException();
        }
        int primDataSize = desc.getPrimDataSize();
        if (this.primVals == null || this.primVals.length < primDataSize) {
            this.primVals = new byte[primDataSize];
        }
        this.bin.readFully(this.primVals, 0, primDataSize, false);
        if (obj != null && primDataSize > 0) {
            if (ObjectStreamClass.UseReflect) {
                ObjectStreamClass.setPrimitiveValues(obj, this.primVals, fields);
            } else {
                ObjectInputStream.setPrimitiveFieldValues(obj, desc.primFieldIDs, desc.primFieldTypecodes, this.primVals);
            }
        }
        int objHandle = this.passHandle;
        Object[] objVals = new Object[desc.getNumObjFields()];
        int numPrimFields = fields.length - objVals.length;
        for (int i = 0; i < objVals.length; ++i) {
            ObjectStreamField f = fields[numPrimFields + i];
            objVals[i] = this.readObject0(f.isUnshared());
            if (f.getField() == null) continue;
            this.handles.markDependency(objHandle, this.passHandle);
        }
        if (obj != null && desc.objFieldIDs != null && desc.objFieldIDs.length > 0) {
            if (ObjectStreamClass.UseReflect) {
                ObjectStreamClass.setObjectValues(obj, fields, objVals);
            } else {
                ObjectInputStream.setObjectFieldValues(obj, desc.objFieldIDs, objVals, desc.objFieldIDs.length);
            }
        }
        this.passHandle = objHandle;
    }

    private IOException readFatalException() throws IOException {
        if (this.bin.readByte() != 123) {
            throw new StreamCorruptedException();
        }
        this.clear();
        return (IOException)this.readObject0(false);
    }

    private void handleReset() throws StreamCorruptedException {
        if (this.depth > 0) {
            throw new StreamCorruptedException("unexpected reset");
        }
        this.clear();
    }

    private static native void setPrimitiveFieldValues(Object var0, long[] var1, char[] var2, byte[] var3);

    private static native void setObjectFieldValues(Object var0, long[] var1, Object[] var2, int var3);

    private static native void setFieldValues(Object var0, long[] var1, char[] var2, byte[] var3, int var4, long[] var5, Object[] var6);

    private static native void bytesToFloats(byte[] var0, int var1, float[] var2, int var3, int var4);

    private static native void bytesToDoubles(byte[] var0, int var1, double[] var2, int var3, int var4);

    public static native ClassLoader latestUserDefinedLoader0(Class var0);

    static ClassLoader getLatestUserDefinedLoader() throws ClassNotFoundException {
        try {
            return (ClassLoader)lastestUserLoaderMethod.invoke(null, null);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
        catch (InvocationTargetException e) {
            throw new ClassNotFoundException("Cannot find the latest user classloader", e);
        }
    }

    static {
        try {
            System.loadLibrary("JeusObjIO");
        }
        catch (Throwable th) {
            ObjectStreamClass.UseReflect = true;
        }
        lastestUserLoaderMethod = (Method)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Method result = null;
                try {
                    Class<java.io.ObjectInputStream> io = java.io.ObjectInputStream.class;
                    result = io.getDeclaredMethod("latestUserDefinedLoader", NO_ARGS);
                    result.setAccessible(true);
                }
                catch (NoSuchMethodException nsme) {
                    throw new Error("java.io.ObjectInputStream latestUserDefinedLoader " + nsme);
                }
                return result;
            }
        });
        primClasses.put("boolean", Boolean.TYPE);
        primClasses.put("byte", Byte.TYPE);
        primClasses.put("char", Character.TYPE);
        primClasses.put("short", Short.TYPE);
        primClasses.put("int", Integer.TYPE);
        primClasses.put("long", Long.TYPE);
        primClasses.put("float", Float.TYPE);
        primClasses.put("double", Double.TYPE);
        primClasses.put("void", Void.TYPE);
        subclassAudits = new SoftCache(5);
        USE_LATEST_STACK_CLASSLOADER = JeusProperties.getBooleanParamValue("jeus.util.objio.USE_LATEST_STACK_CLASSLOADER", false);
        defaultClassLoader = ClassLoader.getSystemClassLoader();
        NO_ARGS = new Class[0];
        lastestUserLoaderMethod = ObjectInputStream.getLatestClassLoaderMethod();
    }

    private static class HandleTable {
        private static final byte STATUS_OK = 1;
        private static final byte STATUS_UNKNOWN = 2;
        private static final byte STATUS_EXCEPTION = 3;
        byte[] status;
        Object[] entries;
        HandleList[] deps;
        int lowDep = -1;
        int size = 0;

        HandleTable(int initialCapacity) {
            this.status = new byte[initialCapacity];
            this.entries = new Object[initialCapacity];
            this.deps = new HandleList[initialCapacity];
        }

        final int assign(Object obj) {
            if (this.size >= this.entries.length) {
                this.grow();
            }
            this.status[this.size] = 2;
            this.entries[this.size] = obj;
            return this.size++;
        }

        final void markDependency(int dependent, int target) {
            if (dependent == -1 || target == -1) {
                return;
            }
            block0 : switch (this.status[dependent]) {
                case 2: {
                    switch (this.status[target]) {
                        case 1: {
                            break block0;
                        }
                        case 3: {
                            this.markException(dependent, (ClassNotFoundException)this.entries[target]);
                            break block0;
                        }
                        case 2: {
                            if (this.deps[target] == null) {
                                this.deps[target] = new HandleList();
                            }
                            this.deps[target].add(dependent);
                            if (this.lowDep >= 0 && this.lowDep <= target) break block0;
                            this.lowDep = target;
                            break block0;
                        }
                        default: {
                            throw new InternalError();
                        }
                    }
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        final void markException(int handle, ClassNotFoundException ex) {
            switch (this.status[handle]) {
                case 2: {
                    this.status[handle] = 3;
                    this.entries[handle] = ex;
                    HandleList dlist = this.deps[handle];
                    if (dlist == null) break;
                    int ndeps = dlist.size();
                    for (int i = 0; i < ndeps; ++i) {
                        this.markException(dlist.get(i), ex);
                    }
                    this.deps[handle] = null;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        final void finish(int handle) {
            int end;
            if (this.lowDep < 0) {
                end = handle + 1;
            } else if (this.lowDep >= handle) {
                end = this.size;
                this.lowDep = -1;
            } else {
                return;
            }
            block4: for (int i = handle; i < end; ++i) {
                switch (this.status[i]) {
                    case 2: {
                        this.status[i] = 1;
                        this.deps[i] = null;
                        continue block4;
                    }
                    case 1: 
                    case 3: {
                        continue block4;
                    }
                    default: {
                        throw new InternalError();
                    }
                }
            }
        }

        final void setObject(int handle, Object obj) {
            switch (this.status[handle]) {
                case 1: 
                case 2: {
                    this.entries[handle] = obj;
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
        }

        final Object lookupObject(int handle) {
            return handle != -1 && this.status[handle] != 3 ? this.entries[handle] : null;
        }

        final ClassNotFoundException lookupException(int handle) {
            return handle != -1 && this.status[handle] == 3 ? (ClassNotFoundException)this.entries[handle] : null;
        }

        final void clear() {
            Arrays.fill(this.status, 0, this.size, (byte)0);
            Arrays.fill(this.entries, 0, this.size, null);
            Arrays.fill(this.deps, 0, this.size, null);
            this.lowDep = -1;
            this.size = 0;
        }

        final int size() {
            return this.size;
        }

        private void grow() {
            int newCapacity = (this.entries.length << 1) + 1;
            byte[] newStatus = new byte[newCapacity];
            Object[] newEntries = new Object[newCapacity];
            HandleList[] newDeps = new HandleList[newCapacity];
            System.arraycopy(this.status, 0, newStatus, 0, this.size);
            System.arraycopy(this.entries, 0, newEntries, 0, this.size);
            System.arraycopy(this.deps, 0, newDeps, 0, this.size);
            this.status = newStatus;
            this.entries = newEntries;
            this.deps = newDeps;
        }

        private static class HandleList {
            private int[] list = new int[4];
            private int size = 0;

            public final void add(int handle) {
                if (this.size >= this.list.length) {
                    int[] newList = new int[this.list.length << 1];
                    System.arraycopy(this.list, 0, newList, 0, this.list.length);
                    this.list = newList;
                }
                this.list[this.size++] = handle;
            }

            public final int get(int index) {
                if (index >= this.size) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                return this.list[index];
            }

            public final int size() {
                return this.size;
            }
        }
    }

    public static class BlockDataInputStream
    extends InputStream
    implements DataInput {
        private static final int MAX_BLOCK_SIZE = ObjectInOutConstants.MAX_BLOCK_SIZE;
        private static final int MAX_HEADER_SIZE = 5;
        private static final int CHAR_BUF_SIZE = ObjectInOutConstants.CHAR_BUF_SIZE;
        private static final int HEADER_BLOCKED = -2;
        private final byte[] buf = new byte[MAX_BLOCK_SIZE];
        private final byte[] hbuf = new byte[5];
        private final char[] cbuf = new char[CHAR_BUF_SIZE];
        private boolean blkmode = false;
        private int pos = 0;
        private int end = -1;
        private int unread = 0;
        private final PeekInputStream in;
        private final DataInputStream din;
        private ObjectInputStream jois;
        ResetStringBuffer sbuf = new ResetStringBuffer();

        BlockDataInputStream(InputStream in, ObjectInputStream _jois) {
            this.jois = _jois;
            this.in = new PeekInputStream(in);
            this.din = new DataInputStream(this);
        }

        final void resetBuffer() {
            this.sbuf = new ResetStringBuffer();
        }

        void resetBuffer2() {
            this.sbuf.reset();
        }

        final boolean setBlockDataModeJeus(boolean newmode) throws IOException {
            if (this.blkmode == newmode) {
                return this.blkmode;
            }
            if (newmode) {
                this.pos = 0;
                this.end = 0;
                this.unread = 0;
            } else if (this.pos < this.end) {
                throw new IllegalStateException("unread block data");
            }
            this.blkmode = newmode;
            return !this.blkmode;
        }

        final boolean getBlockDataMode() {
            return this.blkmode;
        }

        final void skipBlockData() throws IOException {
            if (!this.blkmode) {
                throw new IllegalStateException("not in block data mode");
            }
            while (this.end >= 0) {
                this.refill();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private int readBlockHeader(boolean canBlock) throws IOException {
            if (this.jois.defaultDataEnd) {
                return -1;
            }
            try {
                int tc;
                block8: while (true) {
                    int avail;
                    int n = avail = canBlock ? Integer.MAX_VALUE : this.in.available();
                    if (avail == 0) {
                        return -2;
                    }
                    tc = this.in.peek();
                    switch (tc) {
                        case 49: 
                        case 50: 
                        case 119: {
                            if (avail < 2) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 2);
                            return this.hbuf[1] & 0xFF;
                        }
                        case 51: 
                        case 52: 
                        case 122: {
                            if (avail < 5) {
                                return -2;
                            }
                            this.in.readFully(this.hbuf, 0, 5);
                            int len = Bits.getInt(this.hbuf, 1);
                            if (len < 0) {
                                throw new StreamCorruptedException("illegal block data header length");
                            }
                            return len;
                        }
                        case 121: {
                            this.in.read();
                            this.jois.handleReset();
                            continue block8;
                        }
                        case 64: {
                            this.in.read();
                            this.jois.clearObjectData();
                            continue block8;
                        }
                    }
                    break;
                }
                if (tc >= 0 && (tc < 112 || tc > 126)) {
                    throw new StreamCorruptedException();
                }
                return -1;
            }
            catch (EOFException ex) {
                throw new StreamCorruptedException("unexpected EOF while reading block data header");
            }
        }

        private void refill() throws IOException {
            try {
                do {
                    int n;
                    this.pos = 0;
                    if (this.unread > 0) {
                        n = this.in.read(this.buf, 0, Math.min(this.unread, MAX_BLOCK_SIZE));
                        if (n >= 0) {
                            this.end = n;
                            this.unread -= n;
                            continue;
                        }
                        throw new StreamCorruptedException("unexpected EOF in middle of data block");
                    }
                    n = this.readBlockHeader(true);
                    if (n >= 0) {
                        this.end = 0;
                        this.unread = n;
                        continue;
                    }
                    this.end = -1;
                    this.unread = 0;
                } while (this.pos == this.end);
            }
            catch (IOException ex) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
                throw ex;
            }
        }

        final int currentBlockRemaining() {
            if (this.blkmode) {
                return this.end >= 0 ? this.end - this.pos + this.unread : 0;
            }
            throw new IllegalStateException();
        }

        final int peek() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos] & 0xFF : -1;
            }
            return this.in.peek();
        }

        final byte peekByte() throws IOException {
            int val = this.peek();
            if (val < 0) {
                throw new EOFException();
            }
            return (byte)val;
        }

        public final int read() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                return this.end >= 0 ? this.buf[this.pos++] & 0xFF : -1;
            }
            return this.in.read();
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            return this.read(b, off, len, false);
        }

        public final long skip(long len) throws IOException {
            long remain = len;
            while (remain > 0L) {
                int nread;
                if (this.blkmode) {
                    if (this.pos == this.end) {
                        this.refill();
                    }
                    if (this.end < 0) break;
                    nread = (int)Math.min(remain, (long)(this.end - this.pos));
                    remain -= (long)nread;
                    this.pos += nread;
                    continue;
                }
                nread = (int)Math.min(remain, (long)MAX_BLOCK_SIZE);
                if ((nread = this.in.read(this.buf, 0, nread)) < 0) break;
                remain -= (long)nread;
            }
            return len - remain;
        }

        public final int available() throws IOException {
            if (this.blkmode) {
                if (this.pos == this.end && this.unread == 0) {
                    int n;
                    while ((n = this.readBlockHeader(false)) == 0) {
                    }
                    switch (n) {
                        case -2: {
                            break;
                        }
                        case -1: {
                            this.pos = 0;
                            this.end = -1;
                            break;
                        }
                        default: {
                            this.pos = 0;
                            this.end = 0;
                            this.unread = n;
                        }
                    }
                }
                int unreadAvail = this.unread > 0 ? Math.min(this.in.available(), this.unread) : 0;
                return this.end >= 0 ? this.end - this.pos + unreadAvail : 0;
            }
            return this.in.available();
        }

        public final void close() throws IOException {
            if (this.blkmode) {
                this.pos = 0;
                this.end = -1;
                this.unread = 0;
            }
            this.in.close();
        }

        final int read(byte[] b, int off, int len, boolean copy) throws IOException {
            if (len == 0) {
                return 0;
            }
            if (this.blkmode) {
                if (this.pos == this.end) {
                    this.refill();
                }
                if (this.end < 0) {
                    return -1;
                }
                int nread = Math.min(len, this.end - this.pos);
                System.arraycopy(this.buf, this.pos, b, off, nread);
                this.pos += nread;
                return nread;
            }
            if (copy) {
                int nread = this.in.read(this.buf, 0, Math.min(len, MAX_BLOCK_SIZE));
                if (nread > 0) {
                    System.arraycopy(this.buf, 0, b, off, nread);
                }
                return nread;
            }
            return this.in.read(b, off, len);
        }

        public final void readFully(byte[] b) throws IOException {
            this.readFully(b, 0, b.length, false);
        }

        public final void readFully(byte[] b, int off, int len) throws IOException {
            this.readFully(b, off, len, false);
        }

        public final void readFully(byte[] b, int off, int len, boolean copy) throws IOException {
            while (len > 0) {
                int n = this.read(b, off, len, copy);
                if (n < 0) {
                    throw new EOFException();
                }
                off += n;
                len -= n;
            }
        }

        public final int skipBytes(int n) throws IOException {
            return this.din.skipBytes(n);
        }

        public final boolean readBoolean() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v != 0;
        }

        public final byte readByte() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return (byte)v;
        }

        public final int readUnsignedByte() throws IOException {
            int v = this.read();
            if (v < 0) {
                throw new EOFException();
            }
            return v;
        }

        public final char readChar() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readChar();
            }
            char v = Bits.getChar(this.buf, this.pos);
            this.pos += 2;
            return v;
        }

        public final short readShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readShort();
            }
            short v = Bits.getShort(this.buf, this.pos);
            this.pos += 2;
            return v;
        }

        public final int readUnsignedShort() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 2);
            } else if (this.end - this.pos < 2) {
                return this.din.readUnsignedShort();
            }
            int v = Bits.getShort(this.buf, this.pos) & 0xFFFF;
            this.pos += 2;
            return v;
        }

        public final int readInt() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readInt();
            }
            int v = Bits.getInt(this.buf, this.pos);
            this.pos += 4;
            return v;
        }

        public final float readFloat() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 4);
            } else if (this.end - this.pos < 4) {
                return this.din.readFloat();
            }
            float v = Bits.getFloat(this.buf, this.pos);
            this.pos += 4;
            return v;
        }

        public final long readLong() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readLong();
            }
            long v = Bits.getLong(this.buf, this.pos);
            this.pos += 8;
            return v;
        }

        public final double readDouble() throws IOException {
            if (!this.blkmode) {
                this.pos = 0;
                this.in.readFully(this.buf, 0, 8);
            } else if (this.end - this.pos < 8) {
                return this.din.readDouble();
            }
            double v = Bits.getDouble(this.buf, this.pos);
            this.pos += 8;
            return v;
        }

        public final String readSimpleUTF() throws IOException {
            return this.readSimpleBody(this.readUnsignedShort());
        }

        public final String readUTF() throws IOException {
            return this.readUTFBody(this.readUnsignedShort());
        }

        public final String readLine() throws IOException {
            return this.din.readLine();
        }

        final void readBooleans(boolean[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, MAX_BLOCK_SIZE);
                    this.in.readFully(this.buf, 0, span);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 1) {
                        v[off++] = this.din.readBoolean();
                        continue;
                    }
                    stop = Math.min(endoff, off + this.end - this.pos);
                }
                while (off < stop) {
                    v[off++] = Bits.getBoolean(this.buf, this.pos++);
                }
            }
        }

        final void readChars(char[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, MAX_BLOCK_SIZE >> 1);
                    this.in.readFully(this.buf, 0, span << 1);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        v[off++] = this.din.readChar();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 1));
                }
                while (off < stop) {
                    v[off++] = Bits.getChar(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        final void readShorts(short[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, MAX_BLOCK_SIZE >> 1);
                    this.in.readFully(this.buf, 0, span << 1);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 2) {
                        v[off++] = this.din.readShort();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 1));
                }
                while (off < stop) {
                    v[off++] = Bits.getShort(this.buf, this.pos);
                    this.pos += 2;
                }
            }
        }

        final void readInts(int[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, MAX_BLOCK_SIZE >> 2);
                    this.in.readFully(this.buf, 0, span << 2);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        v[off++] = this.din.readInt();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 2));
                }
                while (off < stop) {
                    v[off++] = Bits.getInt(this.buf, this.pos);
                    this.pos += 4;
                }
            }
        }

        final void readFloats(float[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int span;
                if (!this.blkmode) {
                    span = Math.min(endoff - off, MAX_BLOCK_SIZE >> 2);
                    this.in.readFully(this.buf, 0, span << 2);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 4) {
                        v[off++] = this.din.readFloat();
                        continue;
                    }
                    span = Math.min(endoff - off, this.end - this.pos >> 2);
                }
                if (ObjectStreamClass.UseReflect) {
                    for (int i = 0; i < span; ++i) {
                        v[off + i] = Bits.getFloat(this.buf, this.pos + (i << 2));
                    }
                } else {
                    ObjectInputStream.bytesToFloats(this.buf, this.pos, v, off, span);
                }
                off += span;
                this.pos += span << 2;
            }
        }

        final void readLongs(long[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int stop;
                if (!this.blkmode) {
                    int span = Math.min(endoff - off, MAX_BLOCK_SIZE >> 3);
                    this.in.readFully(this.buf, 0, span << 3);
                    stop = off + span;
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        v[off++] = this.din.readLong();
                        continue;
                    }
                    stop = Math.min(endoff, off + (this.end - this.pos >> 3));
                }
                while (off < stop) {
                    v[off++] = Bits.getLong(this.buf, this.pos);
                    this.pos += 8;
                }
            }
        }

        final void readDoubles(double[] v, int off, int len) throws IOException {
            int endoff = off + len;
            while (off < endoff) {
                int span;
                if (!this.blkmode) {
                    span = Math.min(endoff - off, MAX_BLOCK_SIZE >> 3);
                    this.in.readFully(this.buf, 0, span << 3);
                    this.pos = 0;
                } else {
                    if (this.end - this.pos < 8) {
                        v[off++] = this.din.readDouble();
                        continue;
                    }
                    span = Math.min(endoff - off, this.end - this.pos >> 3);
                }
                if (ObjectStreamClass.UseReflect) {
                    for (int i = 0; i < span; ++i) {
                        v[off + i] = Bits.getDouble(this.buf, this.pos + (i << 3));
                    }
                } else {
                    ObjectInputStream.bytesToDoubles(this.buf, this.pos, v, off, span);
                }
                off += span;
                this.pos += span << 3;
            }
        }

        final String readLongUTF() throws IOException {
            return this.readUTFBody(this.readLong());
        }

        public final String readSimpleLongUTF() throws IOException {
            return this.readSimpleBody(this.readLong());
        }

        private String readSimpleBody(long utflen) throws IOException {
            this.sbuf.reset();
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (utflen > 0L) {
                int avail = this.end - this.pos;
                if (avail >= 1 || (long)avail == utflen) {
                    utflen -= this.readSimpleUTFSpan(this.sbuf, utflen);
                    continue;
                }
                if (this.blkmode) {
                    this.sbuf.append((char)(this.readByte() & 0xFF));
                    --utflen;
                    continue;
                }
                if (avail > 0) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, avail);
                }
                this.pos = 0;
                this.end = (int)Math.min((long)MAX_BLOCK_SIZE, utflen);
                this.in.readFully(this.buf, avail, this.end - avail);
            }
            return this.sbuf.toString();
        }

        private String readUTFBody(long utflen) throws IOException {
            this.sbuf.reset();
            if (!this.blkmode) {
                this.pos = 0;
                this.end = 0;
            }
            while (utflen > 0L) {
                int avail = this.end - this.pos;
                if (avail >= 3 || (long)avail == utflen) {
                    utflen -= this.readUTFSpan(this.sbuf, utflen);
                    continue;
                }
                if (this.blkmode) {
                    utflen -= (long)this.readUTFChar(this.sbuf, utflen);
                    continue;
                }
                if (avail > 0) {
                    System.arraycopy(this.buf, this.pos, this.buf, 0, avail);
                }
                this.pos = 0;
                this.end = (int)Math.min((long)MAX_BLOCK_SIZE, utflen);
                this.in.readFully(this.buf, avail, this.end - avail);
            }
            return this.sbuf.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private long readUTFSpan(ResetStringBuffer sbuf, long utflen) throws IOException {
            int start;
            int cpos;
            block13: {
                cpos = 0;
                start = this.pos;
                int avail = Math.min(this.end - this.pos, CHAR_BUF_SIZE);
                int stop = this.pos + (utflen > (long)avail ? avail - 2 : (int)utflen);
                boolean outOfBounds = false;
                try {
                    block10: while (this.pos < stop) {
                        int b1 = this.buf[this.pos++] & 0xFF;
                        switch (b1 >> 4) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                this.cbuf[cpos++] = (char)b1;
                                continue block10;
                            }
                            case 12: 
                            case 13: {
                                byte b2 = this.buf[this.pos++];
                                if ((b2 & 0xC0) != 128) {
                                    throw new UTFDataFormatException();
                                }
                                this.cbuf[cpos++] = (char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0);
                                continue block10;
                            }
                            case 14: {
                                byte b3 = this.buf[this.pos + 1];
                                byte b2 = this.buf[this.pos + 0];
                                this.pos += 2;
                                if ((b2 & 0xC0) != 128) throw new UTFDataFormatException();
                                if ((b3 & 0xC0) != 128) {
                                    throw new UTFDataFormatException();
                                }
                                this.cbuf[cpos++] = (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0);
                                continue block10;
                            }
                        }
                        throw new UTFDataFormatException();
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    outOfBounds = true;
                    return (long)outOfBounds;
                }
                finally {
                    if (!outOfBounds && (long)(this.pos - start) <= utflen) break block13;
                    this.pos = start + (int)utflen;
                    throw new UTFDataFormatException();
                }
            }
            sbuf.append(this.cbuf, 0, cpos);
            return this.pos - start;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long readSimpleUTFSpan(ResetStringBuffer sbuf, long utflen) throws IOException {
            int start;
            int cpos;
            block6: {
                cpos = 0;
                start = this.pos;
                int avail = Math.min(this.end - this.pos, CHAR_BUF_SIZE);
                int stop = this.pos + (utflen > (long)avail ? avail : (int)utflen);
                boolean outOfBounds = false;
                try {
                    while (this.pos < stop) {
                        this.cbuf[cpos++] = (char)(this.buf[this.pos++] & 0xFF);
                    }
                }
                catch (ArrayIndexOutOfBoundsException ex) {
                    outOfBounds = true;
                    return (long)outOfBounds;
                }
                finally {
                    if (!outOfBounds && (long)(this.pos - start) <= utflen) break block6;
                    this.pos = start + (int)utflen;
                    throw new UTFDataFormatException();
                }
            }
            sbuf.append(this.cbuf, 0, cpos);
            return this.pos - start;
        }

        private int readUTFChar(ResetStringBuffer sbuf, long utflen) throws IOException {
            int b1 = this.readByte() & 0xFF;
            switch (b1 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    sbuf.append((char)b1);
                    return 1;
                }
                case 12: 
                case 13: {
                    if (utflen < 2L) {
                        throw new UTFDataFormatException();
                    }
                    byte b2 = this.readByte();
                    if ((b2 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0x1F) << 6 | (b2 & 0x3F) << 0));
                    return 2;
                }
                case 14: {
                    if (utflen < 3L) {
                        if (utflen == 2L) {
                            this.readByte();
                        }
                        throw new UTFDataFormatException();
                    }
                    byte b2 = this.readByte();
                    byte b3 = this.readByte();
                    if ((b2 & 0xC0) != 128 || (b3 & 0xC0) != 128) {
                        throw new UTFDataFormatException();
                    }
                    sbuf.append((char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | (b3 & 0x3F) << 0));
                    return 3;
                }
            }
            throw new UTFDataFormatException();
        }
    }

    public static class PeekInputStream
    extends InputStream {
        private final InputStream in;
        private int peekb = -1;

        public PeekInputStream(InputStream in) {
            this.in = in;
        }

        public int peek() throws IOException {
            return this.peekb >= 0 ? this.peekb : (this.peekb = this.in.read());
        }

        public int read() throws IOException {
            if (this.peekb >= 0) {
                int v = this.peekb;
                this.peekb = -1;
                return v;
            }
            return this.in.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n;
            if (len == 0) {
                return 0;
            }
            if (this.peekb < 0) {
                return this.in.read(b, off, len);
            }
            b[off++] = (byte)this.peekb;
            this.peekb = -1;
            return (n = this.in.read(b, off, --len)) >= 0 ? n + 1 : 1;
        }

        public void readFully(byte[] b, int off, int len) throws IOException {
            int count;
            for (int n = 0; n < len; n += count) {
                count = this.read(b, off + n, len - n);
                if (count >= 0) continue;
                throw new EOFException();
            }
        }

        public long skip(long n) throws IOException {
            if (n <= 0L) {
                return 0L;
            }
            int skipped = 0;
            if (this.peekb >= 0) {
                this.peekb = -1;
                ++skipped;
                --n;
            }
            return (long)skipped + this.skip(n);
        }

        public int available() throws IOException {
            return this.in.available() + (this.peekb >= 0 ? 1 : 0);
        }

        public void close() throws IOException {
            this.in.close();
        }
    }
}

