/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.objio;

import java.lang.reflect.Field;
import jeus.util.objio.ObjectStreamClass;

public class ObjectStreamField
implements Comparable {
    private final String name;
    private final String signature;
    private final Class typeClass;
    private char type;
    private final boolean unshared;
    private final Field field;
    private int offset = 0;

    public ObjectStreamField(String name, Class type) {
        this(name, type, false);
    }

    public ObjectStreamField(String name, Class type, boolean unshared) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.typeClass = type;
        this.unshared = unshared;
        this.signature = ObjectStreamClass.getClassSignature(type).intern();
        this.type = this.signature.charAt(0);
        this.field = null;
    }

    ObjectStreamField(String name, String signature, boolean unshared) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.name = name;
        this.signature = signature.intern();
        this.unshared = unshared;
        this.field = null;
        this.type = signature.charAt(0);
        switch (this.type) {
            case 'Z': {
                this.typeClass = Boolean.TYPE;
                break;
            }
            case 'B': {
                this.typeClass = Byte.TYPE;
                break;
            }
            case 'C': {
                this.typeClass = Character.TYPE;
                break;
            }
            case 'S': {
                this.typeClass = Short.TYPE;
                break;
            }
            case 'I': {
                this.typeClass = Integer.TYPE;
                break;
            }
            case 'J': {
                this.typeClass = Long.TYPE;
                break;
            }
            case 'F': {
                this.typeClass = Float.TYPE;
                break;
            }
            case 'D': {
                this.typeClass = Double.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.typeClass = Object.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal signature");
            }
        }
    }

    ObjectStreamField(Field field, boolean unshared, boolean showType) {
        this.field = field;
        this.unshared = unshared;
        this.name = field.getName();
        Class<?> ftype = field.getType();
        this.typeClass = showType || ftype.isPrimitive() ? ftype : Object.class;
        this.signature = ObjectStreamClass.getClassSignature(ftype).intern();
        this.type = this.signature.charAt(0);
    }

    public String getName() {
        return this.name;
    }

    public Class getTypeClass() {
        return this.typeClass;
    }

    public char getTypeCode() {
        return this.signature.charAt(0);
    }

    public String getTypeString() {
        return this.isPrimitive() ? null : this.signature;
    }

    public int getOffset() {
        return this.offset;
    }

    protected void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPrimitive() {
        char tcode = this.signature.charAt(0);
        return tcode != 'L' && tcode != '[';
    }

    public boolean isUnshared() {
        return this.unshared;
    }

    public int compareTo(Object obj) {
        ObjectStreamField other = (ObjectStreamField)obj;
        boolean isPrim = this.isPrimitive();
        if (isPrim != other.isPrimitive()) {
            return isPrim ? -1 : 1;
        }
        return this.name.compareTo(other.name);
    }

    public String toString() {
        return this.signature + ' ' + this.name;
    }

    Field getField() {
        return this.field;
    }

    String getSignature() {
        return this.signature;
    }
}

