/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.reflect;

import jeus.util.reflect.TypeSort;

public class TypeInfo {
    public static final TypeInfo BOOLEAN = new TypeInfo("boolean", TypeSort.BOOLEAN);
    public static final TypeInfo BYTE = new TypeInfo("byte", TypeSort.BYTE);
    public static final TypeInfo CHAR = new TypeInfo("char", TypeSort.CHAR);
    public static final TypeInfo DOUBLE = new TypeInfo("double", TypeSort.DOUBLE);
    public static final TypeInfo FLOAT = new TypeInfo("float", TypeSort.FLOAT);
    public static final TypeInfo INT = new TypeInfo("int", TypeSort.INT);
    public static final TypeInfo LONG = new TypeInfo("long", TypeSort.LONG);
    public static final TypeInfo SHORT = new TypeInfo("short", TypeSort.SHORT);
    public static final TypeInfo VOID = new TypeInfo("void", TypeSort.VOID);
    protected String name;
    protected TypeSort sort;

    protected TypeInfo(String className) {
        this(className, TypeInfo.determineTypeSort(className));
    }

    protected TypeInfo(String className, TypeSort sort) {
        if (!TypeInfo.isValidName(className)) {
            throw new IllegalArgumentException();
        }
        this.name = className;
        this.sort = sort;
    }

    public static boolean isValidName(String className) {
        return true;
    }

    public static TypeSort determineTypeSort(String className) {
        if (className.startsWith("[")) {
            return TypeSort.ARRAY;
        }
        if (className.equals("boolean")) {
            return TypeSort.BOOLEAN;
        }
        if (className.equals("byte")) {
            return TypeSort.BYTE;
        }
        if (className.equals("char")) {
            return TypeSort.CHAR;
        }
        if (className.equals("double")) {
            return TypeSort.DOUBLE;
        }
        if (className.equals("float")) {
            return TypeSort.FLOAT;
        }
        if (className.equals("int")) {
            return TypeSort.INT;
        }
        if (className.equals("long")) {
            return TypeSort.LONG;
        }
        if (className.equals("short")) {
            return TypeSort.SHORT;
        }
        if (className.equals("void")) {
            return TypeSort.VOID;
        }
        return TypeSort.OBJECT;
    }

    public static TypeInfo getType(Class c) {
        return TypeInfo.getType(c.getName());
    }

    public static TypeInfo getType(String className) throws IllegalArgumentException {
        if (!TypeInfo.isValidName(className)) {
            throw new IllegalArgumentException("Invalid class name");
        }
        TypeSort sort = TypeInfo.determineTypeSort(className);
        switch (sort) {
            case BOOLEAN: {
                return BOOLEAN;
            }
            case BYTE: {
                return BYTE;
            }
            case CHAR: {
                return CHAR;
            }
            case DOUBLE: {
                return DOUBLE;
            }
            case FLOAT: {
                return FLOAT;
            }
            case INT: {
                return INT;
            }
            case LONG: {
                return LONG;
            }
            case SHORT: {
                return SHORT;
            }
            case VOID: {
                return VOID;
            }
        }
        return new TypeInfo(className, sort);
    }

    public String getClassName() {
        return this.name;
    }

    public Class getClassObject() throws ClassNotFoundException {
        switch (this.sort) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case VOID: {
                return Void.TYPE;
            }
        }
        return Class.forName(this.name);
    }

    public Class getClassObject(ClassLoader cl) throws ClassNotFoundException {
        switch (this.sort) {
            case BOOLEAN: {
                return Boolean.TYPE;
            }
            case BYTE: {
                return Byte.TYPE;
            }
            case CHAR: {
                return Character.TYPE;
            }
            case DOUBLE: {
                return Double.TYPE;
            }
            case FLOAT: {
                return Float.TYPE;
            }
            case INT: {
                return Integer.TYPE;
            }
            case LONG: {
                return Long.TYPE;
            }
            case SHORT: {
                return Short.TYPE;
            }
            case VOID: {
                return Void.TYPE;
            }
        }
        return Class.forName(this.name, true, cl);
    }

    public boolean isBuiltinType() {
        return this.sort != TypeSort.ARRAY && this.sort != TypeSort.OBJECT;
    }

    public boolean isArray() {
        return this.sort == TypeSort.ARRAY;
    }

    public TypeInfo getComponentType() {
        return null;
    }

    public TypeSort getSort() {
        return this.sort;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeInfo)) {
            return false;
        }
        return this.name.equals(((TypeInfo)obj).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }
}

