/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.reflect.runtime;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import jeus.util.reflect.ClassInfo;
import jeus.util.reflect.ConstructorInfo;
import jeus.util.reflect.FieldInfo;
import jeus.util.reflect.MethodInfo;
import jeus.util.reflect.PackageInfo;
import jeus.util.reflect.TypeInfo;
import jeus.util.reflect.runtime.BasicInfoSupport;
import jeus.util.reflect.runtime.RuntimeConstructorInfo;
import jeus.util.reflect.runtime.RuntimeFieldInfo;
import jeus.util.reflect.runtime.RuntimeMethodInfo;
import jeus.util.reflect.runtime.RuntimePackageInfo;

public class RuntimeClassInfo
extends BasicInfoSupport
implements ClassInfo {
    protected Class cls;

    RuntimeClassInfo(Class clazz) {
        this.element = clazz;
        this.cls = clazz;
    }

    public String getName() {
        return this.cls.getName();
    }

    public TypeInfo getType() {
        return TypeInfo.getType(this.cls);
    }

    public PackageInfo getPackage() {
        Package pkg = this.cls.getPackage();
        if (pkg == null) {
            return null;
        }
        return new RuntimePackageInfo(pkg);
    }

    public int getModifiers() {
        return this.cls.getModifiers();
    }

    public boolean isInterface() {
        return this.cls.isInterface();
    }

    public FieldInfo[] getDeclaredFields() {
        Field[] fields = this.cls.getDeclaredFields();
        return this.getFieldInfoFromFieldArray(fields);
    }

    public FieldInfo getDeclaredField(String name) throws NoSuchFieldException {
        Field field = this.cls.getDeclaredField(name);
        return new RuntimeFieldInfo(field, this);
    }

    public FieldInfo[] getFields() {
        Field[] fields = this.cls.getFields();
        return this.getFieldInfoFromFieldArray(fields);
    }

    public FieldInfo getField(String name) throws NoSuchFieldException {
        Field field = this.cls.getField(name);
        return new RuntimeFieldInfo(field, this);
    }

    private FieldInfo[] getFieldInfoFromFieldArray(Field[] fields) {
        FieldInfo[] fieldInfos = new FieldInfo[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fieldInfos[i] = new RuntimeFieldInfo(fields[i], this);
        }
        return fieldInfos;
    }

    public ConstructorInfo[] getDeclaredConstructors() {
        Constructor[] cons = this.cls.getDeclaredConstructors();
        return this.getConstructorInfoFrom(cons);
    }

    public ConstructorInfo getDeclaredConstructor(TypeInfo ... parameterTypes) throws NoSuchMethodException {
        try {
            Class[] parameters = this.convertTypeInfoToClass(parameterTypes);
            Constructor con = this.cls.getDeclaredConstructor(parameters);
            return new RuntimeConstructorInfo(con, this);
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
    }

    private Class[] convertTypeInfoToClass(TypeInfo[] types) throws ClassNotFoundException {
        Class[] classes = new Class[types.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = types[i].getClassObject();
        }
        return classes;
    }

    private ConstructorInfo[] getConstructorInfoFrom(Constructor[] arr) {
        ConstructorInfo[] infos = new ConstructorInfo[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            infos[i] = new RuntimeConstructorInfo(arr[i], this);
        }
        return infos;
    }

    public MethodInfo[] getDeclaredMethods() {
        Method[] methods = this.cls.getDeclaredMethods();
        return this.getMethodInfoFrom(methods);
    }

    public MethodInfo getDeclaredMethod(String name, TypeInfo ... parameterTypes) throws NoSuchMethodException {
        try {
            Class[] parameters = this.convertTypeInfoToClass(parameterTypes);
            Method method = this.cls.getDeclaredMethod(name, parameters);
            return new RuntimeMethodInfo(method, this);
        }
        catch (Exception e) {
            throw new NoSuchMethodException();
        }
    }

    private MethodInfo[] getMethodInfoFrom(Method[] arr) {
        MethodInfo[] infos = new MethodInfo[arr.length];
        for (int i = 0; i < arr.length; ++i) {
            infos[i] = new RuntimeMethodInfo(arr[i], this);
        }
        return infos;
    }
}

