/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.reflect.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jeus.util.reflect.AnnotationInfo;
import jeus.util.reflect.EnumInfo;
import jeus.util.reflect.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationUtils {
    public static Annotation getAnnotation(AnnotationInfo a) {
        return null;
    }

    public static AnnotationInfo getAnnotationInfo(Annotation a) {
        Class<? extends Annotation> type = a.annotationType();
        TypeInfo typeInfo = TypeInfo.getType(type);
        HashMap<String, Object> elementValues = new HashMap<String, Object>();
        Method[] methods = type.getDeclaredMethods();
        try {
            for (Method m : methods) {
                String element = m.getName();
                Object value = m.invoke((Object)a, new Object[0]);
                Class<?> valueType = m.getReturnType();
                Object convertedValue = AnnotationUtils.convertAnnotationValue(valueType, value);
                elementValues.put(element, convertedValue);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Internal exception in getAnnotationInfo()", e);
        }
        return new AnnotationInfo(typeInfo, elementValues);
    }

    private static Object convertAnnotationValue(Class type, Object value) {
        Object[] result = value;
        if (!(type.equals(Byte.TYPE) || type.equals(Character.TYPE) || type.equals(Boolean.TYPE) || type.equals(Integer.TYPE) || type.equals(Short.TYPE) || type.equals(Long.TYPE) || type.equals(Float.TYPE) || type.equals(Double.TYPE) || type.equals(String.class))) {
            if (Enum.class.isAssignableFrom(type)) {
                result = new EnumInfo(TypeInfo.getType(type), ((Enum)value).name());
            } else if (Annotation.class.isAssignableFrom(type)) {
                result = AnnotationUtils.getAnnotationInfo((Annotation)value);
            } else if (type.equals(Class.class)) {
                result = TypeInfo.getType((Class)value);
            } else if (type.isArray()) {
                Class<?> compType = type.getComponentType();
                int length = Array.getLength(value);
                if (Enum.class.isAssignableFrom(compType)) {
                    EnumInfo[] enums = new EnumInfo[length];
                    for (int i = 0; i < length; ++i) {
                        Enum arrValue = (Enum)Array.get(value, i);
                        enums[i] = (EnumInfo)AnnotationUtils.convertAnnotationValue(compType, arrValue);
                    }
                    result = enums;
                } else if (Annotation.class.isAssignableFrom(compType)) {
                    AnnotationInfo[] anns = new AnnotationInfo[length];
                    for (int i = 0; i < length; ++i) {
                        Annotation arrValue = (Annotation)Array.get(value, i);
                        anns[i] = (AnnotationInfo)AnnotationUtils.convertAnnotationValue(compType, arrValue);
                    }
                    result = anns;
                } else if (compType.equals(Class.class)) {
                    TypeInfo[] types = new TypeInfo[length];
                    for (int i = 0; i < length; ++i) {
                        Class arrValue = (Class)Array.get(value, i);
                        types[i] = (TypeInfo)AnnotationUtils.convertAnnotationValue(compType, arrValue);
                    }
                    result = types;
                } else {
                    result = value;
                }
            } else {
                throw new RuntimeException("invalid type for annotation member");
            }
        }
        return result;
    }

    public static Map<String, Object> getElementValues(Annotation a) {
        Class<? extends Annotation> type = a.annotationType();
        TypeInfo typeInfo = TypeInfo.getType(type);
        HashMap<String, Object> elementValues = new HashMap<String, Object>();
        Method[] methods = type.getDeclaredMethods();
        try {
            for (Method m : methods) {
                String element = m.getName();
                Object value = m.invoke((Object)a, new Object[0]);
                elementValues.put(element, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not fetch annotation member", e);
        }
        return elementValues;
    }
}

