/*
 * Decompiled with CFR 0.152.
 */
package jeus.util.sysmon;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.logging.Level;
import jeus.util.sysmon.CPUMonitor;
import jeus.util.sysmon.CPUStat;
import jeus.util.sysmon.CPUStats;

public class WindowsCPUMonitor
extends CPUMonitor {
    private static int CPU_STAT;
    private static int CPU_STAT_DEF_BUFSIZE;
    private static boolean LOAD_LIBRARY;
    private static String LIBRARY_NAME;

    protected CPUStats getCurrentCPUStats() {
        byte[] ret;
        byte[] byArray = ret = LOAD_LIBRARY ? WindowsCPUMonitor.getPerf(CPU_STAT, CPU_STAT_DEF_BUFSIZE, null) : null;
        if (ret == null) {
            throw new RuntimeException("Could not read statistics from the native function");
        }
        CPUStat[] stats = new CPUStat[numProcessors];
        CPUStat totalStat = null;
        long t_user = 0L;
        long t_sys = 0L;
        long t_idle = 0L;
        long t_wait = 0L;
        FilterInputStream dataInputStream = null;
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(ret);
            dataInputStream = new DataInputStream(byteArrayInputStream);
            int cnt = ((DataInputStream)dataInputStream).readInt();
            if (cnt != numProcessors) {
                throw new RuntimeException("inconsistent CPU's count");
            }
            for (int i = 0; i < cnt; ++i) {
                CPUStat stat;
                int cpuId = ((DataInputStream)dataInputStream).readInt();
                long user = ((DataInputStream)dataInputStream).readLong();
                long system = ((DataInputStream)dataInputStream).readLong();
                long idle = ((DataInputStream)dataInputStream).readLong();
                long wait = ((DataInputStream)dataInputStream).readLong();
                t_user += user;
                t_sys += system;
                t_idle += idle;
                t_wait += wait;
                stats[i] = stat = new CPUStat(String.valueOf(cpuId), user, system, wait, idle);
            }
            totalStat = new CPUStat("cpu", t_user, t_sys, t_wait, t_idle);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not read bytes statistic", e);
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    byteArrayInputStream.close();
                    byteArrayInputStream = null;
                }
                catch (IOException e) {}
            }
            if (dataInputStream != null) {
                try {
                    dataInputStream.close();
                    dataInputStream = null;
                }
                catch (IOException e) {}
            }
        }
        return new CPUStats(totalStat, stats);
    }

    protected void doStart() {
        if (!LOAD_LIBRARY) {
            throw new IllegalStateException("failed to start WindowsCPUMonitor because of loading " + LIBRARY_NAME + " library error");
        }
        WindowsCPUMonitor.initPerf();
    }

    protected void doStop() {
        if (!LOAD_LIBRARY) {
            return;
        }
        WindowsCPUMonitor.releasePerf();
    }

    private static native byte[] getPerf(int var0, int var1, byte[] var2);

    private static native int initPerf();

    private static native int releasePerf();

    static {
        block4: {
            CPU_STAT = 1;
            CPU_STAT_DEF_BUFSIZE = 4612;
            LOAD_LIBRARY = false;
            LIBRARY_NAME = "cpumon";
            if (!LOAD_LIBRARY) {
                try {
                    System.loadLibrary(LIBRARY_NAME);
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINEST, "[WindowsCPUMonitor] " + LIBRARY_NAME + " library loaded");
                    }
                    LOAD_LIBRARY = true;
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.FINEST, "[WindowsCPUMonitor] " + LIBRARY_NAME + " library loading error", t);
                }
            }
        }
    }
}

