/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.helpers.DefaultValidationEventHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import jeus.deploy.archivist.AbstractArchive;
import jeus.deploy.io.WebDeploymentDescriptorFile;
import jeus.service.descriptor.DescriptorFile;
import jeus.servlet.property.WebProperties;
import jeus.util.message.JeusMessage_Manager;
import jeus.xml.binding.DescriptorBinder;
import jeus.xml.binding.JeusJAXBException;
import jeus.xml.binding.util.JAXBContextFactory;
import jeus.xml.util.ElementException;
import jeus.xml.util.XMLSurgeon;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BindingHelper
extends DefaultValidationEventHandler {
    private static BindingHelper validator = new BindingHelper();
    private boolean isValidationError;
    private String validationErrorMessage;

    public static BindingHelper getValidationHandler() {
        return new BindingHelper();
    }

    public boolean isValidationError() {
        return this.isValidationError;
    }

    public String getValidationErrorMessage() {
        return this.validationErrorMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getDescriptor(AbstractArchive jarArchive, DescriptorFile file, ClassLoader loader, DefaultValidationEventHandler _validator) throws IOException, FileNotFoundException, JeusJAXBException {
        InputStream is = null;
        try {
            is = file.getDescriptorStream(jarArchive);
            if (is == null) {
                throw new FileNotFoundException("The file " + jarArchive.getArchiveUri() + File.separator + file.getDeploymentDescriptorPath() + " is NOT found");
            }
            Object object = BindingHelper.getDescriptor(is, file, loader, _validator);
            return object;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptorBinder getDescriptorWithBinder(AbstractArchive jarArchive, DescriptorFile file, ClassLoader loader, DefaultValidationEventHandler _validator) throws IOException, FileNotFoundException, JeusJAXBException {
        InputStream is = null;
        try {
            is = file.getDescriptorStream(jarArchive);
            if (is == null) {
                throw new FileNotFoundException("The file " + jarArchive.getArchiveUri() + File.separator + file.getDeploymentDescriptorPath() + " is NOT found");
            }
            DescriptorBinder descriptorBinder = BindingHelper.getDescriptorWithBinder(is, file, loader, _validator);
            return descriptorBinder;
        }
        finally {
            if (is != null) {
                is.close();
                is = null;
            }
        }
    }

    public static Object getDescriptor(InputStream is, DescriptorFile file, ClassLoader loader, DefaultValidationEventHandler _validator) throws IOException, JeusJAXBException {
        try {
            String servletVersion;
            is = new BufferedInputStream(is);
            is = file.getSchemaBasedStream(is);
            String contextPackageName = file.getContextPackageName();
            Schema schema = null;
            if (file.shouldValidateWithSchema()) {
                schema = file.getSchema();
            }
            if (file instanceof WebDeploymentDescriptorFile && !(servletVersion = ((WebDeploymentDescriptorFile)file).getServletVersion()).equals("2.3") && WebProperties.J2EE_COMPATIBLE.value) {
                Object obj = BindingHelper.getUnmarshalledObject(loader, contextPackageName, _validator, schema, is, true, false);
                return obj;
            }
            Object obj = BindingHelper.getUnmarshalledObject(loader, contextPackageName, _validator, schema, is);
            return obj;
        }
        catch (Exception e) {
            throw new JeusJAXBException(e);
        }
    }

    public static DescriptorBinder getDescriptorWithBinder(InputStream is, DescriptorFile file, ClassLoader loader, DefaultValidationEventHandler _validator) throws IOException, JeusJAXBException {
        try {
            is = new BufferedInputStream(is);
            is = file.getSchemaBasedStream(is);
            String contextPackageName = file.getContextPackageName();
            Schema schema = null;
            if (file.shouldValidateWithSchema()) {
                schema = file.getSchema();
            }
            return BindingHelper.getUnmarshalledObjectWithBinder(loader, contextPackageName, _validator, schema, is);
        }
        catch (Exception e) {
            throw new JeusJAXBException(e);
        }
    }

    private static Object getUnmarshalledObject(ClassLoader loader, String contextPackageName, DefaultValidationEventHandler _validator, Schema schema, InputStream is) throws JAXBException, IOException, SAXException, ElementException {
        JAXBContext jcJar = BindingHelper.getContext(loader, contextPackageName);
        Unmarshaller u = jcJar.createUnmarshaller();
        if (schema != null) {
            u.setSchema(schema);
        }
        if (_validator != null) {
            u.setEventHandler((ValidationEventHandler)_validator);
        }
        return XMLSurgeon.operate(u, is);
    }

    private static Object getUnmarshalledObject(ClassLoader loader, String contextPackageName, DefaultValidationEventHandler _validator, Schema schema, InputStream is, boolean keepComments, boolean elementReorder) throws JAXBException, IOException, SAXException, ElementException {
        JAXBContext jcJar = BindingHelper.getContext(loader, contextPackageName);
        Unmarshaller u = jcJar.createUnmarshaller();
        if (schema != null) {
            u.setSchema(schema);
        }
        if (_validator != null) {
            u.setEventHandler((ValidationEventHandler)_validator);
        }
        return XMLSurgeon.operate(u, is, keepComments, elementReorder);
    }

    private static DescriptorBinder getUnmarshalledObjectWithBinder(ClassLoader loader, String contextPackageName, DefaultValidationEventHandler _validator, Schema schema, InputStream is) throws JAXBException, IOException, SAXException, ElementException {
        JAXBContext jcJar = BindingHelper.getContext(loader, contextPackageName);
        Binder b = jcJar.createBinder();
        if (schema != null) {
            b.setSchema(schema);
        }
        if (_validator != null) {
            b.setEventHandler((ValidationEventHandler)_validator);
        }
        return XMLSurgeon.operate(b, is);
    }

    public static Object getDescriptor(ClassLoader loader, String contextPackageName, Document node) throws JAXBException, ElementException {
        JAXBContext jcJar = BindingHelper.getContext(loader, contextPackageName);
        Unmarshaller u = jcJar.createUnmarshaller();
        return XMLSurgeon.operate(u, node, false, true);
    }

    public static Object getDescriptor(AbstractArchive jarArchive, DescriptorFile file, ClassLoader loader) throws IOException, FileNotFoundException, JeusJAXBException {
        return BindingHelper.getDescriptor(jarArchive, file, loader, (DefaultValidationEventHandler)validator);
    }

    public static DescriptorBinder getDescriptorWithBinder(AbstractArchive jarArchive, DescriptorFile file, ClassLoader loader) throws IOException, FileNotFoundException, JeusJAXBException {
        return BindingHelper.getDescriptorWithBinder(jarArchive, file, loader, (DefaultValidationEventHandler)validator);
    }

    public static Object getDescriptor(InputStream is, DescriptorFile file, ClassLoader loader) throws JeusJAXBException {
        try {
            return BindingHelper.getDescriptor(is, file, loader, (DefaultValidationEventHandler)validator);
        }
        catch (JeusJAXBException ex) {
            throw ex;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new JeusJAXBException(JeusMessage_Manager.MGR_58, e);
        }
    }

    public static DescriptorBinder getDescriptorWithBinder(InputStream is, DescriptorFile file, ClassLoader loader) throws JeusJAXBException {
        try {
            return BindingHelper.getDescriptorWithBinder(is, file, loader, (DefaultValidationEventHandler)validator);
        }
        catch (JeusJAXBException ex) {
            throw ex;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new JeusJAXBException(JeusMessage_Manager.MGR_58, e);
        }
    }

    public static Binder getBinder(ClassLoader loader, String contextPackageName) throws JAXBException {
        return BindingHelper.getContext(loader, contextPackageName).createBinder();
    }

    public static Binder getBinder(DescriptorFile file, ClassLoader loader) throws JAXBException {
        return BindingHelper.getBinder(loader, file.getContextPackageName());
    }

    private static JAXBContext getContext(ClassLoader loader, String contextPackageName) throws JAXBException {
        if (loader == null) {
            return JAXBContextFactory.getContext(contextPackageName);
        }
        return JAXBContextFactory.getContext(contextPackageName, loader);
    }

    public boolean handleEvent(ValidationEvent event) {
        this.isValidationError = true;
        this.validationErrorMessage = event.getMessage();
        return super.handleEvent(event);
    }

    public static <T> List<T> getSubList(List<JAXBElement<?>> _groupList, Class<T> _targetClass) {
        ArrayList<Object> _subList = new ArrayList<Object>();
        if (_groupList == null || _targetClass == null) {
            return _subList;
        }
        for (JAXBElement<?> element : _groupList) {
            Object o = element.getValue();
            if (!_targetClass.isInstance(o)) continue;
            _subList.add(o);
        }
        return _subList;
    }

    public static Object getSubFirstElement(List _groupList, Class _targetClass) {
        if (_groupList == null || _targetClass == null) {
            return null;
        }
        for (int i = 0; i < _groupList.size(); ++i) {
            JAXBElement jaxbElement;
            Object value;
            Object o = _groupList.get(i);
            if (_targetClass.isInstance(o)) {
                return o;
            }
            if (!(o instanceof JAXBElement) || !_targetClass.isInstance(value = (jaxbElement = (JAXBElement)o).getValue())) continue;
            return value;
        }
        return null;
    }

    public static String marshalDescriptor(Object ejbDD, String contextPackageName) throws JeusJAXBException {
        try {
            JAXBContext jc = JAXBContextFactory.getContext(contextPackageName);
            Marshaller m = jc.createMarshaller();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            XMLSurgeon.leave(ejbDD, m, os, true);
            os.close();
            return new String(os.toByteArray());
        }
        catch (Throwable e) {
            throw new JeusJAXBException(JeusMessage_Manager.MGR_59, e);
        }
    }

    public static Document getDocument(InputStream is) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        builder = factory.newDocumentBuilder();
        Document document = null;
        try {
            document = builder.parse(is);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (SAXException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return document;
    }
}

