/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import jeus.xml.util.DomProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NamespaceConverter {
    private static XMLEventFactory factory = XMLEventFactory.newInstance();

    public static Document convertJ2EE14Document(Document doc) {
        boolean modified = false;
        Element root = doc.getDocumentElement();
        String xmlns = root.getAttribute("xmlns");
        if (xmlns.equals("http://java.sun.com/xml/ns/j2ee")) {
            root.setAttribute("xmlns", "http://java.sun.com/xml/ns/javaee");
            modified = true;
        }
        if (modified) {
            doc = DomProcessor.refreshDocument(doc);
        }
        return doc;
    }

    public static Document restoreOriginalNamespace(Document doc, String originalNS) {
        if (originalNS != null && !originalNS.equals("")) {
            Element root = doc.getDocumentElement();
            root.setAttribute("xmlns", originalNS);
        }
        return doc;
    }

    public static String getNamespace(Document doc) {
        Element root = doc.getDocumentElement();
        return root.getAttribute("xmlns");
    }

    public static String convertJaveEe4Document(InputStream source, ByteArrayOutputStream target) {
        String originalTargetNamespace = null;
        ByteArrayOutputStream out = new ByteArrayOutputStream(10240);
        NamespaceConverter.copyStream(source, out);
        source = new ByteArrayInputStream(out.toByteArray());
        try {
            originalTargetNamespace = NamespaceConverter.replaceNamespace(source, target, "http://java.sun.com/xml/ns/j2ee", "http://java.sun.com/xml/ns/javaee");
        }
        catch (Exception ex) {
            target.reset();
            source = new ByteArrayInputStream(out.toByteArray());
            NamespaceConverter.copyStream(source, target);
        }
        return originalTargetNamespace;
    }

    private static void copyStream(InputStream source, OutputStream target) {
        byte[] buf = new byte[4096];
        try {
            int len;
            while ((len = source.read(buf)) != -1) {
                target.write(buf, 0, len);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static String replaceNamespace(InputStream in, OutputStream out, String sourceNamespaceUri, String targetNamespaceUri) throws XMLStreamException, FactoryConfigurationError {
        XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(in);
        XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(out);
        String rootElementNamespaceUri = null;
        while (reader.hasNext()) {
            XMLEvent event = (XMLEvent)reader.next();
            if (rootElementNamespaceUri == null && event.isStartElement()) {
                rootElementNamespaceUri = event.asStartElement().getName().getNamespaceURI();
            }
            writer.add(NamespaceConverter.replaceNamespace(event, sourceNamespaceUri, targetNamespaceUri));
        }
        writer.flush();
        return rootElementNamespaceUri;
    }

    public static XMLEvent replaceNamespace(XMLEvent event, String sourceNamespaceUri, String targetNamespaceUri) {
        if (event.getEventType() == 1) {
            StartElement element = event.asStartElement();
            QName name = element.getName();
            Iterator<Attribute> attributes = element.getAttributes();
            ArrayList<Namespace> newNamespaces = new ArrayList<Namespace>();
            Iterator<Namespace> namespaces = element.getNamespaces();
            while (namespaces.hasNext()) {
                Namespace namespace = namespaces.next();
                if (namespace.getNamespaceURI().equals(sourceNamespaceUri)) {
                    Namespace newNamespace = factory.createNamespace(namespace.getPrefix(), targetNamespaceUri);
                    newNamespaces.add(newNamespace);
                    if (!name.getNamespaceURI().equals(sourceNamespaceUri)) continue;
                    name = new QName(targetNamespaceUri, name.getLocalPart(), name.getPrefix());
                    continue;
                }
                newNamespaces.add(namespace);
            }
            element = factory.createStartElement(name, attributes, newNamespaces.iterator());
            return element;
        }
        return event;
    }
}

