/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.ejbHelper;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import jeus.descriptor.ejb.TransactionInfo;
import jeus.ejb.compiler.BeanInfo;
import jeus.ejb.compiler.EJBSourceGeneratorException;
import jeus.ejb.metadata.EntityBeanInfo;
import jeus.ejb.util.MethodConvertor;
import jeus.management.j2ee.EJBModule;
import jeus.util.StringUtil;
import jeus.util.properties.JeusEJBProperties;
import jeus.xml.binding.ObjectFactoryHelper;
import jeus.xml.binding.ejbHelper.BMEntityBeanPair;
import jeus.xml.binding.ejbHelper.CMEntityBeanPair;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;
import jeus.xml.binding.ejbHelper.FindMethodPair;
import jeus.xml.binding.ejbHelper.MessageDrivenBeanPair;
import jeus.xml.binding.ejbHelper.ModulePair;
import jeus.xml.binding.ejbHelper.StatefulSessionBeanPair;
import jeus.xml.binding.ejbHelper.StatelessSessionBeanPair;
import jeus.xml.binding.j2ee.EjbLocalRefType;
import jeus.xml.binding.j2ee.EjbRefType;
import jeus.xml.binding.j2ee.EntityBeanType;
import jeus.xml.binding.j2ee.MessageDestinationRefType;
import jeus.xml.binding.j2ee.MessageDrivenBeanType;
import jeus.xml.binding.j2ee.ResourceEnvRefType;
import jeus.xml.binding.j2ee.ResourceRefType;
import jeus.xml.binding.j2ee.ServiceRefType;
import jeus.xml.binding.j2ee.SessionBeanType;
import jeus.xml.binding.jeusDD.ClusteringType;
import jeus.xml.binding.jeusDD.DurableTimerServiceType;
import jeus.xml.binding.jeusDD.ExportIiopType;
import jeus.xml.binding.jeusDD.InvokeHttpType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JeusWebservicesClientDdType;
import jeus.xml.binding.jeusDD.JndiInfoType;
import jeus.xml.binding.jeusDD.JndiRefType;
import jeus.xml.binding.jeusDD.MethodParamType;
import jeus.xml.binding.jeusDD.MethodParamsType;
import jeus.xml.binding.jeusDD.ObjectFactory;
import jeus.xml.binding.jeusDD.ObjectManagementType;
import jeus.xml.binding.jeusDD.RunAsIdentityType;
import jeus.xml.binding.jeusDD.SecurityInteropType;
import jeus.xml.binding.jeusDD.ServiceClientType;
import jeus.xml.binding.webservicesHelper.WebservicesPair;

public abstract class BeanPair {
    protected String ejbName;
    protected EntityBeanType jarBean;
    protected JeusBeanType jeusBean;
    SessionBeanType sessionBean;
    MessageDrivenBeanType messageDrivenBean;
    protected String home;
    protected String localHome;
    protected String remote;
    protected String local;
    protected String ejbClassName;
    protected String moduleName;
    private String homeImplClassName;
    private String objectImplClassName;
    private String localHomeImplClassName;
    private String localObjectImplClassName;
    protected ObjectManagementType objectManagementType;
    private ModulePair modulePair;
    private String appName;
    protected List serviceRefPairs;
    private int unspecifiedTransactionType;
    public static final String NOT_SUPPORTED = "NotSupported";
    public static final String SUPPORTS = "Supports";
    public static final String REQUIRES = "Requires";
    private String iiopEjbHomeImplClassName;
    private String iiopEjbObjectImplClassName;
    private EntityBeanInfo beanInfo;
    private int unspecifiedTxAttr;

    public BeanPair(ModulePair modulePair, JeusBeanType jeusBean) {
        this.modulePair = modulePair;
        this.jeusBean = jeusBean;
        this.moduleName = modulePair.getModuleName();
        this.objectManagementType = jeusBean.getObjectManagement();
    }

    public static BeanPair createBeanPair(String ejbName, EntityBeanType entityBean, JeusBeanType jeusBean, ModulePair modulePair) throws JAXBException, EJBDescriptorValidationException {
        if (jeusBean.getSchemaInfo() != null) {
            return new CMEntityBeanPair(ejbName, entityBean, jeusBean, modulePair);
        }
        return new BMEntityBeanPair(ejbName, entityBean, jeusBean, modulePair);
    }

    public static BeanPair createBeanPair(String ejbName, SessionBeanType entityBean, JeusBeanType jeusBean, ModulePair modulePair) throws JAXBException {
        if (entityBean.getSessionType().getValue().equals("Stateful")) {
            return new StatefulSessionBeanPair(ejbName, entityBean, jeusBean, modulePair);
        }
        return new StatelessSessionBeanPair(ejbName, entityBean, jeusBean, modulePair);
    }

    public static BeanPair createBeanPair(String ejbName, MessageDrivenBeanType entityBean, JeusBeanType jeusBean, ModulePair modulePair) throws JAXBException, EJBDescriptorValidationException {
        return new MessageDrivenBeanPair(ejbName, entityBean, jeusBean, modulePair);
    }

    public abstract boolean isEntityBean();

    public abstract boolean isConManagedEntityBean();

    public abstract boolean isAutoKeyGenerator();

    public String getBeanPackageName() {
        return this.ejbClassName.substring(0, this.ejbClassName.lastIndexOf(46));
    }

    public String getBeanClassName() {
        return this.ejbClassName.substring(this.ejbClassName.lastIndexOf(46) + 1);
    }

    public String getFullEJBBeanClassName() {
        return this.ejbClassName;
    }

    public String getBeanName() {
        return this.ejbName;
    }

    public String getEJBLocalHomeClassName() {
        return this.localHome;
    }

    public void setEJBLocalHomeClassName(String defaultlocalhomeclassname) {
        this.localHome = defaultlocalhomeclassname;
    }

    public void setEJBLocalObjectClassName(String defaultlocalobjectclassname) {
        this.local = defaultlocalobjectclassname;
    }

    public boolean isInvocationWithHttp() {
        return this.jeusBean.getInvokeHttp() != null;
    }

    public void setInvocationWithHttp(String httpURL, int httpPort) throws JAXBException {
        ObjectFactory objectFactory = ObjectFactoryHelper.getJeusDDObjectFactory();
        InvokeHttpType invokeHttpType = objectFactory.createInvokeHttpType();
        invokeHttpType.setUrl(httpURL);
        invokeHttpType.setHttpPort(Integer.valueOf(httpPort));
        this.jeusBean.setInvokeHttp(invokeHttpType);
    }

    public String getEJBHomeClassName() {
        return this.home;
    }

    public String getEJBLocalObjectClassName() {
        return this.local;
    }

    public String getEJBObjectClassName() {
        return this.remote;
    }

    public void setEJBHomeImplClassName(String fullImplClassNameAtFastDeploy) {
        this.homeImplClassName = fullImplClassNameAtFastDeploy;
    }

    public void setEJBObjectImplClassName(String fullImplClassNameAtFastDeploy) {
        this.objectImplClassName = fullImplClassNameAtFastDeploy;
    }

    public void setEJBLocalHomeImplClassName(String localFullImplClassNameAtFastDeploy) {
        this.localHomeImplClassName = localFullImplClassNameAtFastDeploy;
    }

    public void setEJBLocalObjectImplClassName(String localFullImplClassNameAtFastDeploy) {
        this.localObjectImplClassName = localFullImplClassNameAtFastDeploy;
    }

    public boolean getExportIIOP() {
        return this.jeusBean.getExportIiop() != null;
    }

    public ExportIiopType getExportIiopType() {
        return this.jeusBean.getExportIiop();
    }

    public ClusteringType getClusterDesc() {
        return this.jeusBean.getClustering();
    }

    public static boolean matchMethod(FindMethodPair methodPair, Method m) {
        String methodName = methodPair.getMethodName();
        ArrayList paramList = methodPair.getMethodParams();
        if (!methodName.equals(m.getName())) {
            return false;
        }
        Class<?>[] paramClasses = m.getParameterTypes();
        if (paramClasses.length != paramList.size()) {
            return false;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            String paramValueType = (String)paramList.get(i);
            if (paramValueType.equals(MethodConvertor.translateToParamType(paramClasses[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchMethod(MethodParamType methodParamType, Method m) {
        MethodParamsType methodParamsType;
        List paramList;
        String methodName = methodParamType.getMethodName();
        if (methodName.equals("*")) {
            return true;
        }
        if (!methodName.equals(m.getName())) {
            return false;
        }
        Class<?>[] paramClasses = m.getParameterTypes();
        if (paramClasses.length != (paramList = (methodParamsType = methodParamType.getMethodParams()) != null ? methodParamsType.getMethodParam() : Collections.EMPTY_LIST).size()) {
            return false;
        }
        for (int i = 0; i < paramList.size(); ++i) {
            String paramValueType = (String)paramList.get(i);
            if (paramValueType.equals("*")) {
                return true;
            }
            if (paramValueType.equals(MethodConvertor.translateToParamType(paramClasses[i]))) continue;
            return false;
        }
        return true;
    }

    public static boolean matchMethodInList(ClusteringType clusterType, boolean isHome, Method method) {
        MethodParamType methodParamType;
        int i;
        List idempotentList;
        List excludeList;
        if (isHome) {
            excludeList = clusterType.getEjbHomeIdempotentExcludeMethod();
            idempotentList = clusterType.getEjbHomeIdempotentMethod();
        } else {
            excludeList = clusterType.getEjbRemoteIdempotentExcludeMethod();
            idempotentList = clusterType.getEjbRemoteIdempotentMethod();
        }
        for (i = 0; i < excludeList.size(); ++i) {
            methodParamType = (MethodParamType)excludeList.get(i);
            if (!BeanPair.matchMethod(methodParamType, method)) continue;
            return false;
        }
        for (i = 0; i < idempotentList.size(); ++i) {
            methodParamType = (MethodParamType)idempotentList.get(i);
            if (!BeanPair.matchMethod(methodParamType, method)) continue;
            return true;
        }
        return false;
    }

    public SecurityInteropType getEJBCSIDescriptor() {
        return this.jeusBean.getSecurityInterop();
    }

    public String getEJBObjectImplClassName() {
        return this.objectImplClassName;
    }

    public String getEJBHomeImplClassName() {
        return this.homeImplClassName;
    }

    public int getExportPort() {
        if (this.jeusBean.getExportPort() > 0) {
            return this.jeusBean.getExportPort();
        }
        if (this.isInvocationWithHttp()) {
            return 0;
        }
        if (this.useJeusRmi()) {
            return JeusEJBProperties.EJB_DEFAULT_EXPORT_PORT_FOR_JEUSRMI;
        }
        return JeusEJBProperties.EJB_DEFAULT_EXPORT_PORT;
    }

    public String getExportName() {
        if (this.existsRemoteInterface()) {
            return this.jeusBean.getExportName();
        }
        return null;
    }

    private boolean existsRemoteInterface() {
        return this.home != null;
    }

    public boolean isLocalInvocationOptimized() {
        return this.jeusBean.isLocalInvokeOptimize();
    }

    public String getLocalExportName() {
        return this.jeusBean.getLocalExportName();
    }

    public String getEJBLocalObjectImplClassName() {
        return this.localObjectImplClassName;
    }

    public String getEJBLocalHomeImplClassName() {
        return this.localHomeImplClassName;
    }

    public Long getPassivationTimeout() {
        return this.objectManagementType.getPassivationTimeout();
    }

    public boolean isSetPassivationTimeout() {
        return this.objectManagementType.isSetPassivationTimeout();
    }

    public boolean isSingleVMOnly() {
        return this.jeusBean.isSingleVmOnly();
    }

    public Long getDisconnectTimeout() {
        return this.objectManagementType.getDisconnectTimeout();
    }

    public boolean isSetDisconnectTimeout() {
        return this.objectManagementType.isSetDisconnectTimeout();
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getHttpURL() {
        return this.jeusBean.getInvokeHttp().getUrl();
    }

    public int getHttpPort() {
        return this.jeusBean.getInvokeHttp().getHttpPort();
    }

    public int getThreadPoolMax() {
        return this.jeusBean.getThreadMax();
    }

    public String getRunAsName() {
        RunAsIdentityType type = this.jeusBean.getRunAsIdentity();
        if (type != null) {
            return type.getPrincipalName();
        }
        return null;
    }

    public abstract List getRoleLinkList();

    public abstract List getEnvs();

    public abstract List getEJBRefs();

    public abstract List getEJBLocalRefs();

    public abstract List getResourceRefs();

    public abstract List getResourceEnvRefs();

    public abstract List getServiceRefs();

    public String getJndiName(EjbRefType ejbRefType) throws EJBDescriptorValidationException {
        String beanInterface;
        String ejbLink;
        String exportName = this.getExportNameFromRefName(ejbRefType.getEjbRefName().getValue());
        if (StringUtil.isNullOrEmpty((String)exportName) && StringUtil.isNullOrEmpty((String)(exportName = this.getJndiNameFromLink(ejbLink = ejbRefType.getEjbLink().getValue(), beanInterface = ejbRefType.getHome().getValue())))) {
            throw new EJBDescriptorValidationException("There is no corresponding jndi-info in the jeus-ejb-dd.xml : " + ejbRefType.getEjbRefName().getValue());
        }
        return exportName;
    }

    public String getJndiName(EjbLocalRefType ejbRefType) throws EJBDescriptorValidationException {
        String beanInterface;
        String ejbLink;
        String refName = ejbRefType.getEjbRefName().getValue();
        String exportName = this.getExportNameFromRefName(refName);
        if (StringUtil.isNullOrEmpty((String)exportName) && StringUtil.isNullOrEmpty((String)(exportName = this.getJndiNameFromLink(ejbLink = ejbRefType.getEjbLink().getValue(), beanInterface = ejbRefType.getLocalHome().getValue()))) && StringUtil.isNullOrEmpty((String)(exportName = this.beanInfo.getLocalExportName(ejbRefType)))) {
            throw new EJBDescriptorValidationException("There is no ejb referenced by the ejb reference");
        }
        return exportName;
    }

    private String getJndiNameFromLink(String ejbLink, String beanInterface) {
        EJBModule module = this.beanInfo.getModuleInfo().getModule();
        if (!StringUtil.isNullOrEmpty((String)ejbLink)) {
            String jndiName = module.getEJBJndiName(ejbLink, beanInterface, null);
            if (jndiName == null) {
                jndiName = module.getEJBJndiName(ejbLink, beanInterface, null);
            }
            if (jndiName != null) {
                return jndiName;
            }
        }
        return null;
    }

    private String getExportNameFromRefName(String refName) {
        JndiRefType jndiRef = this.jeusBean.getEjbRef();
        if (jndiRef != null) {
            List jndiInfoList = jndiRef.getJndiInfo();
            for (int i = 0; i < jndiInfoList.size(); ++i) {
                String exportName;
                JndiInfoType jndiInfoType = (JndiInfoType)jndiInfoList.get(i);
                if (!refName.equals(jndiInfoType.getRefName()) || (exportName = jndiInfoType.getExportName()) == null || exportName.equals("")) continue;
                return exportName;
            }
        }
        return null;
    }

    public String getJndiName(ResourceRefType resRef) throws EJBDescriptorValidationException {
        List jndiInfoList = this.jeusBean.getResRef().getJndiInfo();
        String resRefName = resRef.getResRefName().getValue();
        return this.matchForJndiName(jndiInfoList, resRefName);
    }

    private String matchForJndiName(List jndiInfoList, String resRefName) throws EJBDescriptorValidationException {
        for (int i = 0; i < jndiInfoList.size(); ++i) {
            JndiInfoType jndiInfoType = (JndiInfoType)jndiInfoList.get(i);
            if (!jndiInfoType.getRefName().equals(resRefName)) continue;
            return jndiInfoType.getExportName();
        }
        throw new EJBDescriptorValidationException("No such ref name : " + resRefName);
    }

    public String getJndiName(ResourceEnvRefType resRef) throws EJBDescriptorValidationException {
        List jndiInfoList = this.jeusBean.getResEnvRef().getJndiInfo();
        String resRefName = resRef.getResourceEnvRefName().getValue();
        return this.matchForJndiName(jndiInfoList, resRefName);
    }

    public String getJndiName(MessageDestinationRefType resRef) throws EJBDescriptorValidationException {
        String resRefName = resRef.getMessageDestinationRefName().getValue();
        return this.modulePair.getMessageDestinationJndiName(resRefName);
    }

    public ServiceClientType getWebservicesClientDD(ServiceRefType serviceRef) throws EJBDescriptorValidationException {
        String refName = serviceRef.getServiceRefName().getValue();
        JeusWebservicesClientDdType wsclientDD = this.jeusBean.getServiceRef();
        if (wsclientDD != null) {
            List list = wsclientDD.getServiceClient();
            for (int i = 0; i < list.size(); ++i) {
                ServiceClientType serviceClient = (ServiceClientType)list.get(i);
                if (!refName.equals(serviceClient.getServiceRefName())) continue;
                return serviceClient;
            }
        }
        return null;
    }

    public int getCapacity() {
        return this.objectManagementType.getCapacity();
    }

    public int getEJBBeanPoolSize() {
        return this.objectManagementType.getBeanPool().getPoolMin();
    }

    public int getEJBBeanPoolMax() {
        return this.objectManagementType.getBeanPool().getPoolMax();
    }

    public int getConnectPoolSize() {
        return this.objectManagementType.getConnectPool().getPoolMin();
    }

    public int getConnectPoolMax() {
        return this.objectManagementType.getConnectPool().getPoolMax();
    }

    public long getConnectPoolResizingPeriod() {
        return this.objectManagementType.getConnectPool().getResizingPeriod();
    }

    public abstract List getMessageDestinationRefs();

    public boolean isUseAccessControl() {
        return this.jeusBean.isUseAccessControl();
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppName() {
        return this.appName;
    }

    public String getSecurityPolicyID() {
        return this.modulePair.getModuleName();
    }

    public DurableTimerServiceType getDurableTimerSetting() {
        return this.jeusBean.getDurableTimerService();
    }

    public String getUnspecifiedTransactionType() {
        return this.modulePair.getUnspecifiedTransactionType();
    }

    public int getUnspecifiedTransactionIntType() {
        if (this.unspecifiedTransactionType == -1) {
            String txType = this.modulePair.getUnspecifiedTransactionType();
            this.unspecifiedTransactionType = txType != null ? TransactionInfo.getTransactionType(txType) : 2;
        }
        return this.unspecifiedTransactionType;
    }

    public WebservicesPair getWebservicesPair() {
        return this.modulePair.getWebservicesPair();
    }

    public String toConfigString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("BeanName : ").append(this.getBeanName()).append(StringUtil.lineSeparator);
        buffer.append("EJBBeanClass : ").append(this.getFullEJBBeanClassName()).append(StringUtil.lineSeparator);
        buffer.append("EJBObjectImplClass : ").append(this.getEJBObjectImplClassName()).append(StringUtil.lineSeparator);
        buffer.append("EJBHomeImplClass : ").append(this.getEJBHomeImplClassName()).append(StringUtil.lineSeparator);
        if (this.getEJBObjectClassName() != null) {
            buffer.append("ExportPort : ").append(this.getExportPort()).append(StringUtil.lineSeparator);
            buffer.append("ExportIIOP : ").append(this.getExportIIOP()).append(StringUtil.lineSeparator);
            buffer.append("ExportName : ").append(this.getExportName()).append(StringUtil.lineSeparator);
            buffer.append("EJBObjectClass : ").append(this.getEJBObjectClassName()).append(StringUtil.lineSeparator);
            buffer.append("EJBHomeClass : ").append(this.getEJBHomeClassName()).append(StringUtil.lineSeparator);
            buffer.append("LocalInvocationOptimization : ").append(this.isLocalInvocationOptimized()).append(StringUtil.lineSeparator);
        }
        if (this.getEJBLocalObjectClassName() != null) {
            buffer.append("LocalExportName : ").append(this.getLocalExportName()).append(StringUtil.lineSeparator);
            buffer.append("EJBLocalObjectClass : ").append(this.getEJBLocalObjectClassName()).append(StringUtil.lineSeparator);
            buffer.append("EJBLocalObjectImplClass : ").append(this.getEJBLocalObjectImplClassName()).append(StringUtil.lineSeparator);
            buffer.append("EJBLocalHomeClass : ").append(this.getEJBLocalHomeClassName()).append(StringUtil.lineSeparator);
            buffer.append("EJBLocalHomeImplClass : ").append(this.getEJBLocalHomeImplClassName()).append(StringUtil.lineSeparator);
        }
        buffer.append("PassivationTimeout : ").append(this.getPassivationTimeout() == null ? "Not Set" : this.getPassivationTimeout()).append(StringUtil.lineSeparator);
        buffer.append("DisconnectTimeout : ").append(this.getDisconnectTimeout() == null ? "Not Set" : this.getDisconnectTimeout()).append(StringUtil.lineSeparator);
        buffer.append("EJBClustering : ").append(this.getClusterDesc() != null && this.getClusterDesc().isEnableClustering() != false).append(StringUtil.lineSeparator);
        buffer.append("SingleVMOnly : ").append(this.isSingleVMOnly()).append(StringUtil.lineSeparator);
        return buffer.toString();
    }

    public long getEJBBeanResizingPeriod() {
        return this.objectManagementType.getBeanPool().getResizingPeriod();
    }

    public String getIIOPEJBHomeImplClassName() {
        return this.iiopEjbHomeImplClassName;
    }

    public String getIIOPEJBObjectImplClassName() {
        return this.iiopEjbObjectImplClassName;
    }

    public void setIIOPEJBHomeImplClassName(String s) {
        this.iiopEjbHomeImplClassName = s;
    }

    public void setIIOPEJBObjectImplClassName(String s) {
        this.iiopEjbObjectImplClassName = s;
    }

    public ModulePair getModulePair() {
        return this.modulePair;
    }

    public List getServiceRefPairs() {
        return this.serviceRefPairs;
    }

    public void setServiceRefPairs(List serviceRefPairs) {
        this.serviceRefPairs = serviceRefPairs;
    }

    public String getOriginalEJBBeanClassName() {
        return this.getFullEJBBeanClassName();
    }

    public JeusBeanType getJeusBeanType() {
        return this.jeusBean;
    }

    public abstract Object getEjbJarType();

    public jeus.ejb.metadata.BeanInfo getBeanInfo() {
        return this.beanInfo;
    }

    public void setBeanInfo(EntityBeanInfo beanInfo) {
        this.beanInfo = beanInfo;
    }

    public void setUnspecifiedTransactionAttr(int unspecifiedTransactionIntType) {
        this.unspecifiedTxAttr = unspecifiedTransactionIntType;
    }

    public int getTxAttributeWithTxInfo(Method m, int type) throws EJBSourceGeneratorException {
        return BeanInfo.getTxAttributeWithTxInfo(m, type, (Map)this.getModulePair().getTransactionInfo().get(this.ejbName), this.unspecifiedTxAttr, 2);
    }

    public boolean useJeusRmi() {
        if (this.jeusBean.isSetJeusRmi()) {
            return this.jeusBean.isJeusRmi();
        }
        return JeusEJBProperties.JEUS_RMI;
    }
}

