/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.ejbHelper;

import java.util.ArrayList;
import java.util.List;
import jeus.util.StringUtil;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.EJBDescriptorValidationException;
import jeus.xml.binding.ejbHelper.ModulePair;
import jeus.xml.binding.j2ee.ActivationConfigPropertyType;
import jeus.xml.binding.j2ee.ActivationConfigType;
import jeus.xml.binding.j2ee.FullyQualifiedClassType;
import jeus.xml.binding.j2ee.MessageDestinationLinkType;
import jeus.xml.binding.j2ee.MessageDrivenBeanType;
import jeus.xml.binding.j2ee.MessageDrivenDestinationType;
import jeus.xml.binding.jeusDD.JeusBeanType;
import jeus.xml.binding.jeusDD.JndiSpiType;

public class MessageDrivenBeanPair
extends BeanPair {
    private String ackMode;
    private String messageSelector;
    private String destination;
    private String durability;

    public MessageDrivenBeanPair(String ejbName, MessageDrivenBeanType entityBean, JeusBeanType jeusBean, ModulePair modulePair) throws EJBDescriptorValidationException {
        super(modulePair, jeusBean);
        ActivationConfigType activationConfig;
        MessageDestinationLinkType destinationLink;
        MessageDrivenDestinationType destinationType;
        this.messageDrivenBean = entityBean;
        this.ejbName = ejbName;
        this.ejbClassName = entityBean.getEjbClass().getValue();
        this.ackMode = jeusBean.getAckMode().value();
        this.messageSelector = jeusBean.getMsgSelector();
        this.destination = jeusBean.getDestination();
        this.durability = jeusBean.getDurable().value();
        if (this.messageSelector == null) {
            this.messageSelector = entityBean.getMessageSelector();
        }
        if (this.ackMode == null) {
            this.ackMode = entityBean.getAcknowledgeMode().value();
        }
        if ((destinationType = entityBean.getMessageDrivenDestination()) != null && this.durability == null) {
            this.durability = destinationType.getSubscriptionDurability().value();
        }
        if (this.destination == null && (destinationLink = entityBean.getMessageDestinationLink()) != null) {
            this.destination = modulePair.getMessageDestinationJndiName(destinationLink.getValue());
        }
        if ((activationConfig = this.messageDrivenBean.getActivationConfig()) != null) {
            List properties = activationConfig.getActivationConfigProperty();
            for (int i = 0; i < properties.size(); ++i) {
                ActivationConfigPropertyType activationConfigPropertyType = (ActivationConfigPropertyType)properties.get(i);
                if (activationConfigPropertyType.getActivationConfigPropertyName().getValue().trim().equals("acknowledgeMode") && this.ackMode == null) {
                    this.ackMode = activationConfigPropertyType.getActivationConfigPropertyValue().getValue().trim();
                    continue;
                }
                if (activationConfigPropertyType.getActivationConfigPropertyName().getValue().trim().equals("messageSelector") && this.messageSelector == null) {
                    this.messageSelector = activationConfigPropertyType.getActivationConfigPropertyValue().getValue().trim();
                    continue;
                }
                if (!activationConfigPropertyType.getActivationConfigPropertyName().getValue().trim().equals("subscriptionDurability") || this.durability != null) continue;
                this.durability = activationConfigPropertyType.getActivationConfigPropertyValue().getValue().trim();
            }
            if (jeusBean.getMdbResourceAdapterName() == null && this.destination == null) {
                throw new EJBDescriptorValidationException("The resource adapter or destination of the MDB is not specified");
            }
        } else if (this.destination == null) {
            throw new EJBDescriptorValidationException("The destination of the MDB is not specified");
        }
        if (this.ackMode == null) {
            this.ackMode = "Auto-acknowledge";
        }
        if (this.durability == null) {
            this.durability = "NonDurable";
        }
    }

    public boolean isEntityBean() {
        return false;
    }

    public boolean isConManagedEntityBean() {
        return false;
    }

    public boolean isAutoKeyGenerator() {
        return false;
    }

    protected boolean existsRemoteInterface() {
        return false;
    }

    public List getRoleLinkList() {
        return new ArrayList();
    }

    public List getEnvs() {
        return this.messageDrivenBean.getEnvEntry();
    }

    public List getEJBRefs() {
        return this.messageDrivenBean.getEjbRef();
    }

    public List getEJBLocalRefs() {
        return this.messageDrivenBean.getEjbLocalRef();
    }

    public List getResourceRefs() {
        return this.messageDrivenBean.getResourceRef();
    }

    public List getResourceEnvRefs() {
        return this.messageDrivenBean.getResourceEnvRef();
    }

    public boolean isContainerManagedTX() {
        return this.messageDrivenBean.getTransactionType().getValue().equals("Container");
    }

    public String getDestination() {
        return this.destination;
    }

    public String getMessageSelector() {
        return this.messageSelector;
    }

    public boolean isDurable() {
        return this.durability.equals("Durable");
    }

    public int getMaxMessage() {
        return this.jeusBean.getMaxMessage();
    }

    public int getAckMode() {
        if (this.ackMode.equals("Dups-ok-acknowledge")) {
            return 3;
        }
        return 1;
    }

    public List getActivationSpecTable() {
        ActivationConfigType activationConfig = this.messageDrivenBean.getActivationConfig();
        if (activationConfig != null) {
            return activationConfig.getActivationConfigProperty();
        }
        return null;
    }

    public String getMessagingType() {
        FullyQualifiedClassType type = this.messageDrivenBean.getMessagingType();
        if (type == null) {
            return "javax.jms.MessageListener";
        }
        return type.getValue();
    }

    public String getInitialContextFactory() {
        JndiSpiType jndiSpi = this.jeusBean.getJndiSpi();
        if (jndiSpi != null) {
            return jndiSpi.getInitialContextFactory();
        }
        return "jeus.jndi.JNSContextFactory";
    }

    public String getProviderURL() {
        JndiSpiType jndiSpi = this.jeusBean.getJndiSpi();
        if (jndiSpi != null) {
            return jndiSpi.getProviderUrl();
        }
        return null;
    }

    public String getFactoryName() {
        return this.jeusBean.getConnectionFactoryName();
    }

    public String getVendor() {
        JndiSpiType jndiSpi = this.jeusBean.getJndiSpi();
        if (jndiSpi != null) {
            return jndiSpi.getMqVendor().value();
        }
        return null;
    }

    public String getCorrespondResourceAdapter() {
        return this.jeusBean.getMdbResourceAdapterName();
    }

    public boolean useResourceAdapter() {
        return this.jeusBean.getMdbResourceAdapterName() != null;
    }

    public List getMessageDestinationRefs() {
        return this.messageDrivenBean.getMessageDestinationRef();
    }

    public List getServiceRefs() {
        return this.messageDrivenBean.getServiceRef();
    }

    public String toConfigString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ContainerManagedTransaction : ").append(this.isContainerManagedTX()).append(StringUtil.lineSeparator);
        buffer.append("BeanName : ").append(this.getBeanName()).append(StringUtil.lineSeparator);
        buffer.append("EJBBeanClass : ").append(this.getFullEJBBeanClassName()).append(StringUtil.lineSeparator);
        buffer.append("EJBBeanPoolSize : ").append(this.getEJBBeanPoolSize()).append(StringUtil.lineSeparator);
        buffer.append("Destination : ").append(this.getDestination()).append(StringUtil.lineSeparator);
        buffer.append("MessageSelector : ").append(this.getMessageSelector()).append(StringUtil.lineSeparator);
        buffer.append("Durability : ").append(this.isDurable()).append(StringUtil.lineSeparator);
        buffer.append("maxMessage : ").append(this.getMaxMessage()).append(StringUtil.lineSeparator);
        buffer.append("ackMode : ").append(this.getAckMode()).append(StringUtil.lineSeparator);
        return super.toConfigString();
    }

    public Object getEjbJarType() {
        return this.messageDrivenBean;
    }
}

