/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.ejbHelper;

import java.util.List;
import javax.xml.bind.JAXBException;
import jeus.util.StringUtil;
import jeus.xml.binding.ejbHelper.BeanPair;
import jeus.xml.binding.ejbHelper.ModulePair;
import jeus.xml.binding.j2ee.HomeType;
import jeus.xml.binding.j2ee.LocalHomeType;
import jeus.xml.binding.j2ee.LocalType;
import jeus.xml.binding.j2ee.RemoteType;
import jeus.xml.binding.j2ee.SessionBeanType;
import jeus.xml.binding.jeusDD.JeusBeanType;

public class SessionBeanPair
extends BeanPair {
    public SessionBeanPair(String ejbName, SessionBeanType entityBean, JeusBeanType jeusBean, ModulePair modulePair) throws JAXBException {
        super(modulePair, jeusBean);
        LocalType localType;
        RemoteType remoteType;
        LocalHomeType localHomeType;
        this.ejbName = ejbName;
        this.sessionBean = entityBean;
        HomeType homeType = entityBean.getHome();
        if (homeType != null) {
            this.home = homeType.getValue();
        }
        if ((localHomeType = entityBean.getLocalHome()) != null) {
            this.localHome = localHomeType.getValue();
        }
        if ((remoteType = entityBean.getRemote()) != null) {
            this.remote = remoteType.getValue();
        }
        if ((localType = entityBean.getLocal()) != null) {
            this.local = localType.getValue();
        }
        this.ejbClassName = entityBean.getEjbClass().getValue();
    }

    public boolean isEntityBean() {
        return false;
    }

    public boolean isConManagedEntityBean() {
        return false;
    }

    public boolean isAutoKeyGenerator() {
        return false;
    }

    public List getRoleLinkList() {
        return this.sessionBean.getSecurityRoleRef();
    }

    public List getEnvs() {
        return this.sessionBean.getEnvEntry();
    }

    public List getEJBRefs() {
        return this.sessionBean.getEjbRef();
    }

    public List getEJBLocalRefs() {
        return this.sessionBean.getEjbLocalRef();
    }

    public List getResourceRefs() {
        return this.sessionBean.getResourceRef();
    }

    public List getResourceEnvRefs() {
        return this.sessionBean.getResourceEnvRef();
    }

    public boolean isContainerManagedTX() {
        return this.sessionBean.getTransactionType().getValue().equals("Container");
    }

    public List getMessageDestinationRefs() {
        return this.sessionBean.getMessageDestinationRef();
    }

    public List getServiceRefs() {
        return this.sessionBean.getServiceRef();
    }

    public String toConfigString() {
        StringBuffer configStringBuffer = new StringBuffer(super.toConfigString());
        configStringBuffer.append("ContainerManagedTransaction : ").append(this.isContainerManagedTX()).append(StringUtil.lineSeparator);
        return configStringBuffer.toString();
    }

    public Object getEjbJarType() {
        return this.sessionBean;
    }
}

