/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.binding.util;

public class JavaNamer {
    public static final char[] PUNCTUATION_CHARS = new char[]{'-', '.', ':', '_', '\u00b7', '\u0387', '\u06dd', '\u06de'};

    public static boolean isPunctuationCharacter(char c, boolean isUnderscoreWordSeparator) {
        for (int i = 0; i < PUNCTUATION_CHARS.length; ++i) {
            char pc = PUNCTUATION_CHARS[i];
            if (pc == '_' && !isUnderscoreWordSeparator || c != pc) continue;
            return true;
        }
        return false;
    }

    public static String convert(String pLocalName, boolean isUnderscoreWordSeparator) {
        StringBuffer result = new StringBuffer();
        char c = pLocalName.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            result.append(Character.toUpperCase(c));
        } else {
            result.append('_');
        }
        for (int i = 1; i < pLocalName.length(); ++i) {
            c = pLocalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isDigit(pLocalName.charAt(i - 1)) && !Character.isDigit(c)) {
                    result.append(Character.toUpperCase(c));
                    continue;
                }
                result.append(c);
                continue;
            }
            if (JavaNamer.isPunctuationCharacter(c, isUnderscoreWordSeparator)) {
                c = pLocalName.charAt(++i);
                result.append(Character.toUpperCase(c));
                continue;
            }
            result.append('_');
        }
        return result.toString();
    }

    public static String convertToConstant(String pLocalName) {
        StringBuffer result = new StringBuffer();
        char c = pLocalName.charAt(0);
        if (Character.isJavaIdentifierStart(c)) {
            result.append(Character.toUpperCase(c));
        } else {
            result.append('_');
        }
        char prevChar = c;
        for (int i = 1; i < pLocalName.length(); ++i) {
            c = pLocalName.charAt(i);
            if (Character.isJavaIdentifierPart(c) && c != '_') {
                if (Character.isUpperCase(c) && Character.isLowerCase(prevChar)) {
                    result.append('_');
                }
                result.append(Character.toUpperCase(c));
            } else {
                result.append('_');
            }
            prevChar = c;
        }
        return result.toString();
    }

    public static void main(String[] args) {
        System.out.println(JavaNamer.convertToConstant("ejbPostCreate"));
    }
}

