/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import jeus.xml.binding.util.JeusBinding;
import jeus.xml.binding.util.JeusBindingInterface;
import jeus.xml.util.DomProcessor;
import jeus.xml.util.XPathComment;
import jeus.xml.util.XPathPositionType;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CommentExtractor {
    private Stack ancestors = new Stack();
    private List comments = new ArrayList();

    CommentExtractor() {
    }

    public List extract(JeusBinding binding) {
        this.ancestors.clear();
        this.comments.clear();
        HashMap bindingMap = new HashMap();
        Document doc = JeusBinding.createDocument((JeusBinding)binding, bindingMap);
        this.jtraverse(doc.getDocumentElement(), bindingMap);
        return this.comments;
    }

    public List extract(JeusBindingInterface binding) {
        this.ancestors.clear();
        this.comments.clear();
        HashMap bindingMap = binding.getInfoMap();
        String name = JeusBinding.getElementNameFromClass(binding.getClass());
        Document doc = DomProcessor.createEmptyDocument();
        Element root = binding.createElement(doc, name, bindingMap);
        bindingMap.put(root, binding);
        doc.appendChild(root);
        this.jtraverse(doc.getDocumentElement(), bindingMap);
        return this.comments;
    }

    private void jtraverse(Node node, HashMap bindingMap) {
        XPathComment comment;
        int i;
        ArrayList ecomments;
        JeusBinding binding;
        Ancestor ancestor;
        if (node.getNodeType() != 1) {
            return;
        }
        if (CommentExtractor.getPreviousElement(node) == null) {
            ancestor = new Ancestor();
            ancestor.setCurrent(node.getNodeName());
            this.ancestors.push(ancestor);
        } else {
            ancestor = (Ancestor)this.ancestors.peek();
            ancestor.setCurrent(node.getNodeName());
        }
        Object object = bindingMap.get(node);
        if (object instanceof JeusBinding) {
            binding = (JeusBinding)bindingMap.get(node);
            if (binding != null) {
                ecomments = binding.getComments();
                for (i = 0; i < ecomments.size(); ++i) {
                    comment = (XPathComment)ecomments.get(i);
                    this.addComment(comment);
                }
            }
        } else if (object instanceof JeusBindingInterface && (binding = (JeusBindingInterface)bindingMap.get(node)) != null) {
            ecomments = binding.getComments();
            for (i = 0; i < ecomments.size(); ++i) {
                comment = (XPathComment)ecomments.get(i);
                this.addComment(comment);
            }
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.jtraverse(child, bindingMap);
        }
        if (CommentExtractor.getNextElement(node) == null) {
            this.ancestors.pop();
        }
    }

    private static String mergePath(String xpath, String jaxbPath) {
        int i;
        String[] xitems = xpath.trim().split("/");
        String[] jitems = jaxbPath.trim().split("/");
        int count = Math.min(xitems.length, jitems.length);
        StringBuffer buf = new StringBuffer();
        for (i = 0; i < count; ++i) {
            if (jitems[i].equals("")) continue;
            int l = jitems[i].indexOf(91);
            int r = jitems[i].indexOf(93);
            int index = Integer.parseInt(jitems[i].substring(l + 1, r));
            l = xitems[i].indexOf(91);
            String name = xitems[i].substring(0, l);
            buf.append("/").append(name).append("[").append(index).append("]");
        }
        if (count < xitems.length) {
            for (i = count; i < xitems.length; ++i) {
                buf.append("/").append(xitems[i]);
            }
        }
        return buf.toString();
    }

    private void addComment(XPathComment comment) {
        String xpath = this.getCurrentPath();
        xpath = CommentExtractor.mergePath(comment.getXPath(), xpath);
        comment.setXPath(xpath);
        this.comments.add(comment);
    }

    public List extract(Document doc) {
        this.ancestors.clear();
        this.comments.clear();
        String xpath = "/" + doc.getDocumentElement().getLocalName() + "[1]";
        NodeList children = doc.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 8) continue;
            Node prev = CommentExtractor.getPreviousElement(node);
            Node next = CommentExtractor.getNextElement(node);
            if (prev != null) {
                this.comments.add(new XPathComment(xpath, XPathPositionType.PREVIOUS_SIBLING, ((Comment)node).getData()));
                continue;
            }
            if (next == null) continue;
            this.comments.add(new XPathComment(xpath, XPathPositionType.NEXT_SIBLING, ((Comment)node).getData()));
        }
        this.traverse(doc.getDocumentElement());
        return Collections.unmodifiableList(this.comments);
    }

    private void traverse(Node node) {
        Ancestor ancestor;
        if (node.getNodeType() == 8) {
            this.addComment((Comment)node);
        }
        if (node.getNodeType() != 1) {
            return;
        }
        if (CommentExtractor.getPreviousElement(node) == null) {
            ancestor = new Ancestor();
            ancestor.setCurrent(node.getLocalName());
            this.ancestors.push(ancestor);
        } else {
            ancestor = (Ancestor)this.ancestors.peek();
            ancestor.setCurrent(node.getLocalName());
        }
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.traverse(child);
        }
        if (CommentExtractor.getNextElement(node) == null) {
            this.ancestors.pop();
        }
    }

    private static Node getPreviousElement(Node node) {
        while ((node = node.getPreviousSibling()) != null) {
            if (node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }

    private static Node getNextElement(Node node) {
        while ((node = node.getNextSibling()) != null) {
            if (node.getNodeType() != 1) continue;
            return node;
        }
        return null;
    }

    private void addComment(Comment comment) {
        XPathPositionType position;
        String xpath = this.getCurrentPath();
        Node prev = CommentExtractor.getPreviousElement(comment);
        Node next = CommentExtractor.getNextElement(comment);
        if (prev == null) {
            if (next != null) {
                xpath = xpath + "/" + next.getLocalName() + "[1]";
                position = XPathPositionType.NEXT_SIBLING;
            } else {
                position = XPathPositionType.PARENT;
            }
        } else {
            position = next == null ? XPathPositionType.PARENT : XPathPositionType.PREVIOUS_SIBLING;
        }
        this.comments.add(new XPathComment(xpath, position, comment.getData()));
    }

    private String getCurrentPath() {
        StringBuffer xpath = new StringBuffer();
        for (int i = 0; i < this.ancestors.size(); ++i) {
            Ancestor ancestor = (Ancestor)this.ancestors.get(i);
            xpath.append("/").append(ancestor.getCurrent()).append("[").append(ancestor.getCurrentCount()).append("]");
        }
        return xpath.toString();
    }

    private static class Ancestor {
        private String current;
        private HashMap countMap = new HashMap();

        private Ancestor() {
        }

        public void setCurrent(String current) {
            this.current = current;
            if (!this.countMap.containsKey(current)) {
                this.countMap.put(current, new Integer(1));
            } else {
                Integer count = (Integer)this.countMap.get(current);
                this.countMap.put(current, new Integer(count + 1));
            }
        }

        public String getCurrent() {
            return this.current;
        }

        public int getCurrentCount() {
            return (Integer)this.countMap.get(this.current);
        }
    }
}

