/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ElementOrderTable
implements Serializable {
    private List elements = new ArrayList();
    private String namespace;

    public ElementOrderTable(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Entry getRoot() {
        if (this.elements.size() > 0) {
            return (Entry)this.elements.get(0);
        }
        return null;
    }

    public void addEntry(int id, String name) {
        this.elements.add(id, new Entry(id, name));
    }

    public void addEntry(int pid, int id, String name) {
        this.elements.add(id, new Entry(pid, id, name));
        if (pid < this.elements.size()) {
            Entry parent = (Entry)this.elements.get(pid);
            parent.addChild(id, name);
        }
    }

    public Entry getEntry(int id) {
        return (Entry)this.elements.get(id);
    }

    public void debug(OutputStream os) {
        PrintWriter writer = new PrintWriter(os);
        writer.println("namespace:" + this.namespace);
        writer.println("entries:");
        for (int i = 0; i < this.elements.size(); ++i) {
            Entry entry = (Entry)this.elements.get(i);
            writer.print(entry.getId() + ":" + entry.getParent() + ":" + entry.getName() + ":");
            entry.debug(writer);
            writer.println();
            writer.flush();
        }
    }

    public static class Entry
    implements Serializable {
        private int pid;
        private int id;
        private String name;
        private HashMap childMap = new HashMap();
        private boolean isChoice = false;
        private boolean isIncludeChoiceOrSequence = false;
        private List includeChoiceOrSequenceElements;
        private boolean isRecursive = false;

        public Entry(int id, String name) {
            this.pid = -1;
            this.id = id;
            this.name = name;
        }

        public Entry(int pid, int id, String name) {
            this.pid = pid;
            this.id = id;
            this.name = name;
        }

        public int getParent() {
            return this.pid;
        }

        public int getChild(String cname) {
            Object result = this.childMap.get(cname);
            if (result == null) {
                return -1;
            }
            return (Integer)result;
        }

        public void addChild(int cid, String cname) {
            this.childMap.put(cname, new Integer(cid));
        }

        public int getId() {
            return this.id;
        }

        public void setId(int id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void debug(PrintWriter writer) {
            Iterator iter = this.childMap.keySet().iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                Integer id = (Integer)this.childMap.get(name);
                writer.print("{" + id + "," + name + "}");
                if (!iter.hasNext()) continue;
                writer.print(",");
            }
        }

        public void setChoice(boolean b) {
            this.isChoice = b;
        }

        public boolean isChoice() {
            return this.isChoice;
        }

        public void setIncludeChoiceOrSequence(boolean b) {
            this.isIncludeChoiceOrSequence = b;
        }

        public boolean isIncludeChoiceOrSequence() {
            return this.isIncludeChoiceOrSequence;
        }

        public void setIncludeChoiceOrSequenceElements(List includeChoiceElements) {
            this.includeChoiceOrSequenceElements = includeChoiceElements;
        }

        public List getIncludeChoiceOrSequenceElements() {
            return this.includeChoiceOrSequenceElements;
        }

        public void setRecursive(boolean b) {
            this.isRecursive = b;
        }

        public boolean isRecursive() {
            return this.isRecursive;
        }
    }
}

