/*
 * Decompiled with CFR 0.152.
 */
package jeus.xml.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jeus.xml.util.ElementException;
import jeus.xml.util.ElementOrderTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementSort {
    public static void sort(Document doc, ElementOrderTable t) throws ElementException {
        ElementOrderTable.Entry entry = t.getEntry(0);
        Element root = doc.getDocumentElement();
        if (!root.getLocalName().equals(entry.getName())) {
            throw new ElementException("unexpected root element '" + root.getLocalName() + "'.");
        }
        ElementSort.sort(t, 0, root, new ElementComparator());
    }

    private static void sort(ElementOrderTable t, int id, Element e, ElementComparator c) throws ElementException {
        ArrayList<Node> elements = new ArrayList<Node>();
        ArrayList<Node> copyElements = new ArrayList<Node>();
        NodeList childList = e.getChildNodes();
        ElementOrderTable.Entry entry = t.getEntry(id);
        int cnt = childList.getLength();
        int item = 0;
        if (entry.isRecursive()) {
            ElementOrderTable.Entry parentEntry;
            entry = parentEntry = t.getEntry(entry.getParent());
            c.setEntry(parentEntry);
            for (int i = 0; i < cnt; ++i) {
                Node node = childList.item(item);
                if (node.getNodeType() == 1) {
                    int cid = parentEntry.getChild(node.getLocalName());
                    if (cid < 0) {
                        throw new ElementException("'" + e.getLocalName() + "' element does not contain '" + node.getLocalName() + "' child element.");
                    }
                    Node n = e.removeChild(node);
                    elements.add(n);
                    copyElements.add(n);
                    continue;
                }
                ++item;
            }
        } else {
            c.setEntry(entry);
            for (int i = 0; i < cnt; ++i) {
                Node node = childList.item(item);
                if (node.getNodeType() == 1) {
                    int cid = entry.getChild(node.getLocalName());
                    if (cid < 0) {
                        throw new ElementException("'" + e.getLocalName() + "' element does not contain '" + node.getLocalName() + "' child element.");
                    }
                    Node n = e.removeChild(node);
                    elements.add(n);
                    copyElements.add(n);
                    continue;
                }
                ++item;
            }
        }
        Collections.sort(elements, c);
        if (entry.isIncludeChoiceOrSequence()) {
            List choiceOrSequenceElements = entry.getIncludeChoiceOrSequenceElements();
            ElementSort.sortIncludeChoice(elements, copyElements, choiceOrSequenceElements);
        }
        for (int i = 0; i < elements.size(); ++i) {
            Node node = (Node)elements.get(i);
            e.appendChild(node);
            int cid = entry.getChild(node.getLocalName());
            ElementSort.sort(t, cid, (Element)node, c);
        }
    }

    private static void sortIncludeChoice(List elements, List copyElements, List choiceOrSequenceElements) {
        Node temp;
        int i;
        ArrayList<Integer> indexElements = new ArrayList<Integer>();
        ArrayList<Integer> indexCopyElements = new ArrayList<Integer>();
        for (i = 0; i < elements.size(); ++i) {
            temp = (Node)elements.get(i);
            if (!choiceOrSequenceElements.contains(temp.getLocalName())) continue;
            indexElements.add(new Integer(i));
        }
        for (i = 0; i < elements.size(); ++i) {
            temp = (Node)copyElements.get(i);
            if (!choiceOrSequenceElements.contains(temp.getLocalName())) continue;
            indexCopyElements.add(new Integer(i));
        }
        for (i = 0; i < indexElements.size(); ++i) {
            Node node = (Node)copyElements.get((Integer)indexCopyElements.get(i));
            elements.set((Integer)indexElements.get(i), node);
        }
    }

    private static class ElementComparator
    implements Comparator {
        private ElementOrderTable.Entry entry;

        public void setEntry(ElementOrderTable.Entry entry) {
            this.entry = entry;
        }

        public int compare(Object o1, Object o2) {
            int n1 = this.entry.getChild(((Element)o1).getLocalName());
            int n2 = this.entry.getChild(((Element)o2).getLocalName());
            return n1 - n2;
        }
    }
}

