/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.assertion;

import java.util.Arrays;
import org.dbunit.assertion.DbAssertionFailedError;
import org.dbunit.assertion.DbComparisonFailure;
import org.dbunit.assertion.Difference;
import org.dbunit.assertion.FailureFactory;
import org.dbunit.assertion.FailureHandler;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.ColumnFilterTable;
import org.dbunit.dataset.Columns;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableMetaData;
import org.dbunit.dataset.NoSuchColumnException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFailureHandler
implements FailureHandler {
    private static final Logger logger = LoggerFactory.getLogger((Class)DefaultFailureHandler.class);
    private String[] _additionalColumnInfo;
    private FailureFactory failureFactory = new DefaultFailureFactory();

    public DefaultFailureHandler() {
    }

    public DefaultFailureHandler(Column[] additionalColumnInfo) {
        if (additionalColumnInfo != null) {
            this._additionalColumnInfo = Columns.getColumnNames(additionalColumnInfo);
        }
    }

    public DefaultFailureHandler(String[] additionalColumnInfo) {
        this._additionalColumnInfo = additionalColumnInfo;
    }

    public void setFailureFactory(FailureFactory failureFactory) {
        if (failureFactory == null) {
            throw new NullPointerException("The parameter 'failureFactory' must not be null");
        }
        this.failureFactory = failureFactory;
    }

    public Error createFailure(String message, String expected, String actual) {
        return this.failureFactory.createFailure(message, expected, actual);
    }

    public Error createFailure(String message) {
        return this.failureFactory.createFailure(message);
    }

    public String getAdditionalInfo(ITable expectedTable, ITable actualTable, int row, String columnName) {
        String additionalInfo = this.buildAdditionalColumnInfo(expectedTable, actualTable, row);
        return additionalInfo;
    }

    private String buildAdditionalColumnInfo(ITable expectedTable, ITable actualTable, int rowIndex) {
        if (logger.isDebugEnabled()) {
            logger.debug("buildAdditionalColumnInfo(expectedTable={}, actualTable={}, rowIndex={}, additionalColumnInfo={}) - start", new Object[]{expectedTable, actualTable, new Integer(rowIndex), this._additionalColumnInfo});
        }
        if (this._additionalColumnInfo == null || this._additionalColumnInfo.length <= 0) {
            return null;
        }
        String additionalInfo = "";
        for (int j = 0; j < this._additionalColumnInfo.length; ++j) {
            String columnName = this._additionalColumnInfo[j];
            try {
                ITable expectedTableForCol = this.getTableForColumn(expectedTable, columnName);
                ITable actualTableForCol = this.getTableForColumn(actualTable, columnName);
                Object expectedKeyValue = expectedTableForCol.getValue(rowIndex, columnName);
                Object actualKeyValue = actualTableForCol.getValue(rowIndex, columnName);
                additionalInfo = additionalInfo + " ('" + columnName + "': expected=<" + expectedKeyValue + ">, actual=<" + actualKeyValue + ">)";
                continue;
            }
            catch (DataSetException e) {
                String msg = "Exception creating more info for column '" + columnName + "'";
                msg = msg + ": " + e.getClass().getName() + ": " + e.getMessage();
                logger.info(msg, (Throwable)e);
                additionalInfo = additionalInfo + " (!!!!! " + msg + ")";
            }
        }
        if (additionalInfo.length() > 0) {
            additionalInfo = "Additional row info:" + additionalInfo;
            return additionalInfo;
        }
        return null;
    }

    private ITable getTableForColumn(ITable table, String columnName) throws DataSetException {
        ITableMetaData tableMetaData = table.getTableMetaData();
        try {
            tableMetaData.getColumnIndex(columnName);
            return table;
        }
        catch (NoSuchColumnException e) {
            if (table instanceof ColumnFilterTable) {
                ITableMetaData originalMetaData = ((ColumnFilterTable)table).getOriginalMetaData();
                originalMetaData.getColumnIndex(columnName);
                return table;
            }
            throw e;
        }
    }

    public void handle(Difference diff) {
        String msg = this.buildMessage(diff);
        Error err = this.createFailure(msg, String.valueOf(diff.getExpectedValue()), String.valueOf(diff.getActualValue()));
        throw err;
    }

    protected String buildMessage(Difference diff) {
        int row = diff.getRowIndex();
        String columnName = diff.getColumnName();
        String tableName = diff.getExpectedTable().getTableMetaData().getTableName();
        String msg = "value (table=" + tableName + ", row=" + row + ", col=" + columnName;
        String additionalInfo = this.getAdditionalInfo(diff.getExpectedTable(), diff.getActualTable(), row, columnName);
        if (additionalInfo != null && !additionalInfo.trim().equals("")) {
            msg = msg + ", " + additionalInfo;
        }
        msg = msg + ")";
        return msg;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(DefaultFailureHandler.class.getName()).append("[");
        sb.append("_additionalColumnInfo=").append(this._additionalColumnInfo == null ? "null" : Arrays.asList(this._additionalColumnInfo).toString());
        sb.append("]");
        return sb.toString();
    }

    public static class DefaultFailureFactory
    implements FailureFactory {
        public Error createFailure(String message, String expected, String actual) {
            return new DbComparisonFailure(message, expected, actual);
        }

        public Error createFailure(String message) {
            return new DbAssertionFailedError(message);
        }
    }
}

