/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.database;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.database.AbstractResultSetTable;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.Column;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.ITableMetaData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScrollableResultSetTable
extends AbstractResultSetTable {
    private static final Logger logger = LoggerFactory.getLogger((Class)ScrollableResultSetTable.class);
    private final int _rowCount;

    public ScrollableResultSetTable(ITableMetaData metaData, ResultSet resultSet) throws SQLException, DataSetException {
        super(metaData, resultSet);
        try {
            if (this._resultSet.getType() == 1003) {
                throw new SQLException("Forward only ResultSet not supported");
            }
            this._resultSet.last();
            this._rowCount = this._resultSet.getRow();
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    public ScrollableResultSetTable(ITableMetaData metaData, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(metaData, connection);
        try {
            if (this._resultSet.getType() == 1003) {
                throw new SQLException("Forward only ResultSet not supported");
            }
            this._resultSet.last();
            this._rowCount = this._resultSet.getRow();
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    public ScrollableResultSetTable(String tableName, String selectStatement, IDatabaseConnection connection) throws DataSetException, SQLException {
        super(tableName, selectStatement, connection);
        try {
            if (this._resultSet.getType() == 1003) {
                throw new SQLException("Forward only ResultSet not supported");
            }
            this._resultSet.last();
            this._rowCount = this._resultSet.getRow();
        }
        catch (SQLException e) {
            this.close();
            throw e;
        }
    }

    public int getRowCount() {
        return this._rowCount;
    }

    public Object getValue(int row, String columnName) throws DataSetException {
        if (logger.isDebugEnabled()) {
            logger.debug("getValue(row={}, columnName={}) - start", (Object)Integer.toString(row), (Object)columnName);
        }
        this.assertValidRowIndex(row);
        try {
            this._resultSet.absolute(row + 1);
            int columnIndex = this.getColumnIndex(columnName);
            Column column = this._metaData.getColumns()[columnIndex];
            return column.getDataType().getSqlValue(columnIndex + 1, this._resultSet);
        }
        catch (SQLException e) {
            throw new DataSetException(e);
        }
    }
}

