/*
 * Decompiled with CFR 0.152.
 */
package org.dbunit.ext.oracle;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.ClobDataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OracleClobDataType
extends ClobDataType {
    private static final Logger logger = LoggerFactory.getLogger((Class)OracleClobDataType.class);
    private static final Integer DURATION_SESSION = new Integer(1);
    private static final Integer MODE_READWRITE = new Integer(1);

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("getSqlValue(column={}, resultSet={}) - start", (Object)new Integer(column), (Object)resultSet);
        }
        return this.typeCast(resultSet.getClob(column));
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (logger.isDebugEnabled()) {
            logger.debug("setSqlValue(value={}, column={}, statement={}) - start", new Object[]{value, new Integer(column), statement});
        }
        statement.setObject(column, this.getClob(value, statement.getConnection()));
    }

    protected Object getClob(Object value, Connection connection) throws TypeCastException {
        logger.debug("getClob(value={}, connection={}) - start", value, (Object)connection);
        Object tempClob = null;
        try {
            Class aClobClass = super.loadClass("oracle.sql.CLOB", connection);
            Method createTemporaryMethod = aClobClass.getMethod("createTemporary", Connection.class, Boolean.TYPE, Integer.TYPE);
            tempClob = createTemporaryMethod.invoke(null, connection, Boolean.TRUE, DURATION_SESSION);
            Method openMethod = aClobClass.getMethod("open", Integer.TYPE);
            openMethod.invoke(tempClob, MODE_READWRITE);
            Method getCharacterOutputStreamMethod = tempClob.getClass().getMethod("getCharacterOutputStream", new Class[0]);
            Writer tempClobWriter = (Writer)getCharacterOutputStreamMethod.invoke(tempClob, new Object[0]);
            tempClobWriter.write((String)this.typeCast(value));
            tempClobWriter.flush();
            tempClobWriter.close();
            Method closeMethod = tempClob.getClass().getMethod("close", new Class[0]);
            closeMethod.invoke(tempClob, new Object[0]);
        }
        catch (IllegalAccessException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (NoSuchMethodException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (IOException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        catch (InvocationTargetException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e.getTargetException());
        }
        catch (ClassNotFoundException e) {
            this.freeTemporaryClob(tempClob);
            throw new TypeCastException(value, this, e);
        }
        return tempClob;
    }

    protected void freeTemporaryClob(Object tempClob) throws TypeCastException {
        logger.debug("freeTemporaryClob(tempClob={}) - start", tempClob);
        if (tempClob == null) {
            return;
        }
        try {
            Method freeTemporaryMethod = tempClob.getClass().getMethod("freeTemporary", new Class[0]);
            freeTemporaryMethod.invoke(tempClob, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new TypeCastException("Error freeing Oracle CLOB", e);
        }
        catch (IllegalAccessException e) {
            throw new TypeCastException("Error freeing Oracle CLOB", e);
        }
        catch (InvocationTargetException e) {
            throw new TypeCastException("Error freeing Oracle CLOB", e.getTargetException());
        }
    }
}

