/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionInfoMap
extends HashMap<QName, Collection<AssertionInfo>> {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AssertionInfoMap.class, (String)"APIMessages");

    public AssertionInfoMap(Collection<Assertion> assertions) {
        super(assertions.size());
        for (Assertion a : assertions) {
            AssertionInfo ai = new AssertionInfo(a);
            ArrayList<AssertionInfo> ais = (ArrayList<AssertionInfo>)this.get(a.getName());
            if (null == ais) {
                ais = new ArrayList<AssertionInfo>();
                this.put(a.getName(), ais);
            }
            ais.add(ai);
        }
    }

    public boolean supportsAlternative(Collection<Assertion> alternative) {
        for (Assertion a : alternative) {
            boolean asserted = false;
            Collection ais = (Collection)this.get(a.getName());
            if (null != ais) {
                for (AssertionInfo ai : ais) {
                    if (!ai.getAssertion().equal((PolicyComponent)a) || !ai.isAsserted()) continue;
                    asserted = true;
                    break;
                }
            }
            if (asserted) continue;
            return false;
        }
        return true;
    }

    public void checkEffectivePolicy(Policy policy) {
        Iterator alternatives = policy.getAlternatives();
        while (alternatives.hasNext()) {
            List alternative = CastUtils.cast((List)((List)alternatives.next()), Assertion.class);
            if (!this.supportsAlternative(alternative)) continue;
            return;
        }
        throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
    }

    public void check() {
        for (Collection ais : this.values()) {
            for (AssertionInfo ai : ais) {
                if (ai.isAsserted()) continue;
                throw new PolicyException(new Message("NOT_ASSERTED_EXC", BUNDLE, new Object[]{ai.getAssertion().getName()}));
            }
        }
    }
}

