/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.wsdl;

import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchema;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.wsdl.PrettyPrintXMLStreamWriter;
import org.apache.cxf.wsdl.TExtensibilityElementImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBExtensionHelper
implements ExtensionSerializer,
ExtensionDeserializer {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBExtensionHelper.class);
    JAXBContext context;
    final Class<? extends TExtensibilityElementImpl> typeClass;

    public JAXBExtensionHelper(Class<? extends TExtensibilityElementImpl> cls) {
        this.typeClass = cls;
    }

    public static void addExtensions(ExtensionRegistry registry, String parentType, String elementType) throws JAXBException, ClassNotFoundException {
        Class parentTypeClass = ClassLoaderUtils.loadClass((String)parentType, JAXBExtensionHelper.class);
        Class<TExtensibilityElementImpl> elementTypeClass = ClassLoaderUtils.loadClass((String)elementType, JAXBExtensionHelper.class).asSubclass(TExtensibilityElementImpl.class);
        JAXBExtensionHelper.addExtensions(registry, parentTypeClass, elementTypeClass);
    }

    public static void addExtensions(ExtensionRegistry registry, Class<?> parentType, Class<? extends TExtensibilityElementImpl> cls) throws JAXBException {
        XmlRootElement elAnnot;
        JAXBExtensionHelper helper = new JAXBExtensionHelper(cls);
        boolean found = false;
        try {
            Method[] methods;
            Class<?> objectFactory = Class.forName(PackageUtils.getPackageName(cls) + ".ObjectFactory", true, cls.getClassLoader());
            for (Method method : methods = objectFactory.getDeclaredMethods()) {
                XmlElementDecl elementDecl;
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(cls) || null == (elementDecl = method.getAnnotation(XmlElementDecl.class))) continue;
                QName elementType = new QName(elementDecl.namespace(), elementDecl.name());
                registry.registerDeserializer(parentType, elementType, (ExtensionDeserializer)helper);
                registry.registerSerializer(parentType, elementType, (ExtensionSerializer)helper);
                registry.mapExtensionTypes(parentType, elementType, cls);
                found = true;
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        if (!found && (elAnnot = cls.getAnnotation(XmlRootElement.class)) != null) {
            String name = elAnnot.name();
            String ns = elAnnot.namespace();
            if (StringUtils.isEmpty((String)ns) || "##default".equals(ns)) {
                XmlSchema schema = null;
                if (cls.getPackage() != null) {
                    schema = cls.getPackage().getAnnotation(XmlSchema.class);
                }
                if (schema != null) {
                    ns = schema.namespace();
                }
            }
            if (!StringUtils.isEmpty((String)ns) && !StringUtils.isEmpty((String)name)) {
                QName elementType = new QName(ns, name);
                registry.registerDeserializer(parentType, elementType, (ExtensionDeserializer)helper);
                registry.registerSerializer(parentType, elementType, (ExtensionSerializer)helper);
                registry.mapExtensionTypes(parentType, elementType, cls);
                helper.getJAXBContext();
                found = true;
            }
        }
        if (!found) {
            LOG.log(Level.WARNING, "EXTENSION_NOT_REGISTERED", new Object[]{cls.getName(), parentType.getName()});
        }
    }

    protected JAXBContext getJAXBContext() {
        if (this.context == null) {
            try {
                this.createJAXBContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.context;
    }

    protected synchronized void createJAXBContext() throws JAXBException {
        if (this.context != null) {
            return;
        }
        this.context = JAXBContext.newInstance((String)PackageUtils.getPackageName(this.typeClass), (ClassLoader)this.typeClass.getClassLoader());
    }

    public void marshall(Class parent, QName qname, ExtensibilityElement obj, PrintWriter pw, final Definition wsdl, ExtensionRegistry registry) throws WSDLException {
        try {
            Method[] methods;
            Marshaller u = this.getJAXBContext().createMarshaller();
            u.setProperty("jaxb.encoding", (Object)"UTF-8");
            u.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            u.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            Object mObj = obj;
            Class<?> objectFactory = Class.forName(PackageUtils.getPackageName(this.typeClass) + ".ObjectFactory", true, obj.getClass().getClassLoader());
            for (Method method : methods = objectFactory.getDeclaredMethods()) {
                if (method.getParameterTypes().length != 1 || !method.getParameterTypes()[0].equals(this.typeClass)) continue;
                mObj = method.invoke(objectFactory.newInstance(), obj);
            }
            XMLOutputFactory fact = XMLOutputFactory.newInstance();
            PrettyPrintXMLStreamWriter writer = new PrettyPrintXMLStreamWriter(fact.createXMLStreamWriter(pw), parent);
            writer.setNamespaceContext(new NamespaceContext(){

                public String getNamespaceURI(String arg) {
                    return wsdl.getNamespace(arg);
                }

                public String getPrefix(String arg) {
                    for (Map.Entry ent : wsdl.getNamespaces().entrySet()) {
                        Map.Entry entry = ent;
                        if (!arg.equals(entry.getValue())) continue;
                        return (String)entry.getKey();
                    }
                    return null;
                }

                public Iterator getPrefixes(String arg) {
                    return wsdl.getNamespaces().keySet().iterator();
                }
            });
            u.marshal(mObj, (XMLStreamWriter)writer);
            writer.flush();
        }
        catch (Exception ex) {
            throw new WSDLException("PARSER_ERROR", "", (Throwable)ex);
        }
    }

    public ExtensibilityElement unmarshall(Class parent, QName qname, Element element, Definition wsdl, ExtensionRegistry registry) throws WSDLException {
        try {
            JAXBElement el;
            Unmarshaller u = this.getJAXBContext().createUnmarshaller();
            Object o = u.unmarshal((Node)element);
            if (o instanceof JAXBElement) {
                el = (JAXBElement)o;
                o = el.getValue();
            }
            ExtensibilityElement extensibilityElement = el = o instanceof ExtensibilityElement ? (ExtensibilityElement)o : null;
            if (null != el) {
                el.setElementType(qname);
            }
            return el;
        }
        catch (Exception ex) {
            throw new WSDLException("PARSER_ERROR", "Error reading element " + qname, (Throwable)ex);
        }
    }
}

