/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.interceptor;

import java.io.Serializable;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTraceInterceptor
implements MethodInterceptor,
Serializable {
    protected transient Log defaultLogger = LogFactory.getLog(this.getClass());

    public void setUseDynamicLogger(boolean useDynamicLogger) {
        this.defaultLogger = useDynamicLogger ? null : LogFactory.getLog(this.getClass());
    }

    public void setLoggerName(String loggerName) {
        this.defaultLogger = LogFactory.getLog((String)loggerName);
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Log logger = this.getLoggerForInvocation(invocation);
        if (logger.isTraceEnabled()) {
            return this.invokeUnderTrace(invocation, logger);
        }
        return invocation.proceed();
    }

    protected Log getLoggerForInvocation(MethodInvocation invocation) {
        return this.defaultLogger != null ? this.defaultLogger : LogFactory.getLog(invocation.getThis().getClass());
    }

    protected abstract Object invokeUnderTrace(MethodInvocation var1, Log var2) throws Throwable;
}

