/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.classfile.Attribute;
import org.aspectj.apache.bcel.classfile.AttributeUtils;
import org.aspectj.apache.bcel.classfile.ClassVisitor;
import org.aspectj.apache.bcel.classfile.CodeException;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.LineNumberTable;
import org.aspectj.apache.bcel.classfile.LocalVariableTable;
import org.aspectj.apache.bcel.classfile.Utility;

public final class Code
extends Attribute {
    private int maxStack;
    private int maxLocals;
    private byte[] code;
    private CodeException[] exceptionTable;
    private Attribute[] attributes;
    private static final CodeException[] NO_EXCEPTIONS = new CodeException[0];

    public Code(Code c) {
        this(c.getNameIndex(), c.getLength(), c.getMaxStack(), c.getMaxLocals(), c.getCode(), c.getExceptionTable(), c.getAttributes(), c.getConstantPool());
    }

    Code(int name_index, int length, DataInputStream file, ConstantPool constant_pool) throws IOException {
        this(name_index, length, file.readUnsignedShort(), file.readUnsignedShort(), null, null, null, constant_pool);
        int len = file.readInt();
        this.code = new byte[len];
        file.readFully(this.code);
        len = file.readUnsignedShort();
        if (len == 0) {
            this.exceptionTable = NO_EXCEPTIONS;
        } else {
            this.exceptionTable = new CodeException[len];
            int i = 0;
            while (i < len) {
                this.exceptionTable[i] = new CodeException(file);
                ++i;
            }
        }
        this.attributes = AttributeUtils.readAttributes(file, constant_pool);
        this.length = length;
    }

    public Code(int name_index, int length, int max_stack, int max_locals, byte[] code, CodeException[] exception_table, Attribute[] attributes, ConstantPool constant_pool) {
        super((byte)2, name_index, length, constant_pool);
        this.maxStack = max_stack;
        this.maxLocals = max_locals;
        this.setCode(code);
        this.setExceptionTable(exception_table);
        this.setAttributes(attributes);
    }

    public void accept(ClassVisitor v) {
        v.visitCode(this);
    }

    public final void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.maxStack);
        file.writeShort(this.maxLocals);
        file.writeInt(this.code.length);
        file.write(this.code, 0, this.code.length);
        file.writeShort(this.exceptionTable.length);
        int i = 0;
        while (i < this.exceptionTable.length) {
            this.exceptionTable[i].dump(file);
            ++i;
        }
        file.writeShort(this.attributes.length);
        i = 0;
        while (i < this.attributes.length) {
            this.attributes[i].dump(file);
            ++i;
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public LineNumberTable getLineNumberTable() {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].tag == 4) {
                return (LineNumberTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public LocalVariableTable getLocalVariableTable() {
        int i = 0;
        while (i < this.attributes.length) {
            if (this.attributes[i].tag == 5) {
                return (LocalVariableTable)this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    public final byte[] getCode() {
        return this.code;
    }

    public final CodeException[] getExceptionTable() {
        return this.exceptionTable;
    }

    public final int getMaxLocals() {
        return this.maxLocals;
    }

    public final int getMaxStack() {
        return this.maxStack;
    }

    private final int getInternalLength() {
        return 8 + (this.code == null ? 0 : this.code.length) + 2 + 8 * (this.exceptionTable == null ? 0 : this.exceptionTable.length) + 2;
    }

    private final int calculateLength() {
        int len = 0;
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                len += this.attributes[i].length + 6;
                ++i;
            }
        }
        return len + this.getInternalLength();
    }

    public final void setAttributes(Attribute[] attributes) {
        this.attributes = attributes;
        this.length = this.calculateLength();
    }

    public final void setCode(byte[] code) {
        this.code = code;
    }

    public final void setExceptionTable(CodeException[] exception_table) {
        this.exceptionTable = exception_table;
    }

    public final void setMaxLocals(int max_locals) {
        this.maxLocals = max_locals;
    }

    public final void setMaxStack(int max_stack) {
        this.maxStack = max_stack;
    }

    public final String toString(boolean verbose) {
        int i;
        StringBuffer buf = new StringBuffer("Code(max_stack = " + this.maxStack + ", max_locals = " + this.maxLocals + ", code_length = " + this.code.length + ")\n" + Utility.codeToString(this.code, this.constantPool, 0, -1, verbose));
        if (this.exceptionTable.length > 0) {
            buf.append("\nException handler(s) = \nFrom\tTo\tHandler\tType\n");
            i = 0;
            while (i < this.exceptionTable.length) {
                buf.append(String.valueOf(this.exceptionTable[i].toString(this.constantPool, verbose)) + "\n");
                ++i;
            }
        }
        if (this.attributes.length > 0) {
            buf.append("\nAttribute(s) = \n");
            i = 0;
            while (i < this.attributes.length) {
                buf.append(String.valueOf(this.attributes[i].toString()) + "\n");
                ++i;
            }
        }
        return buf.toString();
    }

    public final String toString() {
        return this.toString(true);
    }

    public Attribute copy(ConstantPool constant_pool) {
        Code c = (Code)this.clone();
        c.code = (byte[])this.code.clone();
        c.constantPool = constant_pool;
        c.exceptionTable = new CodeException[this.exceptionTable.length];
        int i = 0;
        while (i < this.exceptionTable.length) {
            c.exceptionTable[i] = this.exceptionTable[i].copy();
            ++i;
        }
        c.attributes = new Attribute[this.attributes.length];
        i = 0;
        while (i < this.attributes.length) {
            c.attributes[i] = this.attributes[i].copy(constant_pool);
            ++i;
        }
        return c;
    }

    public String getCodeString() {
        StringBuffer codeString = new StringBuffer();
        codeString.append("Code(max_stack = ").append(this.maxStack);
        codeString.append(", max_locals = ").append(this.maxLocals);
        codeString.append(", code_length = ").append(this.code.length).append(")\n");
        codeString.append(Utility.codeToString(this.code, this.constantPool, 0, -1, true));
        if (this.exceptionTable.length > 0) {
            codeString.append("\n").append("Exception entries =  ").append(this.exceptionTable.length).append("\n");
            int i = 0;
            while (i < this.exceptionTable.length) {
                CodeException exc = this.exceptionTable[i];
                int type = exc.getCatchType();
                String name = "finally";
                if (type != 0) {
                    name = this.constantPool.getConstantString(type, (byte)7);
                }
                codeString.append(name).append("[");
                codeString.append(exc.getStartPC()).append(">").append(exc.getEndPC()).append("]\n");
                ++i;
            }
        }
        return codeString.toString();
    }
}

