/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.war.util;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.war.util.PathSet;

public class WebappStructure {
    private Map registeredFiles;
    private transient PathSet allFiles = new PathSet();
    private transient WebappStructure cache;

    public WebappStructure() {
        this.registeredFiles = new HashMap();
        this.cache = null;
    }

    public WebappStructure(WebappStructure cache) {
        this.registeredFiles = new HashMap();
        this.cache = cache == null ? new WebappStructure() : cache;
    }

    public boolean isRegistered(String path) {
        return this.getFullStructure().contains(path);
    }

    public boolean registerFile(String id, String path) {
        if (!this.isRegistered(path)) {
            this.doRegister(id, path);
            return true;
        }
        return false;
    }

    public void registerFile(String id, String path, RegistrationCallback callback) throws IOException {
        if (this.isRegistered(path)) {
            callback.refused(id, path, this.getOwner(path));
        } else {
            this.doRegister(id, path);
            if (this.cache.getOwner(path) == null) {
                callback.registered(id, path);
            } else if (this.cache.getOwner(path).equals(id)) {
                callback.alreadyRegistered(id, path);
            } else if (this.getOwners().contains(this.cache.getOwner(path))) {
                callback.superseded(id, path, this.cache.getOwner(path));
            } else {
                callback.supersededUnknownOwner(id, path, this.cache.getOwner(path));
            }
        }
    }

    public String getOwner(String path) {
        if (!this.isRegistered(path)) {
            return null;
        }
        Iterator it = this.registeredFiles.keySet().iterator();
        while (it.hasNext()) {
            String owner = (String)it.next();
            PathSet structure = this.getStructure(owner);
            if (!structure.contains(path)) continue;
            return owner;
        }
        throw new IllegalStateException("Should not happen, path[" + path + "] is flagged as being registered but was not found.");
    }

    public Set getOwners() {
        return this.registeredFiles.keySet();
    }

    public PathSet getFullStructure() {
        return this.allFiles;
    }

    public PathSet getStructure(String id) {
        PathSet pathSet = (PathSet)this.registeredFiles.get(id);
        if (pathSet == null) {
            pathSet = new PathSet();
            this.registeredFiles.put(id, pathSet);
        }
        return pathSet;
    }

    private void doRegister(String id, String path) {
        this.getFullStructure().add(path);
        this.getStructure(id).add(path);
    }

    private Object readResolve() {
        this.allFiles = new PathSet();
        Iterator it = this.registeredFiles.values().iterator();
        while (it.hasNext()) {
            PathSet pathSet = (PathSet)it.next();
            this.allFiles.addAll(pathSet);
        }
        return this;
    }

    public static interface RegistrationCallback {
        public void registered(String var1, String var2) throws IOException;

        public void alreadyRegistered(String var1, String var2) throws IOException;

        public void refused(String var1, String var2, String var3) throws IOException;

        public void superseded(String var1, String var2, String var3) throws IOException;

        public void supersededUnknownOwner(String var1, String var2, String var3) throws IOException;
    }
}

