/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.validator.EmailValidator;
import org.apache.commons.validator.UrlValidator;
import org.apache.maven.reporting.MavenReportRenderer;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractMavenReportRenderer
implements MavenReportRenderer {
    protected Sink sink;
    private int section;

    public AbstractMavenReportRenderer(Sink sink) {
        this.sink = sink;
    }

    public void render() {
        this.sink.head();
        this.sink.title();
        this.text(this.getTitle());
        this.sink.title_();
        this.sink.head_();
        this.sink.body();
        this.renderBody();
        this.sink.body_();
        this.sink.flush();
        this.sink.close();
    }

    protected void startTable() {
        this.sink.table();
    }

    protected void endTable() {
        this.sink.table_();
    }

    protected void startSection(String name) {
        ++this.section;
        switch (this.section) {
            case 1: {
                this.sink.section1();
                this.sink.sectionTitle1();
                break;
            }
            case 2: {
                this.sink.section2();
                this.sink.sectionTitle2();
                break;
            }
            case 3: {
                this.sink.section3();
                this.sink.sectionTitle3();
                break;
            }
            case 4: {
                this.sink.section4();
                this.sink.sectionTitle4();
                break;
            }
            case 5: {
                this.sink.section5();
                this.sink.sectionTitle5();
                break;
            }
        }
        this.text(name);
        switch (this.section) {
            case 1: {
                this.sink.sectionTitle1_();
                break;
            }
            case 2: {
                this.sink.sectionTitle2_();
                break;
            }
            case 3: {
                this.sink.sectionTitle3_();
                break;
            }
            case 4: {
                this.sink.sectionTitle4_();
                break;
            }
            case 5: {
                this.sink.sectionTitle5_();
                break;
            }
        }
    }

    protected void endSection() {
        switch (this.section) {
            case 1: {
                this.sink.section1_();
                break;
            }
            case 2: {
                this.sink.section2_();
                break;
            }
            case 3: {
                this.sink.section3_();
                break;
            }
            case 4: {
                this.sink.section4_();
                break;
            }
            case 5: {
                this.sink.section5_();
                break;
            }
        }
        --this.section;
        if (this.section < 0) {
            throw new IllegalStateException("Too many closing sections");
        }
    }

    protected void tableHeaderCell(String text) {
        this.sink.tableHeaderCell();
        this.text(text);
        this.sink.tableHeaderCell_();
    }

    protected void tableCell(String text) {
        this.tableCell(text, false);
    }

    protected void tableCell(String text, boolean asHtml) {
        this.sink.tableCell();
        if (asHtml) {
            this.sink.rawText(text);
        } else {
            this.linkPatternedText(text);
        }
        this.sink.tableCell_();
    }

    protected void tableRow(String[] content) {
        this.sink.tableRow();
        for (int i = 0; i < content.length; ++i) {
            this.tableCell(content[i]);
        }
        this.sink.tableRow_();
    }

    protected void tableHeader(String[] content) {
        this.sink.tableRow();
        for (int i = 0; i < content.length; ++i) {
            this.tableHeaderCell(content[i]);
        }
        this.sink.tableRow_();
    }

    protected void tableCaption(String caption) {
        this.sink.tableCaption();
        this.text(caption);
        this.sink.tableCaption_();
    }

    protected void paragraph(String paragraph) {
        this.sink.paragraph();
        this.text(paragraph);
        this.sink.paragraph_();
    }

    protected void link(String href, String name) {
        this.sink.link(href);
        this.text(name);
        this.sink.link_();
    }

    protected void text(String text) {
        if (text == null || text.length() == 0) {
            this.sink.text("-");
        } else {
            this.sink.text(text);
        }
    }

    protected void verbatimText(String text) {
        this.sink.verbatim(true);
        this.text(text);
        this.sink.verbatim_();
    }

    protected void verbatimLink(String text, String href) {
        if (StringUtils.isEmpty((String)href)) {
            this.verbatimText(text);
        } else {
            this.sink.verbatim(true);
            this.link(href, text);
            this.sink.verbatim_();
        }
    }

    protected void javaScript(String jsCode) {
        this.sink.rawText("<script type=\"text/javascript\">\n" + jsCode + "</script>");
    }

    public void linkPatternedText(String text) {
        if (StringUtils.isEmpty((String)text)) {
            this.text(text);
        } else {
            Map segments = AbstractMavenReportRenderer.applyPattern(text);
            if (segments == null) {
                this.text(text);
            } else {
                Iterator it = segments.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    String name = (String)entry.getKey();
                    String href = (String)entry.getValue();
                    if (href == null) {
                        this.text(name);
                        continue;
                    }
                    if (AbstractMavenReportRenderer.getValidHref(href) != null) {
                        this.link(AbstractMavenReportRenderer.getValidHref(href), name);
                        continue;
                    }
                    this.text(href);
                }
            }
        }
    }

    protected static String createLinkPatternedText(String text, String href) {
        if (text == null) {
            return text;
        }
        if (href == null) {
            return text;
        }
        StringBuffer sb = new StringBuffer();
        sb.append("{").append(text).append(", ").append(href).append("}");
        return sb.toString();
    }

    protected static String propertiesToString(Properties props) {
        StringBuffer sb = new StringBuffer();
        if (props == null || ((Hashtable)props).isEmpty()) {
            return sb.toString();
        }
        Iterator i = ((Hashtable)props).keySet().iterator();
        while (i.hasNext()) {
            String key = (String)i.next();
            sb.append(key).append("=").append(((Hashtable)props).get(key));
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private static String getValidHref(String href) {
        href = href.trim();
        String[] schemes = new String[]{"http", "https"};
        UrlValidator urlValidator = new UrlValidator(schemes);
        if (EmailValidator.getInstance().isValid(href) || href.indexOf("?") != -1 && EmailValidator.getInstance().isValid(href.substring(0, href.indexOf("?")))) {
            return "mailto:" + href;
        }
        if (href.toLowerCase().startsWith("mailto:")) {
            return href;
        }
        if (urlValidator.isValid(href)) {
            return href;
        }
        String hrefTmp = !href.endsWith("/") ? href + "/index.html" : href + "index.html";
        if (urlValidator.isValid(hrefTmp)) {
            return href;
        }
        if (href.startsWith("./")) {
            if (href.length() > 2) {
                return href.substring(2, href.length());
            }
            return ".";
        }
        return null;
    }

    private static Map applyPattern(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return null;
        }
        LinkedHashMap<String, String> segments = new LinkedHashMap<String, String>();
        if (text.indexOf("${") != -1) {
            int lastComma = text.lastIndexOf(",");
            int lastSemi = text.lastIndexOf("}");
            if (lastComma != -1 && lastSemi != -1) {
                segments.put(text.substring(lastComma + 1, lastSemi).trim(), null);
            } else {
                segments.put(text, null);
            }
            return segments;
        }
        boolean inQuote = false;
        int braceStack = 0;
        int lastOffset = 0;
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\'' && !inQuote) {
                if (i + 1 < text.length() && text.charAt(i + 1) == '\'') {
                    ++i;
                    continue;
                }
                inQuote = true;
                continue;
            }
            switch (ch) {
                case '{': {
                    if (inQuote || braceStack != 0) continue block5;
                    if (i != 0) {
                        segments.put(text.substring(lastOffset, i), null);
                    }
                    lastOffset = i + 1;
                    ++braceStack;
                    continue block5;
                }
                case '}': {
                    if (inQuote || --braceStack != 0) continue block5;
                    String subString = text.substring(lastOffset, i);
                    lastOffset = i + 1;
                    int lastComma = subString.lastIndexOf(",");
                    if (lastComma != -1) {
                        segments.put(subString.substring(0, lastComma).trim(), subString.substring(lastComma + 1).trim());
                        continue block5;
                    }
                    segments.put(subString.substring(0, lastComma).trim(), null);
                    continue block5;
                }
                case '\'': {
                    inQuote = false;
                    continue block5;
                }
            }
        }
        if (!StringUtils.isEmpty((String)text.substring(lastOffset, text.length()))) {
            segments.put(text.substring(lastOffset, text.length()), null);
        }
        if (braceStack != 0) {
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        return Collections.unmodifiableMap(segments);
    }

    public abstract String getTitle();

    protected abstract void renderBody();
}

