/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.deploy;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.deployer.ArtifactDeploymentException;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.deploy.AbstractDeployMojo;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DeployFileMojo
extends AbstractDeployMojo {
    private String groupId;
    private String artifactId;
    private String version;
    private String packaging;
    private String description;
    private File file;
    private String repositoryId;
    private String repositoryLayout;
    private Map repositoryLayouts;
    private String url;
    private ArtifactFactory artifactFactory;
    private ArtifactRepositoryFactory repositoryFactory;
    private File pomFile;
    private boolean generatePom;
    private String classifier;
    private boolean uniqueVersion;

    protected void initProperties() throws MojoExecutionException {
        if (this.pomFile != null) {
            this.generatePom = false;
            Model model = this.readModel(this.pomFile);
            this.processModel(model);
        }
        if (this.groupId == null || this.artifactId == null || this.version == null || this.packaging == null) {
            throw new MojoExecutionException("Missing group, artifact, version, or packaging information");
        }
    }

    public void execute() throws MojoExecutionException {
        ProjectArtifactMetadata metadata;
        this.initProperties();
        if (!this.file.exists()) {
            throw new MojoExecutionException(this.file.getPath() + " not found.");
        }
        ArtifactRepositoryLayout layout = (ArtifactRepositoryLayout)this.repositoryLayouts.get(this.repositoryLayout);
        ArtifactRepository deploymentRepository = this.repositoryFactory.createDeploymentArtifactRepository(this.repositoryId, this.url, layout, this.uniqueVersion);
        String protocol = deploymentRepository.getProtocol();
        if ("".equals(protocol) || protocol == null) {
            throw new MojoExecutionException("No transfer protocol found.");
        }
        Artifact artifact = this.artifactFactory.createArtifactWithClassifier(this.groupId, this.artifactId, this.version, this.packaging, this.classifier);
        if (this.generatePom) {
            metadata = new ProjectArtifactMetadata(artifact, this.generatePomFile());
            artifact.addMetadata((ArtifactMetadata)metadata);
        } else {
            metadata = new ProjectArtifactMetadata(artifact, this.pomFile);
            artifact.addMetadata((ArtifactMetadata)metadata);
        }
        try {
            this.getDeployer().deploy(this.file, artifact, deploymentRepository, this.getLocalRepository());
        }
        catch (ArtifactDeploymentException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void processModel(Model model) {
        Parent parent = model.getParent();
        if (this.groupId == null) {
            if (parent != null && parent.getGroupId() != null) {
                this.groupId = parent.getGroupId();
            }
            if (model.getGroupId() != null) {
                this.groupId = model.getGroupId();
            }
        }
        if (this.artifactId == null && model.getArtifactId() != null) {
            this.artifactId = model.getArtifactId();
        }
        if (this.version == null) {
            this.version = model.getVersion();
            if (this.version == null && parent != null) {
                this.version = parent.getVersion();
            }
        }
        if (this.packaging == null && model.getPackaging() != null) {
            this.packaging = model.getPackaging();
        }
    }

    protected Model readModel(File pomFile) throws MojoExecutionException {
        if (!pomFile.exists()) {
            throw new MojoExecutionException("Specified pomFile does not exist");
        }
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader(pomFile);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            Model model = modelReader.read((Reader)reader);
            return model;
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)e);
        }
        catch (XmlPullParserException e) {
            throw new MojoExecutionException("Error reading specified POM file: " + e.getMessage(), (Exception)((Object)e));
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    private File generatePomFile() throws MojoExecutionException {
        File file;
        XmlStreamWriter fw = null;
        try {
            File tempFile = File.createTempFile("mvninstall", ".pom");
            tempFile.deleteOnExit();
            Model model = new Model();
            model.setModelVersion("4.0.0");
            model.setGroupId(this.groupId);
            model.setArtifactId(this.artifactId);
            model.setVersion(this.version);
            model.setPackaging(this.packaging);
            model.setDescription(this.description);
            fw = WriterFactory.newXmlWriter(tempFile);
            new MavenXpp3Writer().write((Writer)fw, model);
            file = tempFile;
        }
        catch (IOException e) {
            try {
                throw new MojoExecutionException("Error writing temporary pom file: " + e.getMessage(), (Exception)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(fw);
                throw throwable;
            }
        }
        IOUtil.close((Writer)fw);
        return file;
    }

    void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setPackaging(String packaging) {
        this.packaging = packaging;
    }

    void setPomFile(File pomFile) {
        this.pomFile = pomFile;
    }

    String getGroupId() {
        return this.groupId;
    }

    String getArtifactId() {
        return this.artifactId;
    }

    String getVersion() {
        return this.version;
    }

    String getPackaging() {
        return this.packaging;
    }

    File getFile() {
        return this.file;
    }

    String getClassifier() {
        return this.classifier;
    }

    void setClassifier(String classifier) {
        this.classifier = classifier;
    }
}

